/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.hdfs;

import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.MetricsMap;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.store.hdfs.HdfsDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsLocalityReporter
implements SolrInfoBean,
SolrMetricProducer {
    public static final String LOCALITY_BYTES_TOTAL = "locality.bytes.total";
    public static final String LOCALITY_BYTES_LOCAL = "locality.bytes.local";
    public static final String LOCALITY_BYTES_RATIO = "locality.bytes.ratio";
    public static final String LOCALITY_BLOCKS_TOTAL = "locality.blocks.total";
    public static final String LOCALITY_BLOCKS_LOCAL = "locality.blocks.local";
    public static final String LOCALITY_BLOCKS_RATIO = "locality.blocks.ratio";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String hostname;
    private final ConcurrentMap<HdfsDirectory, ConcurrentMap<FileStatus, BlockLocation[]>> cache;
    private final Set<String> metricNames = ConcurrentHashMap.newKeySet();
    private SolrMetricsContext solrMetricsContext;

    public HdfsLocalityReporter() {
        this.cache = new ConcurrentHashMap<HdfsDirectory, ConcurrentMap<FileStatus, BlockLocation[]>>();
    }

    public void setHost(String hostname) {
        this.hostname = hostname;
    }

    @Override
    public String getName() {
        return "hdfs-locality";
    }

    @Override
    public String getDescription() {
        return "Provides metrics for HDFS data locality.";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.OTHER;
    }

    @Override
    public Set<String> getMetricNames() {
        return this.metricNames;
    }

    @Override
    public MetricRegistry getMetricRegistry() {
        return this.solrMetricsContext != null ? this.solrMetricsContext.getMetricRegistry() : null;
    }

    @Override
    public SolrMetricsContext getSolrMetricsContext() {
        return this.solrMetricsContext;
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        this.solrMetricsContext = parentContext.getChildContext(this);
        MetricsMap metricsMap = new MetricsMap((detailed, map) -> {
            long totalBytes = 0L;
            long localBytes = 0L;
            int totalCount = 0;
            int localCount = 0;
            Iterator iterator = this.cache.keySet().iterator();
            while (iterator.hasNext()) {
                HdfsDirectory hdfsDirectory = (HdfsDirectory)((Object)((Object)iterator.next()));
                if (hdfsDirectory.isClosed()) {
                    iterator.remove();
                    continue;
                }
                try {
                    this.refreshDirectory(hdfsDirectory);
                    Map blockMap = (Map)this.cache.get((Object)hdfsDirectory);
                    Iterator iterator2 = blockMap.values().iterator();
                    while (iterator2.hasNext()) {
                        BlockLocation[] locations;
                        for (BlockLocation bl : locations = (BlockLocation[])iterator2.next()) {
                            totalBytes += bl.getLength();
                            ++totalCount;
                            if (!Arrays.asList(bl.getHosts()).contains(this.hostname)) continue;
                            localBytes += bl.getLength();
                            ++localCount;
                        }
                    }
                }
                catch (IOException e) {
                    log.warn("Could not retrieve locality information for {} due to exception: {}", (Object)hdfsDirectory.getHdfsDirPath(), (Object)e);
                }
            }
            map.put(LOCALITY_BYTES_TOTAL, totalBytes);
            map.put(LOCALITY_BYTES_LOCAL, localBytes);
            if (localBytes == 0L) {
                map.put(LOCALITY_BYTES_RATIO, 0);
            } else {
                map.put(LOCALITY_BYTES_RATIO, (double)localBytes / (double)totalBytes);
            }
            map.put(LOCALITY_BLOCKS_TOTAL, totalCount);
            map.put(LOCALITY_BLOCKS_LOCAL, localCount);
            if (localCount == 0) {
                map.put(LOCALITY_BLOCKS_RATIO, 0);
            } else {
                map.put(LOCALITY_BLOCKS_RATIO, (double)localCount / (double)totalCount);
            }
        });
        this.solrMetricsContext.gauge(this, metricsMap, true, "hdfsLocality", this.getCategory().toString(), scope);
    }

    public void registerDirectory(HdfsDirectory dir) {
        log.info("Registering direcotry {} for locality metrics.", (Object)dir.getHdfsDirPath().toString());
        this.cache.put(dir, new ConcurrentHashMap());
    }

    private void refreshDirectory(HdfsDirectory dir) throws IOException {
        Map directoryCache = (Map)this.cache.get((Object)dir);
        Set cachedStatuses = directoryCache.keySet();
        FileSystem fs = dir.getFileSystem();
        FileStatus[] statuses = fs.listStatus(dir.getHdfsDirPath());
        List<FileStatus> statusList = Arrays.asList(statuses);
        log.debug("Updating locality information for: {}", statusList);
        cachedStatuses.retainAll(statusList);
        for (FileStatus status : statusList) {
            if (status.isDirectory() || directoryCache.containsKey(status)) continue;
            BlockLocation[] locations = fs.getFileBlockLocations(status, 0L, status.getLen());
            directoryCache.put(status, locations);
        }
    }
}

