/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.util.List;
import java.util.Map;

enum Type {
    STRING(String.class),
    ARRAY(List.class),
    NUMBER(Number.class),
    INTEGER(Long.class){

        @Override
        boolean isValid(Object o) {
            if (super.isValid(o)) {
                return true;
            }
            try {
                Long.parseLong(String.valueOf(o));
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
    ,
    BOOLEAN(Boolean.class){

        @Override
        boolean isValid(Object o) {
            if (super.isValid(o)) {
                return true;
            }
            try {
                Boolean.parseBoolean(String.valueOf(o));
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
    ,
    ENUM(List.class),
    OBJECT(Map.class),
    NULL(null),
    UNKNOWN(Object.class);

    Class type;

    private Type(Class type) {
        this.type = type;
    }

    boolean isValid(Object o) {
        if (this.type == null) {
            return o == null;
        }
        return this.type.isInstance(o);
    }
}

