/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

final class Reflector {
    Reflector() {
    }

    public static Class getDependent(Field field) {
        ParameterizedType parameterizedType = Reflector.getType(field);
        if (parameterizedType != null) {
            return Reflector.getClass(parameterizedType);
        }
        return Object.class;
    }

    public static Class[] getDependents(Field field) {
        ParameterizedType parameterizedType = Reflector.getType(field);
        if (parameterizedType != null) {
            return Reflector.getClasses(parameterizedType);
        }
        return new Class[0];
    }

    private static ParameterizedType getType(Field field) {
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            return (ParameterizedType)type;
        }
        return null;
    }

    public static Class getReturnDependent(Method method) {
        ParameterizedType parameterizedType = Reflector.getReturnType(method);
        if (parameterizedType != null) {
            return Reflector.getClass(parameterizedType);
        }
        return Object.class;
    }

    public static Class[] getReturnDependents(Method method) {
        ParameterizedType parameterizedType = Reflector.getReturnType(method);
        if (parameterizedType != null) {
            return Reflector.getClasses(parameterizedType);
        }
        return new Class[0];
    }

    private static ParameterizedType getReturnType(Method method) {
        Type type = method.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            return (ParameterizedType)type;
        }
        return null;
    }

    public static Class getParameterDependent(Method method, int n) {
        ParameterizedType parameterizedType = Reflector.getParameterType(method, n);
        if (parameterizedType != null) {
            return Reflector.getClass(parameterizedType);
        }
        return Object.class;
    }

    public static Class[] getParameterDependents(Method method, int n) {
        ParameterizedType parameterizedType = Reflector.getParameterType(method, n);
        if (parameterizedType != null) {
            return Reflector.getClasses(parameterizedType);
        }
        return new Class[0];
    }

    public static Class getParameterDependent(Constructor constructor, int n) {
        ParameterizedType parameterizedType = Reflector.getParameterType(constructor, n);
        if (parameterizedType != null) {
            return Reflector.getClass(parameterizedType);
        }
        return Object.class;
    }

    public static Class[] getParameterDependents(Constructor constructor, int n) {
        ParameterizedType parameterizedType = Reflector.getParameterType(constructor, n);
        if (parameterizedType != null) {
            return Reflector.getClasses(parameterizedType);
        }
        return new Class[0];
    }

    private static ParameterizedType getParameterType(Method method, int n) {
        Type type;
        Type[] typeArray = method.getGenericParameterTypes();
        if (typeArray.length > n && (type = typeArray[n]) instanceof ParameterizedType) {
            return (ParameterizedType)type;
        }
        return null;
    }

    private static ParameterizedType getParameterType(Constructor constructor, int n) {
        Type type;
        Type[] typeArray = constructor.getGenericParameterTypes();
        if (typeArray.length > n && (type = typeArray[n]) instanceof ParameterizedType) {
            return (ParameterizedType)type;
        }
        return null;
    }

    private static Class getClass(ParameterizedType parameterizedType) {
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        if (typeArray.length > 0) {
            return Reflector.getClass(typeArray[0]);
        }
        return null;
    }

    private static Class[] getClasses(ParameterizedType parameterizedType) {
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        Class[] classArray = new Class[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            classArray[i] = Reflector.getClass(typeArray[i]);
        }
        return classArray;
    }

    private static Class getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        return Reflector.getGenericClass(type);
    }

    private static Class getGenericClass(Type type) {
        if (type instanceof GenericArrayType) {
            return Reflector.getArrayClass(type);
        }
        return Object.class;
    }

    private static Class getArrayClass(Type type) {
        GenericArrayType genericArrayType = (GenericArrayType)type;
        Type type2 = genericArrayType.getGenericComponentType();
        Class clazz = Reflector.getClass(type2);
        if (clazz != null) {
            return Array.newInstance(clazz, 0).getClass();
        }
        return null;
    }

    public static String getName(String string) {
        int n = string.length();
        if (n > 0) {
            char[] cArray = string.toCharArray();
            char c = cArray[0];
            if (!Reflector.isAcronym(cArray)) {
                cArray[0] = Reflector.toLowerCase(c);
            }
            return new String(cArray);
        }
        return string;
    }

    private static boolean isAcronym(char[] cArray) {
        if (cArray.length < 2) {
            return false;
        }
        if (!Reflector.isUpperCase(cArray[0])) {
            return false;
        }
        return Reflector.isUpperCase(cArray[1]);
    }

    private static char toLowerCase(char c) {
        return Character.toLowerCase(c);
    }

    private static boolean isUpperCase(char c) {
        return Character.isUpperCase(c);
    }
}

