/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.tika.mime.MediaType;

abstract class ZipContainerDetectorBase {
    static final MediaType TIKA_OOXML = MediaType.application((String)"x-tika-ooxml");
    static final MediaType DOCX = MediaType.application((String)"vnd.openxmlformats-officedocument.wordprocessingml.document");
    static final MediaType DOCM = MediaType.application((String)"vnd.ms-word.document.macroEnabled.12");
    static final MediaType DOTM = MediaType.application((String)"vnd.ms-word.template.macroenabled.12");
    static final MediaType DOTX = MediaType.application((String)"vnd.openxmlformats-officedocument.wordprocessingml.template");
    static final MediaType PPTX = MediaType.application((String)"vnd.openxmlformats-officedocument.presentationml.presentation");
    static final MediaType PPSM = MediaType.application((String)"vnd.ms-powerpoint.slideshow.macroEnabled.12");
    static final MediaType PPSX = MediaType.application((String)"vnd.openxmlformats-officedocument.presentationml.slideshow");
    static final MediaType PPTM = MediaType.application((String)"vnd.ms-powerpoint.presentation.macroEnabled.12");
    static final MediaType POTM = MediaType.application((String)"vnd.ms-powerpoint.template.macroenabled.12");
    static final MediaType POTX = MediaType.application((String)"vnd.openxmlformats-officedocument.presentationml.template");
    static final MediaType THMX = MediaType.application((String)"vnd.openxmlformats-officedocument");
    static final MediaType XLSB = MediaType.application((String)"vnd.ms-excel.sheet.binary.macroenabled.12");
    static final MediaType XLSX = MediaType.application((String)"vnd.openxmlformats-officedocument.spreadsheetml.sheet");
    static final MediaType XLSM = MediaType.application((String)"vnd.ms-excel.sheet.macroEnabled.12");
    static final MediaType XLTM = MediaType.application((String)"vnd.ms-excel.template.macroenabled.12");
    static final MediaType XLTX = MediaType.application((String)"vnd.openxmlformats-officedocument.spreadsheetml.template");
    static final MediaType XLAM = MediaType.application((String)"vnd.ms-excel.addin.macroEnabled.12");
    static final MediaType XPS = MediaType.application((String)"vnd.ms-xpsdocument");
    static final Set<String> OOXML_HINTS = ZipContainerDetectorBase.fillSet("word/document.xml", "_rels/.rels", "[Content_Types].xml", "ppt/presentation.xml", "ppt/slides/slide1.xml", "xl/workbook.xml", "xl/sharedStrings.xml", "xl/worksheets/sheet1.xml");
    private static HashSet<Pattern> ipaEntryPatterns = new HashSet<Pattern>(){
        private static final long serialVersionUID = 6545295886322115362L;
        {
            this.add(Pattern.compile("^Payload/$"));
            this.add(Pattern.compile("^Payload/.*\\.app/$"));
            this.add(Pattern.compile("^Payload/.*\\.app/_CodeSignature/$"));
            this.add(Pattern.compile("^Payload/.*\\.app/_CodeSignature/CodeResources$"));
            this.add(Pattern.compile("^Payload/.*\\.app/Info\\.plist$"));
            this.add(Pattern.compile("^Payload/.*\\.app/PkgInfo$"));
        }
    };

    ZipContainerDetectorBase() {
    }

    private static Set<String> fillSet(String ... args) {
        HashSet<String> tmp = new HashSet<String>();
        for (String arg : args) {
            tmp.add(arg);
        }
        return Collections.unmodifiableSet(tmp);
    }

    static MediaType detectJar(Set<String> entryNames) {
        if (entryNames.contains("META-INF/MANIFEST.MF")) {
            if (entryNames.contains("AndroidManifest.xml")) {
                return MediaType.application((String)"vnd.android.package-archive");
            }
            if (entryNames.contains("WEB-INF/")) {
                return MediaType.application((String)"x-tika-java-web-archive");
            }
            if (entryNames.contains("META-INF/application.xml")) {
                return MediaType.application((String)"x-tika-java-enterprise-archive");
            }
            return MediaType.application((String)"java-archive");
        }
        if (entryNames.contains("AndroidManifest.xml")) {
            return MediaType.application((String)"vnd.android.package-archive");
        }
        return null;
    }

    static MediaType detectKmz(Set<String> entryFileNames) {
        boolean kmlFound = false;
        for (String entryFileName : entryFileNames) {
            if (entryFileName.indexOf(47) != -1 || entryFileName.indexOf(92) != -1) continue;
            if (entryFileName.endsWith(".kml") && !kmlFound) {
                kmlFound = true;
                continue;
            }
            return null;
        }
        if (kmlFound) {
            return MediaType.application((String)"vnd.google-earth.kmz");
        }
        return null;
    }

    static MediaType detectIpa(Set<String> entryNames) {
        Set tmpPatterns = (Set)ipaEntryPatterns.clone();
        for (String entryName : entryNames) {
            Iterator ip = tmpPatterns.iterator();
            while (ip.hasNext()) {
                if (!((Pattern)ip.next()).matcher(entryName).matches()) continue;
                ip.remove();
            }
            if (!tmpPatterns.isEmpty()) continue;
            return MediaType.application((String)"x-itunes-ipa");
        }
        return null;
    }
}

