/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.StrField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.join.GraphQuery;

public class GraphQueryParser
extends QParser {
    public GraphQueryParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() throws SyntaxError {
        SolrParams localParams = this.getLocalParams();
        Query rootNodeQuery = this.subQuery(localParams.get("v"), null).getQuery();
        String traversalFilterS = localParams.get("traversalFilter");
        Query traversalFilter = traversalFilterS == null ? null : this.subQuery(traversalFilterS, null).getQuery();
        String fromField = localParams.get("from", "node_id");
        String toField = localParams.get("to", "edge_ids");
        this.validateFields(fromField);
        this.validateFields(toField);
        boolean onlyLeafNodes = localParams.getBool("returnOnlyLeaf", false);
        boolean returnRootNodes = localParams.getBool("returnRoot", true);
        int maxDepth = localParams.getInt("maxDepth", -1);
        boolean useAutn = localParams.getBool("useAutn", false);
        GraphQuery gq = new GraphQuery(rootNodeQuery, fromField, toField, traversalFilter);
        gq.setMaxDepth(maxDepth);
        gq.setOnlyLeafNodes(onlyLeafNodes);
        gq.setReturnRoot(returnRootNodes);
        gq.setUseAutn(useAutn);
        return gq;
    }

    public void validateFields(String field) throws SyntaxError {
        if (this.req.getSchema().getField(field) == null) {
            throw new SyntaxError("field " + field + " not defined in schema");
        }
        if (this.req.getSchema().getField(field).getType().isPointField()) {
            if (this.req.getSchema().getField(field).hasDocValues()) {
                return;
            }
            throw new SyntaxError("point field " + field + " must have docValues=true");
        }
        if (this.req.getSchema().getField(field).getType() instanceof StrField) {
            if (this.req.getSchema().getField(field).hasDocValues() || this.req.getSchema().getField(field).indexed()) {
                return;
            }
            throw new SyntaxError("string field " + field + " must have indexed=true or docValues=true");
        }
        throw new SyntaxError("FieldType for field=" + field + " not supported");
    }
}

