/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.autoscaling.VersionedData;
import org.apache.solr.client.solrj.impl.BinaryRequestWriter;
import org.apache.solr.common.IteratorWriter;
import org.apache.solr.common.LinkedHashMapWriter;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.MapWriterMap;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SpecProvider;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.ByteUtils;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrJSONWriter;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.common.util.ValidatingJsonMap;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.noggit.CharArr;
import org.noggit.JSONParser;
import org.noggit.JSONWriter;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class Utils {
    public static final Function NEW_HASHMAP_FUN = o -> new HashMap();
    public static final Function NEW_LINKED_HASHMAP_FUN = o -> new LinkedHashMap();
    public static final Function NEW_ATOMICLONG_FUN = o -> new AtomicLong();
    public static final Function NEW_ARRAYLIST_FUN = o -> new ArrayList();
    public static final Function NEW_SYNCHRONIZED_ARRAYLIST_FUN = o -> Collections.synchronizedList(new ArrayList());
    public static final Function NEW_HASHSET_FUN = o -> new HashSet();
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Function<JSONParser, ObjectBuilder> STANDARDOBJBUILDER = jsonParser -> {
        try {
            return new ObjectBuilder((JSONParser)jsonParser);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    };
    public static final Function<JSONParser, ObjectBuilder> MAPWRITEROBJBUILDER = jsonParser -> {
        try {
            return new ObjectBuilder((JSONParser)jsonParser){

                @Override
                public Object newObject() {
                    return new LinkedHashMapWriter();
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    };
    public static final Function<JSONParser, ObjectBuilder> MAPOBJBUILDER = jsonParser -> {
        try {
            return new ObjectBuilder((JSONParser)jsonParser){

                @Override
                public Object newObject() {
                    return new HashMap();
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    };
    public static final Function<Object, String> OBJECT_TO_STRING = obj -> obj instanceof Date ? Objects.toString(((Date)obj).toInstant()) : Objects.toString(obj);
    public static final Pattern ARRAY_ELEMENT_INDEX = Pattern.compile("(\\S*?)\\[([-]?\\d+)\\]");
    public static final InputStreamConsumer<?> JAVABINCONSUMER = is -> new JavaBinCodec().unmarshal(is);
    public static final InputStreamConsumer<?> JSONCONSUMER = Utils::fromJSON;

    public static Map getDeepCopy(Map map, int maxDepth) {
        return Utils.getDeepCopy(map, maxDepth, true, false);
    }

    public static Map getDeepCopy(Map map, int maxDepth, boolean mutable) {
        return Utils.getDeepCopy(map, maxDepth, mutable, false);
    }

    public static Map getDeepCopy(Map map, int maxDepth, boolean mutable, boolean sorted) {
        if (map == null) {
            return null;
        }
        if (maxDepth < 1) {
            return map;
        }
        AbstractMap copy = sorted ? new TreeMap() : (map instanceof LinkedHashMap ? new LinkedHashMap(map.size()) : new HashMap(map.size()));
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry e = o = iterator.next();
            copy.put(e.getKey(), Utils.makeDeepCopy(e.getValue(), maxDepth, mutable, sorted));
        }
        return mutable ? copy : Collections.unmodifiableMap(copy);
    }

    public static void forEachMapEntry(Object o, String path, BiConsumer fun) {
        Object val = Utils.getObjectByPath(o, false, path);
        Utils.forEachMapEntry(val, fun);
    }

    public static void forEachMapEntry(Object o, List<String> path, BiConsumer fun) {
        Object val = Utils.getObjectByPath(o, false, path);
        Utils.forEachMapEntry(val, fun);
    }

    public static void forEachMapEntry(Object o, final BiConsumer fun) {
        if (o instanceof MapWriter) {
            MapWriter m = (MapWriter)o;
            try {
                m.writeMap(new MapWriter.EntryWriter(){

                    @Override
                    public MapWriter.EntryWriter put(CharSequence k, Object v) {
                        fun.accept(k, v);
                        return this;
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (o instanceof Map) {
            ((Map)o).forEach((k, v) -> fun.accept(k, v));
        }
    }

    private static Object makeDeepCopy(Object v, int maxDepth, boolean mutable, boolean sorted) {
        if (v instanceof MapWriter && maxDepth > 1) {
            v = ((MapWriter)v).toMap(new LinkedHashMap<String, Object>());
        } else if (v instanceof IteratorWriter && maxDepth > 1) {
            v = ((IteratorWriter)v).toList(new ArrayList());
            if (sorted) {
                Collections.sort((List)v);
            }
        }
        if (v instanceof Map) {
            v = Utils.getDeepCopy((Map)v, maxDepth - 1, mutable, sorted);
        } else if (v instanceof Collection) {
            v = Utils.getDeepCopy((Collection)v, maxDepth - 1, mutable, sorted);
        }
        return v;
    }

    public static InputStream toJavabin(Object o) throws IOException {
        try (JavaBinCodec jbc = new JavaBinCodec();){
            BinaryRequestWriter.BAOS baos = new BinaryRequestWriter.BAOS();
            jbc.marshal(o, baos);
            ByteBufferInputStream byteBufferInputStream = new ByteBufferInputStream(ByteBuffer.wrap(baos.getbuf(), 0, baos.size()));
            return byteBufferInputStream;
        }
    }

    public static Collection getDeepCopy(Collection c, int maxDepth, boolean mutable) {
        return Utils.getDeepCopy(c, maxDepth, mutable, false);
    }

    public static Collection getDeepCopy(Collection c, int maxDepth, boolean mutable, boolean sorted) {
        if (c == null || maxDepth < 1) {
            return c;
        }
        AbstractCollection result = c instanceof Set ? (sorted ? new TreeSet() : new HashSet()) : new ArrayList();
        for (Object o : c) {
            result.add(Utils.makeDeepCopy(o, maxDepth, mutable, sorted));
        }
        if (sorted && result instanceof List) {
            Collections.sort((List)((Object)result));
        }
        return mutable ? result : (result instanceof Set ? Collections.unmodifiableSet((Set)((Object)result)) : Collections.unmodifiableList((List)((Object)result)));
    }

    public static void writeJson(Object o, OutputStream os, boolean indent) throws IOException {
        Utils.writeJson(o, new OutputStreamWriter(os, StandardCharsets.UTF_8), indent).flush();
    }

    public static Writer writeJson(Object o, Writer writer, boolean indent) throws IOException {
        new SolrJSONWriter(writer).setIndent(indent).writeObj(o).close();
        return writer;
    }

    public static byte[] toJSON(Object o) {
        if (o == null) {
            return new byte[0];
        }
        CharArr out = new CharArr();
        if (!(o instanceof List) && !(o instanceof Map)) {
            if (o instanceof MapWriter) {
                o = ((MapWriter)o).toMap(new LinkedHashMap<String, Object>());
            } else if (o instanceof IteratorWriter) {
                o = ((IteratorWriter)o).toList(new ArrayList());
            }
        }
        new MapWriterJSONWriter(out, 2).write(o);
        return Utils.toUTF8(out);
    }

    public static String toJSONString(Object o) {
        return new String(Utils.toJSON(o), StandardCharsets.UTF_8);
    }

    public static byte[] toUTF8(CharArr out) {
        byte[] arr = new byte[out.size() * 3];
        int nBytes = ByteUtils.UTF16toUTF8(out, 0, out.size(), arr, 0);
        return Arrays.copyOf(arr, nBytes);
    }

    public static Object fromJSON(byte[] utf8) {
        return Utils.fromJSON(utf8, 0, utf8.length);
    }

    public static Object fromJSON(byte[] utf8, int offset, int length) {
        CharArr chars = new CharArr();
        ByteUtils.UTF8toUTF16(utf8, offset, length, chars);
        JSONParser parser = new JSONParser(chars.getArray(), chars.getStart(), chars.length());
        parser.setFlags(parser.getFlags() | 0x40 | 0x80);
        try {
            return STANDARDOBJBUILDER.apply(parser).getValStrict();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> makeMap(Object ... keyVals) {
        return Utils.makeMap(false, keyVals);
    }

    public static Map<String, Object> makeMap(boolean skipNulls, Object ... keyVals) {
        if ((keyVals.length & 1) != 0) {
            throw new IllegalArgumentException("arguments should be key,value");
        }
        LinkedHashMap<String, Object> propMap = new LinkedHashMap<String, Object>(keyVals.length >> 1);
        for (int i = 0; i < keyVals.length; i += 2) {
            Object keyVal = keyVals[i + 1];
            if (skipNulls && keyVal == null) continue;
            propMap.put(keyVals[i].toString(), keyVal);
        }
        return propMap;
    }

    public static Object fromJSON(InputStream is) {
        return Utils.fromJSON(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    public static Object fromJSON(Reader is) {
        try {
            return STANDARDOBJBUILDER.apply(Utils.getJSONParser(is)).getValStrict();
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Parse error", (Throwable)e);
        }
    }

    public static Object fromJSON(InputStream is, Function<JSONParser, ObjectBuilder> objBuilderProvider) {
        try {
            return objBuilderProvider.apply(Utils.getJSONParser(new InputStreamReader(is, StandardCharsets.UTF_8))).getValStrict();
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Parse error", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object fromJSONResource(String resourceName) {
        URL resource = Utils.class.getClassLoader().getResource(resourceName);
        if (null == resource) {
            throw new IllegalArgumentException("invalid resource name: " + resourceName);
        }
        try (InputStream stream = resource.openStream();){
            Object object = Utils.fromJSON(stream);
            return object;
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Resource error: " + e.getMessage(), (Throwable)e);
        }
    }

    public static JSONParser getJSONParser(Reader reader) {
        JSONParser parser = new JSONParser(reader);
        parser.setFlags(parser.getFlags() | 0x40 | 0x80);
        return parser;
    }

    public static Object fromJSONString(String json) {
        try {
            return STANDARDOBJBUILDER.apply(Utils.getJSONParser(new StringReader(json))).getValStrict();
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Parse error : " + json, (Throwable)e);
        }
    }

    public static Object getObjectByPath(Object root, boolean onlyPrimitive, String hierarchy) {
        if (hierarchy == null) {
            return Utils.getObjectByPath(root, onlyPrimitive, Collections.singletonList(null));
        }
        List<String> parts = StrUtils.splitSmart(hierarchy, '/', true);
        return Utils.getObjectByPath(root, onlyPrimitive, parts);
    }

    public static boolean setObjectByPath(Object root, String hierarchy, Object value) {
        List<String> parts = StrUtils.splitSmart(hierarchy, '/', true);
        return Utils.setObjectByPath(root, parts, value);
    }

    public static boolean setObjectByPath(Object root, List<String> hierarchy, Object value) {
        if (root == null) {
            return false;
        }
        if (!Utils.isMapLike(root)) {
            throw new RuntimeException("must be a Map or NamedList");
        }
        Object obj = root;
        for (int i = 0; i < hierarchy.size(); ++i) {
            Object o;
            Matcher matcher;
            int idx = -2;
            String s = hierarchy.get(i);
            if (s.endsWith("]") && (matcher = ARRAY_ELEMENT_INDEX.matcher(s)).find()) {
                s = matcher.group(1);
                idx = Integer.parseInt(matcher.group(2));
            }
            if (i < hierarchy.size() - 1) {
                o = Utils.getVal(obj, s, -1);
                if (o == null) {
                    return false;
                }
                if (idx > -1) {
                    List l = (List)o;
                    Object object = o = idx < l.size() ? (Object)l.get(idx) : null;
                }
                if (!Utils.isMapLike(o)) {
                    return false;
                }
            } else {
                if (idx == -2) {
                    if (obj instanceof NamedList) {
                        NamedList namedList = (NamedList)obj;
                        int location = namedList.indexOf(s, 0);
                        if (location == -1) {
                            namedList.add(s, value);
                        } else {
                            namedList.setVal(location, value);
                        }
                    } else if (obj instanceof Map) {
                        ((Map)obj).put(s, value);
                    }
                    return true;
                }
                Object v = Utils.getVal(obj, s, -1);
                if (v instanceof List) {
                    List list = (List)v;
                    if (idx == -1) {
                        list.add(value);
                    } else if (idx < list.size()) {
                        list.set(idx, value);
                    } else {
                        return false;
                    }
                    return true;
                }
                return false;
            }
            obj = o;
        }
        return false;
    }

    public static Object getObjectByPath(Object root, boolean onlyPrimitive, List<String> hierarchy) {
        if (root == null) {
            return null;
        }
        if (!Utils.isMapLike(root)) {
            return null;
        }
        Object obj = root;
        for (int i = 0; i < hierarchy.size(); ++i) {
            List l;
            Object o;
            Matcher matcher;
            int idx = -1;
            String s = hierarchy.get(i);
            if (s != null && s.endsWith("]") && (matcher = ARRAY_ELEMENT_INDEX.matcher(s)).find()) {
                s = matcher.group(1);
                idx = Integer.parseInt(matcher.group(2));
            }
            if (i < hierarchy.size() - 1) {
                o = Utils.getVal(obj, s, -1);
                if (o == null) {
                    return null;
                }
                if (idx > -1) {
                    if (o instanceof MapWriter) {
                        o = Utils.getVal(o, null, idx);
                    } else if (o instanceof Map) {
                        o = Utils.getVal(new MapWriterMap((Map)o), null, idx);
                    } else {
                        l = (List)o;
                        Object object = o = idx < l.size() ? (Object)l.get(idx) : null;
                    }
                }
                if (!Utils.isMapLike(o)) {
                    return null;
                }
            } else {
                Object val = Utils.getVal(obj, s, -1);
                if (val == null) {
                    return null;
                }
                if (idx > -1) {
                    if (val instanceof IteratorWriter) {
                        val = Utils.getValueAt((IteratorWriter)val, idx);
                    } else {
                        l = (List)val;
                        Object object = val = idx < l.size() ? (Object)l.get(idx) : null;
                    }
                }
                if (onlyPrimitive && Utils.isMapLike(val)) {
                    return null;
                }
                return val;
            }
            obj = o;
        }
        return false;
    }

    private static Object getValueAt(IteratorWriter iteratorWriter, final int idx) {
        final Object[] result = new Object[1];
        try {
            iteratorWriter.writeIter(new IteratorWriter.ItemWriter(){
                int i = -1;

                @Override
                public IteratorWriter.ItemWriter add(Object o) {
                    ++this.i;
                    if (this.i > idx) {
                        return this;
                    }
                    if (this.i == idx) {
                        result[0] = o;
                    }
                    return this;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result[0];
    }

    private static boolean isMapLike(Object o) {
        return o instanceof Map || o instanceof NamedList || o instanceof MapWriter;
    }

    private static Object getVal(Object obj, final String key, final int idx) {
        if (obj instanceof MapWriter) {
            final Object[] result = new Object[1];
            try {
                ((MapWriter)obj).writeMap(new MapWriter.EntryWriter(){
                    int count = -1;

                    @Override
                    public MapWriter.EntryWriter put(CharSequence k, Object v) {
                        if (result[0] != null) {
                            return this;
                        }
                        if (idx < 0) {
                            if (k.equals(key)) {
                                result[0] = v;
                            }
                        } else if (++this.count == idx) {
                            result[0] = new MapWriterEntry<Object>(k, v);
                        }
                        return this;
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return result[0];
        }
        if (obj instanceof Map) {
            return ((Map)obj).get(key);
        }
        throw new RuntimeException("must be a NamedList or Map");
    }

    public static void consumeFully(HttpEntity entity) {
        if (entity != null) {
            try {
                Utils.readFully(entity.getContent());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (IOException iOException) {
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)entity);
            }
        }
    }

    private static void readFully(InputStream is) throws IOException {
        is.skip(is.available());
        while (is.read() != -1) {
        }
    }

    public static Map<String, Object> getJson(DistribStateManager distribStateManager, String path) throws InterruptedException, IOException, KeeperException {
        VersionedData data = null;
        try {
            data = distribStateManager.getData(path);
        }
        catch (NoSuchElementException | KeeperException.NoNodeException e) {
            return Collections.emptyMap();
        }
        if (data == null || data.getData() == null || data.getData().length == 0) {
            return Collections.emptyMap();
        }
        return (Map)Utils.fromJSON(data.getData());
    }

    public static Map<String, Object> getJson(SolrZkClient zkClient, String path, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        try {
            byte[] bytes = zkClient.getData(path, null, null, retryOnConnLoss);
            if (bytes != null && bytes.length > 0) {
                return (Map)Utils.fromJSON(bytes);
            }
        }
        catch (KeeperException.NoNodeException e) {
            return Collections.emptyMap();
        }
        return Collections.emptyMap();
    }

    public static SpecProvider getSpec(String name) {
        return () -> ValidatingJsonMap.parse("apispec/" + name + ".json", "apispec/");
    }

    public static String parseMetricsReplicaName(String collectionName, String coreName) {
        if (collectionName == null || !coreName.startsWith(collectionName)) {
            return null;
        }
        if (coreName.length() > collectionName.length()) {
            String str = coreName.substring(collectionName.length() + 1);
            int pos = str.lastIndexOf("_replica");
            if (pos == -1) {
                return str;
            }
            return str.substring(pos + 1);
        }
        return null;
    }

    public static boolean mergeJson(Map<String, Object> sink, Map<String, Object> input) {
        boolean isModified = false;
        for (Map.Entry<String, Object> e : input.entrySet()) {
            if (sink.get(e.getKey()) != null) {
                Object sinkVal = sink.get(e.getKey());
                if (e.getValue() == null) {
                    sink.remove(e.getKey());
                    isModified = true;
                    continue;
                }
                if (e.getValue() instanceof Map) {
                    Map mapInputVal = (Map)e.getValue();
                    if (sinkVal instanceof Map) {
                        if (!Utils.mergeJson((Map)sinkVal, mapInputVal)) continue;
                        isModified = true;
                        continue;
                    }
                    sink.put(e.getKey(), mapInputVal);
                    isModified = true;
                    continue;
                }
                sink.put(e.getKey(), e.getValue());
                isModified = true;
                continue;
            }
            if (e.getValue() == null) continue;
            sink.put(e.getKey(), e.getValue());
            isModified = true;
        }
        return isModified;
    }

    public static String getBaseUrlForNodeName(String nodeName, String urlScheme) {
        int _offset = nodeName.indexOf("_");
        if (_offset < 0) {
            throw new IllegalArgumentException("nodeName does not contain expected '_' separator: " + nodeName);
        }
        String hostAndPort = nodeName.substring(0, _offset);
        try {
            String path = URLDecoder.decode(nodeName.substring(1 + _offset), "UTF-8");
            return urlScheme + "://" + hostAndPort + (path.isEmpty() ? "" : "/" + path);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JVM Does not seem to support UTF-8", e);
        }
    }

    public static long time(TimeSource timeSource, TimeUnit unit) {
        return unit.convert(timeSource.getTimeNs(), TimeUnit.NANOSECONDS);
    }

    public static long timeElapsed(TimeSource timeSource, long start, TimeUnit unit) {
        return unit.convert(timeSource.getTimeNs() - TimeUnit.NANOSECONDS.convert(start, unit), TimeUnit.NANOSECONDS);
    }

    public static String getMDCNode() {
        String s = MDC.get((String)"node_name");
        if (s == null) {
            return null;
        }
        if (s.startsWith("n:")) {
            return s.substring(2);
        }
        return null;
    }

    public static <T> T handleExp(Logger logger, T def, Callable<T> c) {
        try {
            return c.call();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return def;
        }
    }

    public static InputStreamConsumer<ByteBuffer> newBytesConsumer(int maxSize) {
        return is -> {
            try (BinaryRequestWriter.BAOS bos = new BinaryRequestWriter.BAOS();){
                long sz = 0L;
                int next = is.read();
                while (next > -1) {
                    if (++sz > (long)maxSize) {
                        throw new BufferOverflowException();
                    }
                    bos.write(next);
                    next = is.read();
                }
                bos.flush();
                ByteBuffer byteBuffer = ByteBuffer.wrap(bos.getbuf(), 0, bos.size());
                return byteBuffer;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T> T executeGET(HttpClient client, String url, InputStreamConsumer<T> consumer) throws SolrException {
        T result = null;
        HttpGet httpGet = new HttpGet(url);
        HttpResponse rsp = null;
        try {
            rsp = client.execute((HttpUriRequest)httpGet);
        }
        catch (IOException e) {
            log.error("Error in request to url : " + url, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.UNKNOWN, "error sending request");
        }
        int statusCode = rsp.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            try {
                log.error("Failed a request to: {}, status: {}, body: {}", new Object[]{url, rsp.getStatusLine(), EntityUtils.toString((HttpEntity)rsp.getEntity(), (Charset)StandardCharsets.UTF_8)});
            }
            catch (IOException e) {
                log.error("could not print error", (Throwable)e);
            }
            throw new SolrException(SolrException.ErrorCode.getErrorCode(statusCode), "Unknown error");
        }
        HttpEntity entity = rsp.getEntity();
        try {
            InputStream is = entity.getContent();
            if (consumer != null) {
                result = consumer.accept(is);
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.UNKNOWN, (Throwable)e);
        }
        finally {
            Utils.consumeFully(entity);
        }
        return result;
    }

    public static interface InputStreamConsumer<T> {
        public T accept(InputStream var1) throws IOException;
    }

    static class MapWriterEntry<V>
    extends AbstractMap.SimpleEntry<CharSequence, V>
    implements MapWriter,
    Map.Entry<CharSequence, V> {
        MapWriterEntry(CharSequence key, V value) {
            super(key, value);
        }

        @Override
        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            ew.put((CharSequence)"key", (CharSequence)this.getKey());
            ew.put((CharSequence)"value", this.getValue());
        }
    }

    private static class MapWriterJSONWriter
    extends JSONWriter {
        public MapWriterJSONWriter(CharArr out, int indentSize) {
            super(out, indentSize);
        }

        @Override
        public void handleUnknownClass(Object o) {
            if (o instanceof MapWriter) {
                Map m = ((MapWriter)o).toMap(new LinkedHashMap<String, Object>());
                this.write(m);
            } else {
                super.handleUnknownClass(o);
            }
        }
    }
}

