/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.codahale.metrics.Gauge;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.LucenePackage;
import org.apache.lucene.util.Constants;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.AdminHandlersProxy;
import org.apache.solr.handler.admin.SolrEnvironment;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.util.RTimer;
import org.apache.solr.util.RedactionUtils;
import org.apache.solr.util.stats.MetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInfoHandler
extends RequestHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PARAM_NODE = "node";
    public static String REDACT_STRING = RedactionUtils.getRedactString();
    private static final String PREVENT_REVERSE_DNS_OF_LOCALHOST_SYSPROP = "solr.dns.prevent.reverse.lookup";
    private String hostname = null;
    private CoreContainer cc;
    private static final long ONE_KB = 1024L;
    private static final long ONE_MB = 0x100000L;
    private static final long ONE_GB = 0x40000000L;

    public SystemInfoHandler() {
        this(null);
    }

    public SystemInfoHandler(CoreContainer cc) {
        this.cc = cc;
        this.initHostname();
    }

    private void initHostname() {
        if (null != System.getProperty(PREVENT_REVERSE_DNS_OF_LOCALHOST_SYSPROP, null)) {
            log.info("Resolving canonical hostname for local host prevented due to '{}' sysprop", (Object)PREVENT_REVERSE_DNS_OF_LOCALHOST_SYSPROP);
            this.hostname = null;
            return;
        }
        RTimer timer = new RTimer();
        try {
            InetAddress addr = InetAddress.getLocalHost();
            this.hostname = addr.getCanonicalHostName();
        }
        catch (Exception e) {
            log.warn("Unable to resolve canonical hostname for local host, possible DNS misconfiguration. Set the 'solr.dns.prevent.reverse.lookup' sysprop to true on startup to prevent future lookups if DNS can not be fixed.", (Throwable)e);
            this.hostname = null;
            return;
        }
        timer.stop();
        if (15000.0 < timer.getTime()) {
            String readableTime = String.format(Locale.ROOT, "%.3f", timer.getTime() / 1000.0);
            log.warn("Resolving canonical hostname for local host took {} seconds, possible DNS misconfiguration. Set the '{}' sysprop to true on startup to prevent future lookups if DNS can not be fixed.", (Object)readableTime, (Object)PREVENT_REVERSE_DNS_OF_LOCALHOST_SYSPROP);
        }
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrEnvironment env;
        boolean solrCloudMode;
        rsp.setHttpCaching(false);
        SolrCore core = req.getCore();
        if (AdminHandlersProxy.maybeProxyToNodes(req, rsp, this.getCoreContainer(req, core))) {
            return;
        }
        if (core != null) {
            rsp.add("core", this.getCoreInfo(core, req.getSchema()));
        }
        rsp.add("mode", (solrCloudMode = this.getCoreContainer(req, core).isZooKeeperAware()) ? "solrcloud" : "std");
        if (solrCloudMode) {
            rsp.add("zkHost", this.getCoreContainer(req, core).getZkController().getZkServerAddress());
        }
        if (this.cc != null) {
            rsp.add("solr_home", this.cc.getSolrHome());
        }
        rsp.add("lucene", SystemInfoHandler.getLuceneInfo());
        rsp.add("jvm", SystemInfoHandler.getJvmInfo());
        rsp.add("system", SystemInfoHandler.getSystemInfo());
        if (solrCloudMode) {
            rsp.add(PARAM_NODE, this.getCoreContainer(req, core).getZkController().getNodeName());
        }
        if ((env = SolrEnvironment.getFromSyspropOrClusterprop(solrCloudMode ? this.getCoreContainer((SolrQueryRequest)req, (SolrCore)core).getZkController().zkStateReader : null)).isDefined()) {
            rsp.add("environment", env.getCode());
            if (env.getLabel() != null) {
                rsp.add("environment_label", env.getLabel());
            }
            if (env.getColor() != null) {
                rsp.add("environment_color", env.getColor());
            }
        }
    }

    private CoreContainer getCoreContainer(SolrQueryRequest req, SolrCore core) {
        CoreContainer coreContainer = core != null ? req.getCore().getCoreContainer() : this.cc;
        return coreContainer;
    }

    private SimpleOrderedMap<Object> getCoreInfo(SolrCore core, IndexSchema schema) {
        SimpleOrderedMap info = new SimpleOrderedMap();
        info.add("schema", (Object)(schema != null ? schema.getSchemaName() : "no schema!"));
        info.add("host", (Object)this.hostname);
        info.add("now", (Object)new Date());
        info.add("start", (Object)core.getStartTimeStamp());
        SimpleOrderedMap dirs = new SimpleOrderedMap();
        dirs.add("cwd", (Object)new File(System.getProperty("user.dir")).getAbsolutePath());
        dirs.add("instance", (Object)core.getResourceLoader().getInstancePath().toString());
        try {
            dirs.add("data", (Object)core.getDirectoryFactory().normalize(core.getDataDir()));
        }
        catch (IOException e) {
            log.warn("Problem getting the normalized data directory path", (Throwable)e);
            dirs.add("data", (Object)"N/A");
        }
        dirs.add("dirimpl", (Object)core.getDirectoryFactory().getClass().getName());
        try {
            dirs.add("index", (Object)core.getDirectoryFactory().normalize(core.getIndexDir()));
        }
        catch (IOException e) {
            log.warn("Problem getting the normalized index directory path", (Throwable)e);
            dirs.add("index", (Object)"N/A");
        }
        info.add("directory", (Object)dirs);
        return info;
    }

    public static SimpleOrderedMap<Object> getSystemInfo() {
        SimpleOrderedMap info = new SimpleOrderedMap();
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        info.add("name", (Object)os.getName());
        MetricUtils.addMXBeanMetrics(os, MetricUtils.OS_MXBEAN_CLASSES, null, (name, metric) -> {
            if (info.get(name) == null) {
                info.add(name, ((Gauge)metric).getValue());
            }
        });
        try {
            if (!Constants.WINDOWS) {
                info.add("uname", (Object)SystemInfoHandler.execute("uname -a"));
                info.add("uptime", (Object)SystemInfoHandler.execute("uptime"));
            }
        }
        catch (Exception ex) {
            log.warn("Unable to execute command line tools to get operating system properties.", (Throwable)ex);
        }
        return info;
    }

    private static String execute(String cmd) {
        InputStream in = null;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(cmd);
            in = process.getInputStream();
            String string = IOUtils.toString((Reader)new InputStreamReader(in, Charset.defaultCharset()));
            return string;
        }
        catch (Exception ex) {
            String string = "(error executing: " + cmd + ")";
            return string;
        }
        catch (Error err) {
            if (err.getMessage() != null && (err.getMessage().contains("posix_spawn") || err.getMessage().contains("UNIXProcess"))) {
                log.warn("Error forking command due to JVM locale bug (see https://issues.apache.org/jira/browse/SOLR-6387): " + err.getMessage());
                String string = "(error executing: " + cmd + ")";
                return string;
            }
            throw err;
        }
        finally {
            if (process != null) {
                IOUtils.closeQuietly((OutputStream)process.getOutputStream());
                IOUtils.closeQuietly((InputStream)process.getInputStream());
                IOUtils.closeQuietly((InputStream)process.getErrorStream());
            }
        }
    }

    public static SimpleOrderedMap<Object> getJvmInfo() {
        SimpleOrderedMap jvm = new SimpleOrderedMap();
        String javaVersion = System.getProperty("java.specification.version", "unknown");
        String javaVendor = System.getProperty("java.specification.vendor", "unknown");
        String javaName = System.getProperty("java.specification.name", "unknown");
        String jreVersion = System.getProperty("java.version", "unknown");
        String jreVendor = System.getProperty("java.vendor", "unknown");
        String vmVersion = System.getProperty("java.vm.version", "unknown");
        String vmVendor = System.getProperty("java.vm.vendor", "unknown");
        String vmName = System.getProperty("java.vm.name", "unknown");
        jvm.add("version", (Object)(jreVersion + " " + vmVersion));
        jvm.add("name", (Object)(jreVendor + " " + vmName));
        SimpleOrderedMap java = new SimpleOrderedMap();
        java.add("vendor", (Object)javaVendor);
        java.add("name", (Object)javaName);
        java.add("version", (Object)javaVersion);
        jvm.add("spec", (Object)java);
        SimpleOrderedMap jre = new SimpleOrderedMap();
        jre.add("vendor", (Object)jreVendor);
        jre.add("version", (Object)jreVersion);
        jvm.add("jre", (Object)jre);
        SimpleOrderedMap vm = new SimpleOrderedMap();
        vm.add("vendor", (Object)vmVendor);
        vm.add("name", (Object)vmName);
        vm.add("version", (Object)vmVersion);
        jvm.add("vm", (Object)vm);
        Runtime runtime = Runtime.getRuntime();
        jvm.add("processors", (Object)runtime.availableProcessors());
        DecimalFormat df = new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(Locale.ROOT));
        SimpleOrderedMap mem = new SimpleOrderedMap();
        SimpleOrderedMap raw = new SimpleOrderedMap();
        long free = runtime.freeMemory();
        long max = runtime.maxMemory();
        long total = runtime.totalMemory();
        long used = total - free;
        double percentUsed = (double)used / (double)max * 100.0;
        raw.add("free", (Object)free);
        mem.add("free", (Object)SystemInfoHandler.humanReadableUnits(free, df));
        raw.add("total", (Object)total);
        mem.add("total", (Object)SystemInfoHandler.humanReadableUnits(total, df));
        raw.add("max", (Object)max);
        mem.add("max", (Object)SystemInfoHandler.humanReadableUnits(max, df));
        raw.add("used", (Object)used);
        mem.add("used", (Object)(SystemInfoHandler.humanReadableUnits(used, df) + " (%" + df.format(percentUsed) + ")"));
        raw.add("used%", (Object)percentUsed);
        mem.add("raw", (Object)raw);
        jvm.add("memory", (Object)mem);
        SimpleOrderedMap jmx = new SimpleOrderedMap();
        try {
            RuntimeMXBean mx = ManagementFactory.getRuntimeMXBean();
            if (mx.isBootClassPathSupported()) {
                jmx.add("bootclasspath", (Object)mx.getBootClassPath());
            }
            jmx.add("classpath", (Object)mx.getClassPath());
            jmx.add("commandLineArgs", SystemInfoHandler.getInputArgumentsRedacted(mx));
            jmx.add("startTime", (Object)new Date(mx.getStartTime()));
            jmx.add("upTimeMS", (Object)mx.getUptime());
        }
        catch (Exception e) {
            log.warn("Error getting JMX properties", (Throwable)e);
        }
        jvm.add("jmx", (Object)jmx);
        return jvm;
    }

    private static SimpleOrderedMap<Object> getLuceneInfo() {
        SimpleOrderedMap info = new SimpleOrderedMap();
        Package p = SolrCore.class.getPackage();
        info.add("solr-spec-version", (Object)p.getSpecificationVersion());
        info.add("solr-impl-version", (Object)p.getImplementationVersion());
        p = LucenePackage.class.getPackage();
        info.add("lucene-spec-version", (Object)p.getSpecificationVersion());
        info.add("lucene-impl-version", (Object)p.getImplementationVersion());
        return info;
    }

    @Override
    public String getDescription() {
        return "Get System Info";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    private static String humanReadableUnits(long bytes, DecimalFormat df) {
        String newSizeAndUnits = bytes / 0x40000000L > 0L ? String.valueOf(df.format((float)bytes / 1.0737418E9f)) + " GB" : (bytes / 0x100000L > 0L ? String.valueOf(df.format((float)bytes / 1048576.0f)) + " MB" : (bytes / 1024L > 0L ? String.valueOf(df.format((float)bytes / 1024.0f)) + " KB" : String.valueOf(bytes) + " bytes"));
        return newSizeAndUnits;
    }

    private static List<String> getInputArgumentsRedacted(RuntimeMXBean mx) {
        LinkedList<String> list = new LinkedList<String>();
        for (String arg : mx.getInputArguments()) {
            if (arg.startsWith("-D") && arg.contains("=") && RedactionUtils.isSystemPropertySensitive(arg.substring(2, arg.indexOf("=")))) {
                list.add(String.format(Locale.ROOT, "%s=%s", arg.substring(0, arg.indexOf("=")), REDACT_STRING));
                continue;
            }
            list.add(arg);
        }
        return list;
    }
}

