/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling.sim;

import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.Cell;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.Variable;
import org.apache.solr.client.solrj.request.CollectionApiMapping;
import org.apache.solr.client.solrj.request.V2Request;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.Utils;
import org.apache.solr.util.RedactionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimUtils {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Set<String> COMMON_REPLICA_TAGS = new HashSet<String>(Arrays.asList(Variable.Type.CORE_IDX.metricsAttribute, Variable.Type.CORE_IDX.tagName, "SEARCHER.searcher.numDocs", "SEARCHER.searcher.maxDoc", "SEARCHER.searcher.indexCommitSize", "QUERY./select.requests", "UPDATE./update.requests"));
    public static final Set<String> COMMON_NODE_TAGS = new HashSet<String>(Arrays.asList(Variable.Type.CORES.tagName, Variable.Type.FREEDISK.tagName, Variable.Type.NODE.tagName, Variable.Type.NODE_ROLE.tagName, Variable.Type.TOTALDISK.tagName, Variable.Type.DISKTYPE.tagName, Variable.Type.HEAPUSAGE.tagName, Variable.Type.HOST.tagName, Variable.Type.IP_1.tagName, Variable.Type.IP_2.tagName, Variable.Type.IP_3.tagName, Variable.Type.IP_4.tagName, Variable.Type.PORT.tagName, Variable.Type.SYSLOADAVG.tagName, "withCollection"));
    private static final Map<String, String> v2v1Mapping = new HashMap<String, String>();

    public static void checkConsistency(SolrCloudManager solrCloudManager, AutoScalingConfig config) throws Exception {
        if (config == null) {
            config = solrCloudManager.getDistribStateManager().getAutoScalingConfig();
        }
        HashSet<String> replicaTags = new HashSet<String>(COMMON_REPLICA_TAGS);
        replicaTags.addAll(config.getPolicy().getPerReplicaAttributes());
        HashMap allReplicas = new HashMap();
        solrCloudManager.getClusterStateProvider().getClusterState().forEachCollection(coll -> coll.getReplicas().forEach(r -> {
            if (allReplicas.containsKey(r.getName())) {
                throw new RuntimeException("duplicate core_node name in clusterState: " + allReplicas.get(r.getName()) + " versus " + r);
            }
            allReplicas.computeIfAbsent(coll.getName(), c -> new HashMap()).put(r.getName(), r);
        }));
        HashMap<String, Map> allReplicaInfos = new HashMap<String, Map>();
        solrCloudManager.getClusterStateProvider().getLiveNodes().forEach(n -> {
            Map infos = solrCloudManager.getNodeStateProvider().getReplicaInfo(n, (Collection)replicaTags);
            infos.forEach((coll, shards) -> shards.forEach((shard, replicas) -> replicas.forEach(r -> {
                if (allReplicaInfos.containsKey(r.getName())) {
                    throw new RuntimeException("duplicate core_node name in NodeStateProvider: " + allReplicaInfos.get(r.getName()) + " versus " + r);
                }
                allReplicaInfos.computeIfAbsent((String)coll, c -> new HashMap()).put(r.getName(), r);
            })));
        });
        if (!allReplicaInfos.keySet().equals(allReplicas.keySet())) {
            Set notInClusterState = allReplicaInfos.keySet().stream().filter(k -> !allReplicas.containsKey(k)).collect(Collectors.toSet());
            Set notInNodeProvider = allReplicas.keySet().stream().filter(k -> !allReplicaInfos.containsKey(k)).collect(Collectors.toSet());
            throw new RuntimeException("Mismatched replica data between ClusterState and NodeStateProvider:\n\tcollection not in ClusterState: " + notInClusterState + "\n\tcollection not in NodeStateProvider: " + notInNodeProvider);
        }
        allReplicaInfos.keySet().forEach(collection -> {
            Map replicas;
            Set csCores;
            Set infosCores = allReplicaInfos.getOrDefault(collection, Collections.emptyMap()).keySet();
            if (!infosCores.equals(csCores = (replicas = allReplicas.getOrDefault(collection, Collections.emptyMap())).keySet())) {
                Set notInClusterState = infosCores.stream().filter(k -> !csCores.contains(k)).collect(Collectors.toSet());
                Set notInNodeProvider = csCores.stream().filter(k -> !infosCores.contains(k) && ((Replica)replicas.get(k)).isActive(solrCloudManager.getClusterStateProvider().getLiveNodes())).collect(Collectors.toSet());
                if (!notInClusterState.isEmpty() || !notInNodeProvider.isEmpty()) {
                    throw new RuntimeException("Mismatched replica data for collection " + collection + " between ClusterState and NodeStateProvider:\n\treplica in NodeStateProvider but not in ClusterState: " + notInClusterState + "\n\treplica in ClusterState but not in NodeStateProvider: " + notInNodeProvider);
                }
            }
        });
        allReplicaInfos.forEach((coll, replicas) -> replicas.forEach((core, ri) -> {
            Number size = (Number)ri.getVariable(Variable.Type.CORE_IDX.metricsAttribute);
            if (size == null && (size = (Number)ri.getVariable(Variable.Type.CORE_IDX.tagName)) == null) {
                throw new RuntimeException("missing replica size information: " + ri);
            }
        }));
    }

    public static Map<String, Object> calculateStats(SolrCloudManager cloudManager, AutoScalingConfig config, boolean verbose) throws Exception {
        ClusterState clusterState = cloudManager.getClusterStateProvider().getClusterState();
        TreeMap collStats = new TreeMap();
        Policy.Session session = config.getPolicy().createSession(cloudManager);
        clusterState.forEachCollection(coll -> {
            Map perColl = collStats.computeIfAbsent(coll.getName(), n -> new LinkedHashMap());
            AtomicInteger numCores = new AtomicInteger();
            HashMap nodes = new HashMap();
            coll.getSlices().forEach(s -> {
                numCores.addAndGet(s.getReplicas().size());
                s.getReplicas().forEach(r -> nodes.computeIfAbsent(r.getNodeName(), n -> new HashMap()).computeIfAbsent(s.getName(), slice -> new AtomicInteger()).incrementAndGet());
            });
            int maxCoresPerNode = 0;
            int minCoresPerNode = 0;
            int maxActualShardsPerNode = 0;
            int minActualShardsPerNode = 0;
            int maxShardReplicasPerNode = 0;
            int minShardReplicasPerNode = 0;
            if (!nodes.isEmpty()) {
                minCoresPerNode = Integer.MAX_VALUE;
                minActualShardsPerNode = Integer.MAX_VALUE;
                minShardReplicasPerNode = Integer.MAX_VALUE;
                for (Map counts : nodes.values()) {
                    int total = counts.values().stream().mapToInt(c -> c.get()).sum();
                    for (AtomicInteger count : counts.values()) {
                        if (count.get() > maxShardReplicasPerNode) {
                            maxShardReplicasPerNode = count.get();
                        }
                        if (count.get() >= minShardReplicasPerNode) continue;
                        minShardReplicasPerNode = count.get();
                    }
                    if (total > maxCoresPerNode) {
                        maxCoresPerNode = total;
                    }
                    if (total < minCoresPerNode) {
                        minCoresPerNode = total;
                    }
                    if (counts.size() > maxActualShardsPerNode) {
                        maxActualShardsPerNode = counts.size();
                    }
                    if (counts.size() >= minActualShardsPerNode) continue;
                    minActualShardsPerNode = counts.size();
                }
            }
            perColl.put("activeShards", coll.getActiveSlices().size());
            perColl.put("inactiveShards", coll.getSlices().size() - coll.getActiveSlices().size());
            perColl.put("rf", coll.getReplicationFactor());
            perColl.put("maxShardsPerNode", coll.getMaxShardsPerNode());
            perColl.put("maxActualShardsPerNode", maxActualShardsPerNode);
            perColl.put("minActualShardsPerNode", minActualShardsPerNode);
            perColl.put("maxShardReplicasPerNode", maxShardReplicasPerNode);
            perColl.put("minShardReplicasPerNode", minShardReplicasPerNode);
            perColl.put("numCores", numCores.get());
            perColl.put("numNodes", nodes.size());
            perColl.put("maxCoresPerNode", maxCoresPerNode);
            perColl.put("minCoresPerNode", minCoresPerNode);
        });
        TreeMap<String, Map> nodeStats = new TreeMap<String, Map>();
        TreeMap<Integer, AtomicInteger> coreStats = new TreeMap<Integer, AtomicInteger>();
        List rows = session.getSortedNodes();
        if (rows.size() != clusterState.getLiveNodes().size()) {
            throw new Exception("Mismatch between autoscaling matrix size (" + rows.size() + ") and liveNodes size (" + clusterState.getLiveNodes().size() + ")");
        }
        for (Row row : rows) {
            Map nodeStat = nodeStats.computeIfAbsent(row.node, n -> new LinkedHashMap());
            nodeStat.put("isLive", row.isLive());
            for (Cell cell : row.getCells()) {
                nodeStat.put(cell.getName(), cell.getValue());
            }
            int cores = ((Number)row.getVal("cores", (Object)0)).intValue();
            coreStats.computeIfAbsent(cores, num -> new AtomicInteger()).incrementAndGet();
            TreeMap collReplicas = new TreeMap();
            AtomicInteger rowCores = new AtomicInteger();
            row.forEachReplica(ri -> rowCores.incrementAndGet());
            if (cores != rowCores.get()) {
                throw new Exception("Mismatch between autoscaling matrix row replicas (" + rowCores.get() + ") and number of cores (" + cores + ")");
            }
            row.forEachReplica(ri -> {
                Map perReplica = collReplicas.computeIfAbsent(ri.getCollection(), c -> new TreeMap()).computeIfAbsent(ri.getCore().substring(ri.getCollection().length() + 1), core -> new LinkedHashMap());
                if (ri.getVariable(Variable.Type.CORE_IDX.metricsAttribute) != null) {
                    perReplica.put(Variable.Type.CORE_IDX.metricsAttribute, ri.getVariable(Variable.Type.CORE_IDX.metricsAttribute));
                    if (ri.getVariable(Variable.Type.CORE_IDX.tagName) != null) {
                        perReplica.put(Variable.Type.CORE_IDX.tagName, ri.getVariable(Variable.Type.CORE_IDX.tagName));
                    } else {
                        perReplica.put(Variable.Type.CORE_IDX.tagName, Variable.Type.CORE_IDX.convertVal(ri.getVariable(Variable.Type.CORE_IDX.metricsAttribute)));
                    }
                }
                perReplica.put("coreNode", ri.getName());
                if (ri.isLeader || ri.getBool("leader", false)) {
                    perReplica.put("leader", true);
                    Double totalSize = (Double)collStats.computeIfAbsent(ri.getCollection(), c -> new HashMap()).computeIfAbsent("avgShardSize", size -> 0.0);
                    Number riSize = (Number)ri.getVariable(Variable.Type.CORE_IDX.metricsAttribute);
                    if (riSize != null) {
                        Double min;
                        totalSize = totalSize + riSize.doubleValue();
                        ((Map)collStats.get(ri.getCollection())).put("avgShardSize", totalSize);
                        Double max = (Double)((Map)collStats.get(ri.getCollection())).get("maxShardSize");
                        if (max == null) {
                            max = 0.0;
                        }
                        if (riSize.doubleValue() > max) {
                            ((Map)collStats.get(ri.getCollection())).put("maxShardSize", riSize.doubleValue());
                        }
                        if ((min = (Double)((Map)collStats.get(ri.getCollection())).get("minShardSize")) == null) {
                            min = Double.MAX_VALUE;
                        }
                        if (riSize.doubleValue() < min) {
                            ((Map)collStats.get(ri.getCollection())).put("minShardSize", riSize.doubleValue());
                        }
                    } else {
                        throw new RuntimeException("ReplicaInfo without size information: " + ri);
                    }
                }
                if (verbose) {
                    nodeStat.put("replicas", collReplicas);
                }
            });
        }
        for (Map perColl : collStats.values()) {
            Number num2;
            Number avg = (Number)perColl.get("avgShardSize");
            if (avg != null) {
                avg = avg.doubleValue() / ((Number)perColl.get("activeShards")).doubleValue();
                perColl.put("avgShardSize", (Number)Variable.Type.CORE_IDX.convertVal((Object)avg));
            }
            if ((num2 = (Number)perColl.get("maxShardSize")) != null) {
                perColl.put("maxShardSize", (Number)Variable.Type.CORE_IDX.convertVal((Object)num2));
            }
            if ((num2 = (Number)perColl.get("minShardSize")) == null) continue;
            perColl.put("minShardSize", (Number)Variable.Type.CORE_IDX.convertVal((Object)num2));
        }
        LinkedHashMap<String, Object> stats = new LinkedHashMap<String, Object>();
        stats.put("coresPerNodes", coreStats);
        stats.put("sortedNodeStats", nodeStats);
        stats.put("collectionStats", collStats);
        return stats;
    }

    public static ModifiableSolrParams v2AdminRequestToV1Params(V2Request req) {
        HashMap reqMap = new HashMap();
        req.toMap(reqMap);
        String path = (String)reqMap.get("path");
        if (!path.startsWith("/c/") || path.length() < 4) {
            throw new UnsupportedOperationException("Unsupported V2 request path: " + reqMap);
        }
        Map cmd = (Map)reqMap.get("command");
        if (cmd.size() != 1) {
            throw new UnsupportedOperationException("Unsupported multi-command V2 request: " + reqMap);
        }
        String a = (String)cmd.keySet().iterator().next();
        ModifiableSolrParams params = new ModifiableSolrParams();
        if (req.getParams() != null) {
            params.add(req.getParams());
        }
        params.add("collection", new String[]{path.substring(3)});
        if (req.getParams() != null) {
            params.add(req.getParams());
        }
        Map reqParams = (Map)cmd.get(a);
        for (Map.Entry e : reqParams.entrySet()) {
            params.add((String)e.getKey(), new String[]{e.getValue().toString()});
        }
        if ((a = v2v1Mapping.get(a)) == null) {
            throw new UnsupportedOperationException("Unsupported V2 request: " + reqMap);
        }
        params.add("action", new String[]{a});
        return params;
    }

    public static RedactionUtils.RedactionContext getRedactionContext(ClusterState clusterState) {
        RedactionUtils.RedactionContext ctx = new RedactionUtils.RedactionContext();
        TreeSet names = new TreeSet(clusterState.getLiveNodes());
        for (String nodeName : names) {
            String urlString = Utils.getBaseUrlForNodeName((String)nodeName, (String)"http");
            try {
                URL u = new URL(urlString);
                String hostPort = u.getHost() + ":" + u.getPort();
                ctx.addName(u.getHost() + ":" + u.getPort(), "N_");
                ctx.addEquivalentName(hostPort, u.getHost() + "_" + u.getPort() + "_", "N_");
            }
            catch (MalformedURLException e) {
                log.warn("Invalid URL for node name " + nodeName + ", replacing including protocol and path", (Throwable)e);
                ctx.addName(urlString, "N_");
                ctx.addEquivalentName(urlString, Utils.getBaseUrlForNodeName((String)nodeName, (String)"https"), "N_");
            }
        }
        names.clear();
        names.addAll(clusterState.getCollectionStates().keySet());
        names.forEach(n -> ctx.addName((String)n, "COLL_"));
        return ctx;
    }

    static {
        for (CollectionApiMapping.Meta meta : CollectionApiMapping.Meta.values()) {
            if (meta.action == null) continue;
            v2v1Mapping.put(meta.commandName, meta.action.toLower());
        }
    }
}

