/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.lang.invoke.MethodHandles;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IntValueFieldType;
import org.apache.solr.update.processor.AllValuesOrNoneFieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.ParseNumericFieldUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseIntFieldUpdateProcessorFactory
extends ParseNumericFieldUpdateProcessorFactory {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return new ParseIntFieldUpdateProcessor(this.getSelector(), this.locale, next);
    }

    @Override
    protected boolean isSchemaFieldTypeCompatible(FieldType type) {
        return type instanceof IntValueFieldType;
    }

    private static final class ParseIntFieldUpdateProcessor
    extends AllValuesOrNoneFieldMutatingUpdateProcessor {
        private final Locale locale;
        private final ThreadLocal<NumberFormat> numberFormat = new ThreadLocal<NumberFormat>(){

            @Override
            protected NumberFormat initialValue() {
                NumberFormat format = NumberFormat.getInstance(locale);
                format.setParseIntegerOnly(true);
                return format;
            }
        };

        ParseIntFieldUpdateProcessor(FieldMutatingUpdateProcessor.FieldNameSelector selector, Locale locale, UpdateRequestProcessor next) {
            super(selector, next);
            this.locale = locale;
        }

        @Override
        protected Object mutateValue(Object srcVal) {
            if (srcVal instanceof CharSequence) {
                String stringVal = srcVal.toString();
                ParsePosition pos = new ParsePosition(0);
                Number number = this.numberFormat.get().parse(stringVal, pos);
                if (pos.getIndex() != stringVal.length()) {
                    log.debug("value '{}' is not parseable, thus not mutated; unparsed chars: '{}'", new Object[]{srcVal, stringVal.substring(pos.getIndex())});
                    return SKIP_FIELD_VALUE_LIST_SINGLETON;
                }
                int intValue = number.intValue();
                if (number.longValue() == (long)intValue) {
                    return intValue;
                }
                log.debug("value '{}' doesn't fit into an Integer, thus was not mutated", srcVal);
                return SKIP_FIELD_VALUE_LIST_SINGLETON;
            }
            if (srcVal instanceof Integer) {
                return srcVal;
            }
            return SKIP_FIELD_VALUE_LIST_SINGLETON;
        }
    }
}

