/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.IndexFingerprint;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.processor.DistributedUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerSync
implements SolrMetricProducer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final boolean debug = log.isDebugEnabled();
    private List<String> replicas;
    private int nUpdates;
    private UpdateHandler uhandler;
    private UpdateLog ulog;
    private HttpShardHandlerFactory shardHandlerFactory;
    private ShardHandler shardHandler;
    private List<SyncShardRequest> requests = new ArrayList<SyncShardRequest>();
    private final boolean cantReachIsSuccess;
    private final boolean doFingerprint;
    private final HttpClient client;
    private final boolean onlyIfActive;
    private SolrCore core;
    private Updater updater;
    private MissedUpdatesFinder missedUpdatesFinder;
    private Timer syncTime;
    private Counter syncErrors;
    private Counter syncSkipped;
    public static Comparator<Long> absComparator = (l1, l2) -> Long.compare(Math.abs(l2), Math.abs(l1));
    public static final String METRIC_SCOPE = "peerSync";

    public PeerSync(SolrCore core, List<String> replicas, int nUpdates, boolean cantReachIsSuccess) {
        this(core, replicas, nUpdates, cantReachIsSuccess, false, true);
    }

    public PeerSync(SolrCore core, List<String> replicas, int nUpdates, boolean cantReachIsSuccess, boolean onlyIfActive, boolean doFingerprint) {
        this.core = core;
        this.replicas = replicas;
        this.nUpdates = nUpdates;
        this.cantReachIsSuccess = cantReachIsSuccess;
        this.doFingerprint = doFingerprint && !"true".equals(System.getProperty("solr.disableFingerprint"));
        this.client = core.getCoreContainer().getUpdateShardHandler().getDefaultHttpClient();
        this.onlyIfActive = onlyIfActive;
        this.uhandler = core.getUpdateHandler();
        this.ulog = this.uhandler.getUpdateLog();
        this.shardHandlerFactory = (HttpShardHandlerFactory)core.getCoreContainer().getShardHandlerFactory();
        this.shardHandler = this.shardHandlerFactory.getShardHandler(this.client);
        this.updater = new Updater(this.msg(), core);
        core.getCoreMetricManager().registerMetricProducer(SolrInfoBean.Category.REPLICATION.toString(), this);
    }

    @Override
    public void initializeMetrics(SolrMetricManager manager, String registry, String tag, String scope) {
        this.syncTime = manager.timer(null, registry, "time", scope, METRIC_SCOPE);
        this.syncErrors = manager.counter(null, registry, "errors", scope, METRIC_SCOPE);
        this.syncSkipped = manager.counter(null, registry, "skipped", scope, METRIC_SCOPE);
    }

    public static long percentile(List<Long> arr, float frac) {
        int elem = (int)((float)arr.size() * frac);
        return Math.abs(arr.get(elem));
    }

    private String msg() {
        ZkController zkController = this.uhandler.core.getCoreContainer().getZkController();
        String myURL = "";
        if (zkController != null) {
            myURL = zkController.getBaseUrl();
        }
        return "PeerSync: core=" + this.uhandler.core.getName() + " url=" + myURL + " ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerSyncResult sync() {
        if (this.ulog == null) {
            this.syncErrors.inc();
            return PeerSyncResult.failure();
        }
        MDCLoggingContext.setCore(this.core);
        Timer.Context timerContext = null;
        try {
            Object srsp;
            List<Long> ourUpdates;
            log.info(this.msg() + "START replicas=" + this.replicas + " nUpdates=" + this.nUpdates);
            if (this.doFingerprint && this.alreadyInSync()) {
                this.syncSkipped.inc();
                PeerSyncResult peerSyncResult = PeerSyncResult.success();
                return peerSyncResult;
            }
            timerContext = this.syncTime.time();
            for (String replica : this.replicas) {
                this.requestVersions(replica);
            }
            try (UpdateLog.RecentUpdates recentUpdates = this.ulog.getRecentUpdates();){
                ourUpdates = recentUpdates.getVersions(this.nUpdates);
            }
            ourUpdates.sort(absComparator);
            if (ourUpdates.size() <= 0) {
                log.info(this.msg() + "DONE.  We have no versions.  sync failed.");
                while ((srsp = this.shardHandler.takeCompletedOrError()) != null) {
                    List otherVersions;
                    if (((ShardResponse)srsp).getException() != null || (otherVersions = (List)((ShardResponse)srsp).getSolrResponse().getResponse().get("versions")) == null || otherVersions.isEmpty()) continue;
                    this.syncErrors.inc();
                    PeerSyncResult peerSyncResult = PeerSyncResult.failure(true);
                    return peerSyncResult;
                }
                this.syncErrors.inc();
                srsp = PeerSyncResult.failure(false);
                return srsp;
            }
            long ourLowThreshold = PeerSync.percentile(ourUpdates, 0.8f);
            long ourHighThreshold = PeerSync.percentile(ourUpdates, 0.2f);
            this.missedUpdatesFinder = new MissedUpdatesFinder(ourUpdates, this.msg(), this.nUpdates, ourLowThreshold, ourHighThreshold);
            while ((srsp = this.shardHandler.takeCompletedOrError()) != null) {
                boolean success = this.handleResponse((ShardResponse)srsp);
                if (success) continue;
                log.info(this.msg() + "DONE. sync failed");
                this.shardHandler.cancelAll();
                this.syncErrors.inc();
                PeerSyncResult peerSyncResult = PeerSyncResult.failure();
                return peerSyncResult;
            }
            boolean success = true;
            for (SyncShardRequest sreq : this.requests) {
                if (!sreq.doFingerprintComparison || (success = this.compareFingerprint(sreq))) continue;
                break;
            }
            log.info(this.msg() + "DONE. sync " + (success ? "succeeded" : "failed"));
            if (!success) {
                this.syncErrors.inc();
            }
            PeerSyncResult peerSyncResult = success ? PeerSyncResult.success() : PeerSyncResult.failure();
            return peerSyncResult;
        }
        finally {
            if (timerContext != null) {
                timerContext.close();
            }
            MDCLoggingContext.clear();
        }
    }

    private boolean alreadyInSync() {
        ShardResponse srsp;
        for (String replica : this.replicas) {
            this.requestFingerprint(replica);
        }
        while ((srsp = this.shardHandler.takeCompletedOrError()) != null) {
            Object replicaFingerprint = null;
            if (srsp.getSolrResponse() != null && srsp.getSolrResponse().getResponse() != null) {
                replicaFingerprint = srsp.getSolrResponse().getResponse().get("fingerprint");
            }
            if (replicaFingerprint == null) {
                log.warn("Replica did not return a fingerprint - possibly an older Solr version or exception");
                continue;
            }
            try {
                IndexFingerprint ourFingerprint;
                IndexFingerprint otherFingerprint = IndexFingerprint.fromObject(replicaFingerprint);
                if (IndexFingerprint.compare(otherFingerprint, ourFingerprint = IndexFingerprint.getFingerprint(this.core, Long.MAX_VALUE)) != 0) continue;
                log.info("We are already in sync. No need to do a PeerSync ");
                return true;
            }
            catch (IOException e) {
                log.warn("Could not confirm if we are already in sync. Continue with PeerSync");
            }
        }
        return false;
    }

    private void requestFingerprint(String replica) {
        SyncShardRequest sreq = new SyncShardRequest();
        this.requests.add(sreq);
        sreq.shards = new String[]{replica};
        sreq.actualShards = sreq.shards;
        sreq.params = new ModifiableSolrParams();
        sreq.params = new ModifiableSolrParams();
        sreq.params.set("qt", new String[]{"/get"});
        sreq.params.set("distrib", false);
        sreq.params.set("getFingerprint", new String[]{String.valueOf(Long.MAX_VALUE)});
        this.shardHandler.submit(sreq, replica, sreq.params);
    }

    private void requestVersions(String replica) {
        SyncShardRequest sreq = new SyncShardRequest();
        this.requests.add(sreq);
        sreq.purpose = 1;
        sreq.shards = new String[]{replica};
        sreq.actualShards = sreq.shards;
        sreq.params = new ModifiableSolrParams();
        sreq.params.set("qt", new String[]{"/get"});
        sreq.params.set("distrib", false);
        sreq.params.set("getVersions", this.nUpdates);
        sreq.params.set("fingerprint", this.doFingerprint);
        this.shardHandler.submit(sreq, replica, sreq.params);
    }

    private boolean handleResponse(ShardResponse srsp) {
        ShardRequest sreq = srsp.getShardRequest();
        if (srsp.getException() != null) {
            if (this.cantReachIsSuccess && sreq.purpose == 1 && srsp.getException() instanceof SolrServerException) {
                Throwable solrException = ((SolrServerException)srsp.getException()).getRootCause();
                boolean connectTimeoutExceptionInChain = this.connectTimeoutExceptionInChain(srsp.getException());
                if (connectTimeoutExceptionInChain || solrException instanceof ConnectException || solrException instanceof ConnectTimeoutException || solrException instanceof NoHttpResponseException || solrException instanceof SocketException) {
                    log.warn(this.msg() + " couldn't connect to " + srsp.getShardAddress() + ", counting as success", srsp.getException());
                    return true;
                }
            }
            if (this.cantReachIsSuccess && sreq.purpose == 1 && srsp.getException() instanceof SolrException && ((SolrException)srsp.getException()).code() == 503) {
                log.warn(this.msg() + " got a 503 from " + srsp.getShardAddress() + ", counting as success", srsp.getException());
                return true;
            }
            if (this.cantReachIsSuccess && sreq.purpose == 1 && srsp.getException() instanceof SolrException && ((SolrException)srsp.getException()).code() == 404) {
                log.warn(this.msg() + " got a 404 from " + srsp.getShardAddress() + ", counting as success. Perhaps /get is not registered?", srsp.getException());
                return true;
            }
            log.warn(this.msg() + " exception talking to " + srsp.getShardAddress() + ", failed", srsp.getException());
            return false;
        }
        if (sreq.purpose == 1) {
            return this.handleVersions(srsp);
        }
        return this.handleUpdates(srsp);
    }

    private boolean connectTimeoutExceptionInChain(Throwable exception) {
        Throwable t = exception;
        while (true) {
            if (t instanceof ConnectTimeoutException) {
                return true;
            }
            Throwable cause = t.getCause();
            if (cause == null) break;
            t = cause;
        }
        return false;
    }

    private boolean canHandleVersionRanges(String replica) {
        SyncShardRequest sreq = new SyncShardRequest();
        this.requests.add(sreq);
        sreq.shards = new String[]{replica};
        sreq.actualShards = sreq.shards;
        sreq.params = new ModifiableSolrParams();
        sreq.params.set("qt", new String[]{"/get"});
        sreq.params.set("distrib", false);
        sreq.params.set("checkCanHandleVersionRanges", false);
        ShardHandler sh = this.shardHandlerFactory.getShardHandler(this.client);
        sh.submit(sreq, replica, sreq.params);
        ShardResponse srsp = sh.takeCompletedIncludingErrors();
        Boolean canHandleVersionRanges = srsp.getSolrResponse().getResponse().getBooleanArg("canHandleVersionRanges");
        return canHandleVersionRanges != null && canHandleVersionRanges != false;
    }

    private boolean handleVersions(ShardResponse srsp) {
        List otherVersions = (List)srsp.getSolrResponse().getResponse().get("versions");
        SyncShardRequest sreq = (SyncShardRequest)srsp.getShardRequest();
        Object fingerprint = srsp.getSolrResponse().getResponse().get("fingerprint");
        log.info(this.msg() + " Received " + otherVersions.size() + " versions from " + sreq.shards[0] + " fingerprint:" + fingerprint);
        if (fingerprint != null) {
            sreq.fingerprint = IndexFingerprint.fromObject(fingerprint);
        }
        if (otherVersions.size() == 0) {
            return true;
        }
        MissedUpdatesRequest updatesRequest = this.missedUpdatesFinder.find(otherVersions, sreq.shards[0], () -> this.core.getSolrConfig().useRangeVersionsForPeerSync && this.canHandleVersionRanges(sreq.shards[0]));
        if (updatesRequest == MissedUpdatesRequest.ALREADY_IN_SYNC) {
            return true;
        }
        if (updatesRequest == MissedUpdatesRequest.UNABLE_TO_SYNC) {
            return false;
        }
        if (updatesRequest == MissedUpdatesRequest.EMPTY) {
            if (this.doFingerprint) {
                sreq.doFingerprintComparison = true;
            }
            return true;
        }
        sreq.totalRequestedUpdates = updatesRequest.totalRequestedUpdates;
        return this.requestUpdates(srsp, updatesRequest.versionsAndRanges, updatesRequest.totalRequestedUpdates);
    }

    private boolean compareFingerprint(SyncShardRequest sreq) {
        if (sreq.fingerprint == null) {
            return true;
        }
        try {
            IndexFingerprint ourFingerprint = IndexFingerprint.getFingerprint(this.core, sreq.fingerprint.getMaxVersionSpecified());
            int cmp = IndexFingerprint.compare(sreq.fingerprint, ourFingerprint);
            log.info("Fingerprint comparison: {}", (Object)cmp);
            if (cmp != 0) {
                log.info("Other fingerprint: {}, Our fingerprint: {}", (Object)sreq.fingerprint, (Object)ourFingerprint);
            }
            return cmp == 0;
        }
        catch (IOException e) {
            log.error(this.msg() + "Error getting index fingerprint", (Throwable)e);
            return false;
        }
    }

    private boolean requestUpdates(ShardResponse srsp, String versionsAndRanges, long totalUpdates) {
        String replica = srsp.getShardRequest().shards[0];
        log.info(this.msg() + "Requesting updates from " + replica + "n=" + totalUpdates + " versions=" + versionsAndRanges);
        ShardRequest sreq = srsp.getShardRequest();
        sreq.purpose = 0;
        sreq.params = new ModifiableSolrParams();
        sreq.params.set("qt", new String[]{"/get"});
        sreq.params.set("distrib", false);
        sreq.params.set("getUpdates", new String[]{versionsAndRanges});
        sreq.params.set("onlyIfActive", this.onlyIfActive);
        sreq.params.set("fingerprint", this.doFingerprint);
        sreq.responses.clear();
        this.shardHandler.submit(sreq, sreq.shards[0], sreq.params);
        return true;
    }

    private boolean handleUpdates(ShardResponse srsp) {
        List updates = (List)srsp.getSolrResponse().getResponse().get("updates");
        SyncShardRequest sreq = (SyncShardRequest)srsp.getShardRequest();
        if ((long)updates.size() < sreq.totalRequestedUpdates) {
            log.error(this.msg() + " Requested " + sreq.totalRequestedUpdates + " updates from " + sreq.shards[0] + " but retrieved " + updates.size());
            return false;
        }
        Object fingerprint = srsp.getSolrResponse().getResponse().get("fingerprint");
        if (fingerprint != null) {
            sreq.fingerprint = IndexFingerprint.fromObject(fingerprint);
        }
        try {
            this.updater.applyUpdates(updates, sreq.shards);
        }
        catch (Exception e) {
            sreq.updateException = e;
            return false;
        }
        return this.compareFingerprint(sreq);
    }

    public static class MissedUpdatesRequest {
        static final MissedUpdatesRequest UNABLE_TO_SYNC = new MissedUpdatesRequest();
        static final MissedUpdatesRequest ALREADY_IN_SYNC = new MissedUpdatesRequest();
        public static final MissedUpdatesRequest EMPTY = new MissedUpdatesRequest();
        String versionsAndRanges;
        long totalRequestedUpdates;

        private MissedUpdatesRequest() {
        }

        public static MissedUpdatesRequest of(String versionsAndRanges, long totalRequestedUpdates) {
            if (totalRequestedUpdates == 0L) {
                return EMPTY;
            }
            return new MissedUpdatesRequest(versionsAndRanges, totalRequestedUpdates);
        }

        MissedUpdatesRequest(String versionsAndRanges, long totalRequestedUpdates) {
            this.versionsAndRanges = versionsAndRanges;
            this.totalRequestedUpdates = totalRequestedUpdates;
        }
    }

    public static class MissedUpdatesFinder
    extends MissedUpdatesFinderBase {
        private long ourHighThreshold;
        private long ourHighest;
        private String logPrefix;
        private long nUpdates;

        MissedUpdatesFinder(List<Long> ourUpdates, String logPrefix, long nUpdates, long ourLowThreshold, long ourHighThreshold) {
            super(ourUpdates, ourLowThreshold);
            this.logPrefix = logPrefix;
            this.ourHighThreshold = ourHighThreshold;
            this.ourHighest = ourUpdates.get(0);
            this.nUpdates = nUpdates;
        }

        public MissedUpdatesRequest find(List<Long> otherVersions, Object updateFrom, Supplier<Boolean> canHandleVersionRanges) {
            otherVersions.sort(absComparator);
            if (debug) {
                log.debug("{} sorted versions from {} = {}", new Object[]{this.logPrefix, otherVersions, updateFrom});
            }
            long otherHigh = PeerSync.percentile(otherVersions, 0.2f);
            long otherLow = PeerSync.percentile(otherVersions, 0.8f);
            long otherHighest = otherVersions.get(0);
            if (this.ourHighThreshold < otherLow) {
                log.info("{} Our versions are too old. ourHighThreshold={} otherLowThreshold={} ourHighest={} otherHighest={}", new Object[]{this.logPrefix, this.ourHighThreshold, otherLow, this.ourHighest, otherHighest});
                return MissedUpdatesRequest.UNABLE_TO_SYNC;
            }
            if (this.ourLowThreshold > otherHigh && this.ourHighest >= otherHighest) {
                log.info("{} Our versions are newer. ourHighThreshold={} otherLowThreshold={} ourHighest={} otherHighest={}", new Object[]{this.logPrefix, this.ourHighThreshold, otherLow, this.ourHighest, otherHighest});
                return MissedUpdatesRequest.ALREADY_IN_SYNC;
            }
            boolean completeList = (long)otherVersions.size() < this.nUpdates;
            MissedUpdatesRequest updatesRequest = canHandleVersionRanges.get() != false ? this.handleVersionsWithRanges(otherVersions, completeList) : this.handleIndividualVersions(otherVersions, completeList);
            if (updatesRequest.totalRequestedUpdates > this.nUpdates) {
                log.info("{} PeerSync will fail because number of missed updates is more than:{}", (Object)this.logPrefix, (Object)this.nUpdates);
                return MissedUpdatesRequest.UNABLE_TO_SYNC;
            }
            if (updatesRequest == MissedUpdatesRequest.EMPTY) {
                log.info("{} No additional versions requested. ourHighThreshold={} otherLowThreshold={} ourHighest={} otherHighest={}", new Object[]{this.logPrefix, this.ourHighThreshold, otherLow, this.ourHighest, otherHighest});
            }
            return updatesRequest;
        }
    }

    static abstract class MissedUpdatesFinderBase {
        private Set<Long> ourUpdateSet;
        private Set<Long> requestedUpdateSet = new HashSet<Long>();
        long ourLowThreshold;
        List<Long> ourUpdates;

        MissedUpdatesFinderBase(List<Long> ourUpdates, long ourLowThreshold) {
            assert (this.sorted(ourUpdates));
            this.ourUpdates = ourUpdates;
            this.ourUpdateSet = new HashSet<Long>(ourUpdates);
            this.ourLowThreshold = ourLowThreshold;
        }

        private boolean sorted(List<Long> list) {
            long prev = Long.MAX_VALUE;
            for (long a : list) {
                if (Math.abs(a) > prev) {
                    return false;
                }
                prev = Math.abs(a);
            }
            return true;
        }

        MissedUpdatesRequest handleVersionsWithRanges(List<Long> otherVersions, boolean completeList) {
            ArrayList<String> rangesToRequest = new ArrayList<String>();
            int ourUpdatesIndex = this.ourUpdates.size() - 1;
            int otherUpdatesIndex = otherVersions.size() - 1;
            long totalRequestedVersions = 0L;
            while (otherUpdatesIndex >= 0) {
                if (ourUpdatesIndex < 0) {
                    String range = otherVersions.get(otherUpdatesIndex) + "..." + otherVersions.get(0);
                    rangesToRequest.add(range);
                    totalRequestedVersions += (long)(otherUpdatesIndex + 1);
                    break;
                }
                if (!completeList && Math.abs(otherVersions.get(otherUpdatesIndex)) < this.ourLowThreshold) break;
                if (this.ourUpdates.get(ourUpdatesIndex).longValue() == otherVersions.get(otherUpdatesIndex).longValue()) {
                    --ourUpdatesIndex;
                    --otherUpdatesIndex;
                    continue;
                }
                if (Math.abs(this.ourUpdates.get(ourUpdatesIndex)) < Math.abs(otherVersions.get(otherUpdatesIndex))) {
                    --ourUpdatesIndex;
                    continue;
                }
                long rangeStart = otherVersions.get(otherUpdatesIndex);
                while (otherUpdatesIndex < otherVersions.size() && Math.abs(otherVersions.get(otherUpdatesIndex)) < Math.abs(this.ourUpdates.get(ourUpdatesIndex))) {
                    --otherUpdatesIndex;
                    ++totalRequestedVersions;
                }
                rangesToRequest.add(rangeStart + "..." + otherVersions.get(otherUpdatesIndex + 1));
            }
            String rangesToRequestStr = rangesToRequest.stream().collect(Collectors.joining(","));
            return MissedUpdatesRequest.of(rangesToRequestStr, totalRequestedVersions);
        }

        MissedUpdatesRequest handleIndividualVersions(List<Long> otherVersions, boolean completeList) {
            ArrayList<Long> toRequest = new ArrayList<Long>();
            for (Long otherVersion : otherVersions) {
                if (!completeList && Math.abs(otherVersion) < this.ourLowThreshold) break;
                if (this.ourUpdateSet.contains(otherVersion) || this.requestedUpdateSet.contains(otherVersion)) continue;
                toRequest.add(otherVersion);
                this.requestedUpdateSet.add(otherVersion);
            }
            return MissedUpdatesRequest.of(StrUtils.join(toRequest, (char)','), toRequest.size());
        }
    }

    static class Updater {
        private static final Comparator<Object> updateRecordComparator = (o1, o2) -> {
            if (!(o1 instanceof List)) {
                return 1;
            }
            if (!(o2 instanceof List)) {
                return -1;
            }
            List lst1 = (List)o1;
            List lst2 = (List)o2;
            long l1 = Math.abs((Long)lst1.get(1));
            long l2 = Math.abs((Long)lst2.get(1));
            return Long.compare(l1, l2);
        };
        private String logPrefix;
        private SolrCore solrCore;

        Updater(String logPrefix, SolrCore solrCore) {
            this.logPrefix = logPrefix;
            this.solrCore = solrCore;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void applyUpdates(List<Object> updates, Object updateFrom) throws Exception {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("update.distrib", new String[]{DistributedUpdateProcessor.DistribPhase.FROMLEADER.toString()});
            params.set("peersync", true);
            LocalSolrQueryRequest req = new LocalSolrQueryRequest(this.solrCore, (SolrParams)params);
            SolrQueryResponse rsp = new SolrQueryResponse();
            UpdateRequestProcessorChain processorChain = req.getCore().getUpdateProcessingChain(null);
            UpdateRequestProcessor proc = processorChain.createProcessor(req, rsp);
            updates.sort(updateRecordComparator);
            Object o = null;
            long lastVersion = 0L;
            try {
                int oper;
                Iterator<Object> iterator = updates.iterator();
                block21: while (iterator.hasNext()) {
                    Object obj;
                    o = obj = iterator.next();
                    List entry = (List)o;
                    if (debug) {
                        log.debug(this.logPrefix + "raw update record " + o);
                    }
                    oper = (Integer)entry.get(0) & 0xF;
                    long version = (Long)entry.get(1);
                    if (version == lastVersion && version != 0L) continue;
                    lastVersion = version;
                    switch (oper) {
                        case 1: {
                            SolrInputDocument sdoc = (SolrInputDocument)entry.get(entry.size() - 1);
                            UpdateCommand cmd = new AddUpdateCommand(req);
                            ((AddUpdateCommand)cmd).solrDoc = sdoc;
                            cmd.setVersion(version);
                            cmd.setFlags(UpdateCommand.PEER_SYNC | UpdateCommand.IGNORE_AUTOCOMMIT);
                            if (debug) {
                                log.debug(this.logPrefix + "add " + cmd + " id " + sdoc.getField("id"));
                            }
                            proc.processAdd((AddUpdateCommand)cmd);
                            continue block21;
                        }
                        case 2: {
                            byte[] idBytes = (byte[])entry.get(2);
                            UpdateCommand cmd = new DeleteUpdateCommand(req);
                            ((DeleteUpdateCommand)cmd).setIndexedId(new BytesRef(idBytes));
                            cmd.setVersion(version);
                            cmd.setFlags(UpdateCommand.PEER_SYNC | UpdateCommand.IGNORE_AUTOCOMMIT);
                            if (debug) {
                                log.debug(this.logPrefix + "delete " + cmd + " " + new BytesRef(idBytes).utf8ToString());
                            }
                            proc.processDelete((DeleteUpdateCommand)cmd);
                            continue block21;
                        }
                        case 3: {
                            String query = (String)entry.get(2);
                            UpdateCommand cmd = new DeleteUpdateCommand(req);
                            ((DeleteUpdateCommand)cmd).query = query;
                            cmd.setVersion(version);
                            cmd.setFlags(UpdateCommand.PEER_SYNC | UpdateCommand.IGNORE_AUTOCOMMIT);
                            if (debug) {
                                log.debug(this.logPrefix + "deleteByQuery " + cmd);
                            }
                            proc.processDelete((DeleteUpdateCommand)cmd);
                            continue block21;
                        }
                        case 8: {
                            AddUpdateCommand cmd = UpdateLog.convertTlogEntryToAddUpdateCommand(req, entry, oper, version);
                            cmd.setFlags(UpdateCommand.PEER_SYNC | UpdateCommand.IGNORE_AUTOCOMMIT);
                            if (debug) {
                                log.debug(this.logPrefix + "inplace update " + cmd + " prevVersion=" + cmd.prevVersion + ", doc=" + cmd.solrDoc);
                            }
                            proc.processAdd(cmd);
                            continue block21;
                        }
                    }
                }
                return;
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown Operation! " + oper);
            }
            catch (IOException e) {
                log.error(this.logPrefix + "Error applying updates from " + updateFrom + " ,update=" + o, (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error(this.logPrefix + "Error applying updates from " + updateFrom + " ,update=" + o, (Throwable)e);
                throw e;
            }
            finally {
                try {
                    proc.finish();
                }
                catch (Exception e) {
                    log.error(this.logPrefix + "Error applying updates from " + updateFrom + " ,finish()", (Throwable)e);
                    throw e;
                }
                finally {
                    IOUtils.closeQuietly((Closeable)proc);
                }
            }
        }
    }

    public static class PeerSyncResult {
        private final boolean success;
        private final Boolean otherHasVersions;

        PeerSyncResult(boolean success, Boolean otherHasVersions) {
            this.success = success;
            this.otherHasVersions = otherHasVersions;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public Optional<Boolean> getOtherHasVersions() {
            return Optional.ofNullable(this.otherHasVersions);
        }

        public static PeerSyncResult success() {
            return new PeerSyncResult(true, null);
        }

        public static PeerSyncResult failure() {
            return new PeerSyncResult(false, null);
        }

        public static PeerSyncResult failure(boolean otherHasVersions) {
            return new PeerSyncResult(false, otherHasVersions);
        }
    }

    private static class SyncShardRequest
    extends ShardRequest {
        IndexFingerprint fingerprint;
        boolean doFingerprintComparison;
        Exception updateException;
        long totalRequestedUpdates;

        private SyncShardRequest() {
        }
    }
}

