/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.uniformsplit.BlockDecoder;
import org.apache.lucene.codecs.uniformsplit.FieldMetadata;
import org.apache.lucene.codecs.uniformsplit.RamUsageUtil;
import org.apache.lucene.codecs.uniformsplit.UniformSplitTerms;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

public class UniformSplitTermsReader
extends FieldsProducer {
    protected static final int VERSION_START = 0;
    private static final long BASE_RAM_USAGE = RamUsageEstimator.shallowSizeOfInstance(UniformSplitTermsReader.class) + RamUsageEstimator.shallowSizeOfInstance(IndexInput.class) * 2L;
    protected final PostingsReaderBase postingsReader;
    protected final IndexInput blockInput;
    protected final IndexInput dictionaryInput;
    protected final Map<String, UniformSplitTerms> fieldToTermsMap;
    protected final Collection<String> sortedFieldNames;

    public UniformSplitTermsReader(PostingsReaderBase postingsReader, SegmentReadState state, BlockDecoder blockDecoder) throws IOException {
        this(postingsReader, state, blockDecoder, "UniformSplit", 0, 0, "ustb", "ustd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected UniformSplitTermsReader(PostingsReaderBase postingsReader, SegmentReadState state, BlockDecoder blockDecoder, String codecName, int versionStart, int versionCurrent, String termsBlocksExtension, String dictionaryExtension) throws IOException {
        IndexInput dictionaryInput = null;
        IndexInput blockInput = null;
        boolean success = false;
        try {
            this.postingsReader = postingsReader;
            String segmentName = state.segmentInfo.name;
            String termsName = IndexFileNames.segmentFileName((String)segmentName, (String)state.segmentSuffix, (String)termsBlocksExtension);
            blockInput = state.directory.openInput(termsName, state.context);
            int version = CodecUtil.checkIndexHeader((DataInput)blockInput, (String)codecName, (int)versionStart, (int)versionCurrent, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            String indexName = IndexFileNames.segmentFileName((String)segmentName, (String)state.segmentSuffix, (String)dictionaryExtension);
            dictionaryInput = state.directory.openInput(indexName, state.context);
            CodecUtil.checkIndexHeader((DataInput)dictionaryInput, (String)codecName, (int)version, (int)version, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            CodecUtil.checksumEntireFile((IndexInput)dictionaryInput);
            postingsReader.init(blockInput, state);
            CodecUtil.retrieveChecksum((IndexInput)blockInput);
            UniformSplitTermsReader.seekFieldsMetadata(blockInput);
            Collection<FieldMetadata> fieldMetadataCollection = UniformSplitTermsReader.parseFieldsMetadata(blockInput, state.fieldInfos);
            this.fieldToTermsMap = new HashMap<String, UniformSplitTerms>();
            this.blockInput = blockInput;
            this.dictionaryInput = dictionaryInput;
            this.fillFieldMap(postingsReader, blockDecoder, dictionaryInput, blockInput, fieldMetadataCollection, state.fieldInfos);
            ArrayList<String> fieldNames = new ArrayList<String>(this.fieldToTermsMap.keySet());
            Collections.sort(fieldNames);
            this.sortedFieldNames = Collections.unmodifiableList(fieldNames);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{blockInput, dictionaryInput});
            throw throwable;
        }
    }

    protected void fillFieldMap(PostingsReaderBase postingsReader, BlockDecoder blockDecoder, IndexInput dictionaryInput, IndexInput blockInput, Collection<FieldMetadata> fieldMetadataCollection, FieldInfos fieldInfos) throws IOException {
        for (FieldMetadata fieldMetadata : fieldMetadataCollection) {
            this.fieldToTermsMap.put(fieldMetadata.getFieldInfo().name, new UniformSplitTerms(dictionaryInput, blockInput, fieldMetadata, postingsReader, blockDecoder));
        }
    }

    protected static Collection<FieldMetadata> parseFieldsMetadata(IndexInput indexInput, FieldInfos fieldInfos) throws IOException {
        ArrayList<FieldMetadata> fieldMetadataCollection = new ArrayList<FieldMetadata>();
        int fieldsNumber = indexInput.readVInt();
        for (int i = 0; i < fieldsNumber; ++i) {
            fieldMetadataCollection.add(FieldMetadata.read((DataInput)indexInput, fieldInfos));
        }
        return fieldMetadataCollection;
    }

    public void close() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{this.blockInput, this.dictionaryInput, this.postingsReader});
        }
        finally {
            this.fieldToTermsMap.clear();
        }
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.blockInput);
        this.postingsReader.checkIntegrity();
    }

    public Iterator<String> iterator() {
        return this.sortedFieldNames.iterator();
    }

    public Terms terms(String field) {
        return this.fieldToTermsMap.get(field);
    }

    public int size() {
        return this.fieldToTermsMap.size();
    }

    public long ramBytesUsed() {
        long ramUsage = BASE_RAM_USAGE;
        ramUsage += this.postingsReader.ramBytesUsed();
        ramUsage += RamUsageUtil.ramBytesUsedByHashMapOfSize(this.fieldToTermsMap.size());
        ramUsage += this.getTermsRamBytesUsed();
        return ramUsage += RamUsageUtil.ramBytesUsedByUnmodifiableArrayListOfSize(this.sortedFieldNames.size());
    }

    protected long getTermsRamBytesUsed() {
        long ramUsage = 0L;
        for (UniformSplitTerms terms : this.fieldToTermsMap.values()) {
            ramUsage += terms.ramBytesUsed();
        }
        return ramUsage;
    }

    protected static void seekFieldsMetadata(IndexInput indexInput) throws IOException {
        indexInput.seek(indexInput.length() - (long)CodecUtil.footerLength() - 8L);
        indexInput.seek(indexInput.readLong());
    }
}

