/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;

public class FieldMetadata
implements Accountable {
    private static final long BASE_RAM_USAGE = RamUsageEstimator.shallowSizeOfInstance(FieldMetadata.class);
    protected final FieldInfo fieldInfo;
    protected final boolean isMutable;
    protected final FixedBitSet docsSeen;
    protected int sumDocFreq;
    protected int numTerms;
    protected int sumTotalTermFreq;
    protected int docCount;
    protected long dictionaryStartFP;
    protected long firstBlockStartFP;
    protected long lastBlockStartFP;
    protected BytesRef lastTerm;

    public FieldMetadata(FieldInfo fieldInfo, int maxDoc) {
        this(fieldInfo, maxDoc, true);
    }

    public FieldMetadata(FieldInfo fieldInfo, int maxDoc, boolean isMutable) {
        this(fieldInfo, maxDoc, isMutable, -1L, -1L, null);
    }

    public FieldMetadata(FieldInfo fieldInfo, int maxDoc, boolean isMutable, long firstBlockStartFP, long lastBlockStartFP, BytesRef lastTerm) {
        assert (isMutable || maxDoc == 0);
        this.fieldInfo = fieldInfo;
        this.isMutable = isMutable;
        this.docsSeen = isMutable ? new FixedBitSet(maxDoc) : null;
        this.dictionaryStartFP = -1L;
        this.firstBlockStartFP = firstBlockStartFP;
        this.lastBlockStartFP = lastBlockStartFP;
        this.lastTerm = lastTerm;
    }

    public void updateStats(BlockTermState state) {
        assert (this.isMutable);
        assert (state.docFreq > 0);
        this.sumDocFreq += state.docFreq;
        if (state.totalTermFreq > 0L) {
            this.sumTotalTermFreq = (int)((long)this.sumTotalTermFreq + state.totalTermFreq);
        }
        ++this.numTerms;
    }

    public FixedBitSet getDocsSeen() {
        return this.docsSeen;
    }

    public FieldInfo getFieldInfo() {
        return this.fieldInfo;
    }

    public int getSumDocFreq() {
        return this.sumDocFreq;
    }

    public int getNumTerms() {
        return this.numTerms;
    }

    public int getSumTotalTermFreq() {
        return this.sumTotalTermFreq;
    }

    public int getDocCount() {
        return this.isMutable ? this.docsSeen.cardinality() : this.docCount;
    }

    public long getFirstBlockStartFP() {
        return this.firstBlockStartFP;
    }

    public void setFirstBlockStartFP(long firstBlockStartFP) {
        assert (this.isMutable);
        this.firstBlockStartFP = firstBlockStartFP;
    }

    public long getLastBlockStartFP() {
        return this.lastBlockStartFP;
    }

    public void setLastBlockStartFP(long lastBlockStartFP) {
        assert (this.isMutable);
        this.lastBlockStartFP = lastBlockStartFP;
    }

    public long getDictionaryStartFP() {
        return this.dictionaryStartFP;
    }

    public void setDictionaryStartFP(long dictionaryStartFP) {
        assert (this.isMutable);
        this.dictionaryStartFP = dictionaryStartFP;
    }

    public void setLastTerm(BytesRef lastTerm) {
        assert (lastTerm != null);
        this.lastTerm = lastTerm;
    }

    public BytesRef getLastTerm() {
        return this.lastTerm;
    }

    public long ramBytesUsed() {
        return BASE_RAM_USAGE + (this.docsSeen == null ? 0L : this.docsSeen.ramBytesUsed());
    }

    public static FieldMetadata read(DataInput input, FieldInfos fieldInfos) throws IOException {
        int fieldId = input.readVInt();
        FieldMetadata stats = new FieldMetadata(fieldInfos.fieldInfo(fieldId), 0, false);
        stats.numTerms = input.readVInt();
        stats.sumTotalTermFreq = stats.sumDocFreq = input.readVInt();
        if (stats.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0) {
            stats.sumTotalTermFreq += input.readVInt();
            assert (stats.sumTotalTermFreq >= stats.sumDocFreq) : "sumTotalFQ: " + stats.sumTotalTermFreq + " sumDocFQ: " + stats.sumDocFreq;
        }
        stats.docCount = input.readVInt();
        stats.dictionaryStartFP = input.readVLong();
        stats.firstBlockStartFP = input.readVLong();
        stats.lastBlockStartFP = input.readVLong();
        int len = input.readVInt();
        BytesRef lastTerm = new BytesRef(len);
        if (len > 0) {
            input.readBytes(lastTerm.bytes, 0, len);
            lastTerm.length = len;
        }
        stats.setLastTerm(lastTerm);
        return stats;
    }

    public void write(DataOutput output) throws IOException {
        assert (this.dictionaryStartFP >= 0L);
        assert (this.firstBlockStartFP >= 0L);
        assert (this.lastBlockStartFP >= 0L);
        assert (this.numTerms > 0) : "There should be at least one term for field " + this.fieldInfo.name + ": " + this.numTerms;
        assert (this.firstBlockStartFP <= this.lastBlockStartFP) : "start: " + this.firstBlockStartFP + " end: " + this.lastBlockStartFP;
        assert (this.lastTerm != null) : "you must set the last term";
        output.writeVInt(this.fieldInfo.number);
        output.writeVInt(this.numTerms);
        output.writeVInt(this.sumDocFreq);
        if (this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0) {
            assert (this.sumTotalTermFreq >= this.sumDocFreq) : "sumTotalFQ: " + this.sumTotalTermFreq + " sumDocFQ: " + this.sumDocFreq;
            output.writeVInt(this.sumTotalTermFreq - this.sumDocFreq);
        }
        output.writeVInt(this.getDocCount());
        output.writeVLong(this.dictionaryStartFP);
        output.writeVLong(this.firstBlockStartFP);
        output.writeVLong(this.lastBlockStartFP);
        if (this.lastTerm.length > 0) {
            output.writeVInt(this.lastTerm.length);
            output.writeBytes(this.lastTerm.bytes, this.lastTerm.offset, this.lastTerm.length);
        } else {
            output.writeVInt(0);
        }
    }
}

