/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting.listeners;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import com.carrotsearch.randomizedtesting.ReproduceErrorMessageBuilder;
import com.carrotsearch.randomizedtesting.TraceFormatting;
import com.carrotsearch.randomizedtesting.annotations.SuppressForbidden;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class ReproduceInfoPrinter
extends RunListener {
    @SuppressForbidden(value="Legitimate use of syserr.")
    public void testFailure(Failure failure) throws Exception {
        if (failure.getException() instanceof AssumptionViolatedException) {
            return;
        }
        Description d = failure.getDescription();
        StringBuilder b = new StringBuilder();
        b.append("FAILURE  : ").append(d.getDisplayName()).append("\n");
        b.append("Message  : " + failure.getMessage() + "\n");
        b.append("Reproduce: ");
        new ReproduceErrorMessageBuilder(b).appendAllOpts(failure.getDescription());
        b.append("\n");
        b.append("Throwable:\n");
        if (failure.getException() != null) {
            TraceFormatting traces = new TraceFormatting();
            try {
                traces = RandomizedContext.current().getRunner().getTraceFormatting();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            traces.formatThrowable(b, failure.getException());
        }
        System.err.println(b.toString());
    }
}

