/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.codahale.metrics.Timer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.apache.solr.cloud.Stats;
import org.apache.solr.cloud.ZkDistributedQueue;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.Pair;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerTaskQueue
extends ZkDistributedQueue {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String RESPONSE_PREFIX = "qnr-";

    public OverseerTaskQueue(SolrZkClient zookeeper, String dir) {
        this(zookeeper, dir, new Stats());
    }

    public OverseerTaskQueue(SolrZkClient zookeeper, String dir, Stats stats) {
        super(zookeeper, dir, stats);
    }

    public boolean containsTaskWithRequestId(String requestIdKey, String requestId) throws KeeperException, InterruptedException {
        List childNames = this.zookeeper.getChildren(this.dir, null, true);
        this.stats.setQueueLength(childNames.size());
        for (String childName : childNames) {
            if (childName == null || !childName.startsWith("qn-")) continue;
            try {
                ZkNodeProps message;
                byte[] data = this.zookeeper.getData(this.dir + "/" + childName, null, null, true);
                if (data == null || !(message = ZkNodeProps.load((byte[])data)).containsKey(requestIdKey)) continue;
                log.debug("Looking for {}, found {}", message.get(requestIdKey), (Object)requestId);
                if (!message.get(requestIdKey).equals(requestId)) continue;
                return true;
            }
            catch (KeeperException.NoNodeException noNodeException) {
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(QueueEvent event) throws KeeperException, InterruptedException {
        Timer.Context time = this.stats.time(this.dir + "_remove_event");
        try {
            String path = event.getId();
            String responsePath = this.dir + "/" + RESPONSE_PREFIX + path.substring(path.lastIndexOf("-") + 1);
            try {
                this.zookeeper.setData(responsePath, event.getBytes(), true);
            }
            catch (KeeperException.NoNodeException ignored) {
                log.info("Response ZK path: " + responsePath + " doesn't exist.  Requestor may have disconnected from ZooKeeper");
            }
            try {
                this.zookeeper.delete(path, -1, true);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
        }
        finally {
            time.stop();
        }
    }

    private String createData(String path, byte[] data, CreateMode mode) throws KeeperException, InterruptedException {
        while (true) {
            try {
                return this.zookeeper.create(path, data, mode, true);
            }
            catch (KeeperException.NoNodeException e) {
                try {
                    this.zookeeper.create(this.dir, new byte[0], CreateMode.PERSISTENT, true);
                }
                catch (KeeperException.NodeExistsException nodeExistsException) {
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueEvent offer(byte[] data, long timeout) throws KeeperException, InterruptedException {
        Timer.Context time = this.stats.time(this.dir + "_offer");
        try {
            String watchID = this.createResponseNode();
            LatchWatcher watcher = new LatchWatcher();
            Stat stat = this.zookeeper.exists(watchID, (Watcher)watcher, true);
            this.createRequestNode(data, watchID);
            if (stat != null) {
                watcher.await(timeout);
            }
            byte[] bytes = this.zookeeper.getData(watchID, null, null, true);
            QueueEvent event = new QueueEvent(watchID, bytes, watcher.getWatchedEvent());
            this.zookeeper.delete(watchID, -1, true);
            QueueEvent queueEvent = event;
            return queueEvent;
        }
        finally {
            time.stop();
        }
    }

    void createRequestNode(byte[] data, String watchID) throws KeeperException, InterruptedException {
        this.createData(this.dir + "/" + "qn-" + watchID.substring(watchID.lastIndexOf("-") + 1), data, CreateMode.PERSISTENT);
    }

    String createResponseNode() throws KeeperException, InterruptedException {
        return this.createData(this.dir + "/" + RESPONSE_PREFIX, null, CreateMode.EPHEMERAL_SEQUENTIAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueueEvent> peekTopN(int n, Predicate<String> excludeSet, long waitMillis) throws KeeperException, InterruptedException {
        ArrayList<QueueEvent> topN = new ArrayList<QueueEvent>();
        log.debug("Peeking for top {} elements. ExcludeSet: {}", (Object)n, excludeSet);
        Timer.Context time = waitMillis == Long.MAX_VALUE ? this.stats.time(this.dir + "_peekTopN_wait_forever") : this.stats.time(this.dir + "_peekTopN_wait" + waitMillis);
        try {
            for (Pair<String, byte[]> element : this.peekElements(n, waitMillis, child -> !excludeSet.test(this.dir + "/" + child))) {
                topN.add(new QueueEvent(this.dir + "/" + (String)element.first(), (byte[])element.second(), null));
            }
            OverseerTaskQueue.printQueueEventsListElementIds(topN);
            ArrayList<QueueEvent> arrayList = topN;
            return arrayList;
        }
        finally {
            time.stop();
        }
    }

    private static void printQueueEventsListElementIds(ArrayList<QueueEvent> topN) {
        if (log.isDebugEnabled() && !topN.isEmpty()) {
            StringBuilder sb = new StringBuilder("[");
            for (QueueEvent queueEvent : topN) {
                sb.append(queueEvent.getId()).append(", ");
            }
            sb.append("]");
            log.debug("Returning topN elements: {}", (Object)sb.toString());
        }
    }

    public String getTailId() throws KeeperException, InterruptedException {
        TreeSet<String> orderedChildren = this.fetchZkChildren(null);
        for (String headNode : orderedChildren.descendingSet()) {
            if (headNode == null) continue;
            try {
                QueueEvent queueEvent = new QueueEvent(this.dir + "/" + headNode, this.zookeeper.getData(this.dir + "/" + headNode, null, null, true), null);
                return queueEvent.getId();
            }
            catch (KeeperException.NoNodeException noNodeException) {
            }
        }
        return null;
    }

    public static class QueueEvent {
        private WatchedEvent event = null;
        private String id;
        private byte[] bytes;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueueEvent other = (QueueEvent)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        QueueEvent(String id, byte[] bytes, WatchedEvent event) {
            this.id = id;
            this.bytes = bytes;
            this.event = event;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public WatchedEvent getWatchedEvent() {
            return this.event;
        }
    }

    static final class LatchWatcher
    implements Watcher {
        private final Lock lock = new ReentrantLock();
        private final Condition eventReceived = this.lock.newCondition();
        private WatchedEvent event;
        private Watcher.Event.EventType latchEventType;

        LatchWatcher() {
            this(null);
        }

        LatchWatcher(Watcher.Event.EventType eventType) {
            this.latchEventType = eventType;
        }

        public void process(WatchedEvent event) {
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            log.debug("{} fired on path {} state {} latchEventType {}", new Object[]{event.getType(), event.getPath(), event.getState(), this.latchEventType});
            if (this.latchEventType == null || event.getType() == this.latchEventType) {
                this.lock.lock();
                try {
                    this.event = event;
                    this.eventReceived.signalAll();
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        public void await(long timeoutMs) throws InterruptedException {
            assert (timeoutMs > 0L);
            this.lock.lock();
            try {
                if (this.event != null) {
                    return;
                }
                this.eventReceived.await(timeoutMs, TimeUnit.MILLISECONDS);
            }
            finally {
                this.lock.unlock();
            }
        }

        public WatchedEvent getWatchedEvent() {
            return this.event;
        }
    }
}

