/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jvm;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.jvm.ThreadDeadlockDetector;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ThreadStatesGaugeSet
implements MetricSet {
    private static final int STACK_TRACE_DEPTH = 0;
    private final ThreadMXBean threads;
    private final ThreadDeadlockDetector deadlockDetector;

    public ThreadStatesGaugeSet() {
        this(ManagementFactory.getThreadMXBean(), new ThreadDeadlockDetector());
    }

    public ThreadStatesGaugeSet(ThreadMXBean threads, ThreadDeadlockDetector deadlockDetector) {
        this.threads = threads;
        this.deadlockDetector = deadlockDetector;
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Gauge> gauges = new HashMap<String, Gauge>();
        for (Thread.State state : Thread.State.values()) {
            gauges.put(MetricRegistry.name((String)state.toString().toLowerCase(), (String[])new String[]{"count"}), () -> this.getThreadCount(state));
        }
        gauges.put("count", this.threads::getThreadCount);
        gauges.put("daemon.count", this.threads::getDaemonThreadCount);
        gauges.put("deadlock.count", () -> this.deadlockDetector.getDeadlockedThreads().size());
        gauges.put("deadlocks", this.deadlockDetector::getDeadlockedThreads);
        return Collections.unmodifiableMap(gauges);
    }

    private int getThreadCount(Thread.State state) {
        ThreadInfo[] allThreads = this.getThreadInfo();
        int count = 0;
        for (ThreadInfo info : allThreads) {
            if (info == null || info.getThreadState() != state) continue;
            ++count;
        }
        return count;
    }

    ThreadInfo[] getThreadInfo() {
        return this.threads.getThreadInfo(this.threads.getAllThreadIds(), 0);
    }
}

