/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.SolrConstantScoreQuery;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.join.BlockJoinParentQParser;

public class BlockJoinChildQParser
extends BlockJoinParentQParser {
    public BlockJoinChildQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    protected Query createQuery(Query parentListQuery, Query query, String scoreMode) {
        return new ToChildBlockJoinQuery(query, this.getFilter((Query)parentListQuery).filter);
    }

    @Override
    protected String getParentFilterLocalParamName() {
        return "of";
    }

    @Override
    protected Query noClausesQuery() throws SyntaxError {
        Query parents = this.parseParentFilter();
        BooleanQuery notParents = new BooleanQuery.Builder().add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST).add(parents, BooleanClause.Occur.MUST_NOT).build();
        SolrConstantScoreQuery wrapped = new SolrConstantScoreQuery(this.getFilter((Query)notParents));
        wrapped.setCache(false);
        return wrapped;
    }
}

