/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Context;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Converter;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Expression;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Group;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Label;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.LabelMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Repeater;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.UnionException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Type;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.InputNode;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.OutputNode;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.Style;
import java.util.Collections;
import java.util.Map;

class CompositeMapUnion
implements Repeater {
    private final LabelMap elements;
    private final Expression path;
    private final Context context;
    private final Group group;
    private final Style style;
    private final Type type;

    public CompositeMapUnion(Context context, Group group, Expression expression, Type type) {
        this.elements = group.getElements();
        this.style = context.getStyle();
        this.context = context;
        this.group = group;
        this.type = type;
        this.path = expression;
    }

    @Override
    public Object read(InputNode inputNode) {
        String string = inputNode.getName();
        String string2 = this.path.getElement(string);
        Label label = (Label)this.elements.get(string2);
        Converter converter = label.getConverter(this.context);
        return converter.read(inputNode);
    }

    @Override
    public Object read(InputNode inputNode, Object object) {
        String string = inputNode.getName();
        String string2 = this.path.getElement(string);
        Label label = (Label)this.elements.get(string2);
        Converter converter = label.getConverter(this.context);
        return converter.read(inputNode, object);
    }

    @Override
    public boolean validate(InputNode inputNode) {
        String string = inputNode.getName();
        String string2 = this.path.getElement(string);
        Label label = (Label)this.elements.get(string2);
        Converter converter = label.getConverter(this.context);
        return converter.validate(inputNode);
    }

    @Override
    public void write(OutputNode outputNode, Object object) {
        Map map = (Map)object;
        if (this.group.isInline()) {
            if (!map.isEmpty()) {
                this.write(outputNode, map);
            } else if (!outputNode.isCommitted()) {
                outputNode.remove();
            }
        } else {
            this.write(outputNode, map);
        }
    }

    private void write(OutputNode outputNode, Map map) {
        for (Object k : map.keySet()) {
            Object v = map.get(k);
            if (v == null) continue;
            Class<?> clazz = v.getClass();
            Label label = this.group.getLabel(clazz);
            if (label == null) {
                throw new UnionException("Value of %s not declared in %s with annotation %s", clazz, this.type, this.group);
            }
            this.write(outputNode, k, v, label);
        }
    }

    private void write(OutputNode outputNode, Object object, Object object2, Label label) {
        Converter converter = label.getConverter(this.context);
        Map<Object, Object> map = Collections.singletonMap(object, object2);
        if (!label.isInline()) {
            String string = label.getName();
            String string2 = this.style.getElement(string);
            if (!outputNode.isCommitted()) {
                outputNode.setName(string2);
            }
        }
        converter.write(outputNode, map);
    }
}

