/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.tools;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.ViewExpanders;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelHomogeneousShuttle;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.Spool;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Uncollect;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelColumnMapping;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.AggregateRemoveRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCallBinding;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.runtime.PairList;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.ListTransientTable;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlStaticAggFunction;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.calcite.sql.fun.SqlInternalOperators;
import org.apache.calcite.sql.fun.SqlLikeOperator;
import org.apache.calcite.sql.fun.SqlQuantifyOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.TableFunctionReturnTypeInference;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.ImmutableRelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.Holder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Optionality;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Value;

@Value.Enclosing
public class RelBuilder {
    protected final RelOptCluster cluster;
    protected final @Nullable RelOptSchema relOptSchema;
    private final Deque<Frame> stack = new ArrayDeque<Frame>();
    private RexSimplify simplifier;
    private final Config config;
    private final RelOptTable.ViewExpander viewExpander;
    private RelFactories.Struct struct;

    protected RelBuilder(@Nullable Context context, RelOptCluster cluster, @Nullable RelOptSchema relOptSchema) {
        this.cluster = cluster;
        this.relOptSchema = relOptSchema;
        if (context == null) {
            context = Contexts.EMPTY_CONTEXT;
        }
        this.config = RelBuilder.getConfig(context);
        this.viewExpander = RelBuilder.getViewExpander(cluster, context);
        this.struct = Objects.requireNonNull(RelFactories.Struct.fromContext(context));
        RexExecutor executor = context.maybeUnwrap(RexExecutor.class).orElse(Util.first(cluster.getPlanner().getExecutor(), RexUtil.EXECUTOR));
        RelOptPredicateList predicates = RelOptPredicateList.EMPTY;
        this.simplifier = new RexSimplify(cluster.getRexBuilder(), predicates, executor);
    }

    private static RelOptTable.ViewExpander getViewExpander(RelOptCluster cluster, Context context) {
        return context.maybeUnwrap(RelOptTable.ViewExpander.class).orElseGet(() -> ViewExpanders.simpleContext(cluster));
    }

    private static Config getConfig(Context context) {
        Config config = context.maybeUnwrap(Config.class).orElse(Config.DEFAULT);
        boolean simplify = Hook.REL_BUILDER_SIMPLIFY.get(config.simplify());
        return config.withSimplify(simplify);
    }

    public static RelBuilder create(FrameworkConfig config) {
        return Frameworks.withPrepare(config, (cluster, relOptSchema, rootSchema, statement) -> new RelBuilder(config.getContext(), cluster, relOptSchema));
    }

    public RelBuilder transform(UnaryOperator<Config> transform) {
        Context context = Contexts.of(this.struct, transform.apply(this.config));
        return new RelBuilder(context, this.cluster, this.relOptSchema);
    }

    public <R> R let(Function<RelBuilder, R> consumer) {
        return consumer.apply(this);
    }

    public String toString() {
        return this.stack.stream().map(frame -> RelOptUtil.toString(frame.rel)).collect(Collectors.joining(""));
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.cluster.getTypeFactory();
    }

    public RelBuilder adoptConvention(Convention convention) {
        this.struct = convention.getRelFactories();
        return this;
    }

    public RexBuilder getRexBuilder() {
        return this.cluster.getRexBuilder();
    }

    public static RelBuilderFactory proto(Context context) {
        return (cluster, schema) -> new RelBuilder(context, cluster, schema);
    }

    public static RelBuilderFactory proto(Object ... factories) {
        return RelBuilder.proto(Contexts.of(factories));
    }

    public RelOptCluster getCluster() {
        return this.cluster;
    }

    public @Nullable RelOptSchema getRelOptSchema() {
        return this.relOptSchema;
    }

    public RelFactories.TableScanFactory getScanFactory() {
        return this.struct.scanFactory;
    }

    public RelBuilder push(RelNode node) {
        this.stack.push(new Frame(node));
        return this;
    }

    private void replaceTop(RelNode node) {
        Frame frame = this.stack.pop();
        this.stack.push(new Frame(node, frame.fields));
    }

    public RelBuilder pushAll(Iterable<? extends RelNode> nodes) {
        for (RelNode relNode : nodes) {
            this.push(relNode);
        }
        return this;
    }

    public int size() {
        return this.stack.size();
    }

    public RelNode build() {
        return this.stack.pop().rel;
    }

    public RelNode peek() {
        return ((Frame)Nullness.castNonNull((Object)this.peek_())).rel;
    }

    private @Nullable Frame peek_() {
        return this.stack.peek();
    }

    public RelNode peek(int n) {
        return this.peek_((int)n).rel;
    }

    private Frame peek_(int n) {
        if (n == 0) {
            return Objects.requireNonNull(this.stack.peek(), "stack.peek");
        }
        return (Frame)Iterables.get(this.stack, (int)n);
    }

    public RelNode peek(int inputCount, int inputOrdinal) {
        return this.peek_((int)inputCount, (int)inputOrdinal).rel;
    }

    private Frame peek_(int inputCount, int inputOrdinal) {
        return this.peek_(inputCount - 1 - inputOrdinal);
    }

    private int inputOffset(int inputCount, int inputOrdinal) {
        int offset = 0;
        for (int i = 0; i < inputOrdinal; ++i) {
            offset += this.peek(inputCount, i).getRowType().getFieldCount();
        }
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E with(RelNode r, Function<RelBuilder, E> fn) {
        try {
            this.push(r);
            E e = fn.apply(this);
            return e;
        }
        finally {
            this.stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E withSimplifier(BiFunction<RelBuilder, RexSimplify, RexSimplify> simplifierTransform, Function<RelBuilder, E> fn) {
        RexSimplify previousSimplifier = this.simplifier;
        try {
            this.simplifier = simplifierTransform.apply(this, previousSimplifier);
            E e = fn.apply(this);
            return e;
        }
        finally {
            this.simplifier = previousSimplifier;
        }
    }

    public <E> E withPredicates(RelMetadataQuery mq, Function<RelBuilder, E> fn) {
        RelOptPredicateList predicates = mq.getPulledUpPredicates(this.peek());
        return this.withSimplifier((r, s) -> s.withPredicates(predicates), fn);
    }

    public RexLiteral literal(@Nullable Object value) {
        RexBuilder rexBuilder = this.cluster.getRexBuilder();
        if (value == null) {
            RelDataType type = this.getTypeFactory().createSqlType(SqlTypeName.NULL);
            return rexBuilder.makeNullLiteral(type);
        }
        if (value instanceof Boolean) {
            return rexBuilder.makeLiteral((Boolean)value);
        }
        if (value instanceof BigDecimal) {
            return rexBuilder.makeExactLiteral((BigDecimal)value);
        }
        if (value instanceof Float || value instanceof Double) {
            return rexBuilder.makeApproxLiteral(BigDecimal.valueOf(((Number)value).doubleValue()));
        }
        if (value instanceof Number) {
            return rexBuilder.makeExactLiteral(BigDecimal.valueOf(((Number)value).longValue()));
        }
        if (value instanceof String) {
            return rexBuilder.makeLiteral((String)value);
        }
        if (value instanceof Enum) {
            return rexBuilder.makeLiteral(value, this.getTypeFactory().createSqlType(SqlTypeName.SYMBOL));
        }
        if (value instanceof DateString) {
            return rexBuilder.makeDateLiteral((DateString)value);
        }
        throw new IllegalArgumentException("cannot convert " + value + " (" + value.getClass() + ") to a constant");
    }

    @Deprecated
    public RelBuilder variable(Holder<RexCorrelVariable> v) {
        return this.variable(v::set);
    }

    public RelBuilder variable(Consumer<RexCorrelVariable> consumer) {
        consumer.accept((RexCorrelVariable)this.getRexBuilder().makeCorrel(this.peek().getRowType(), this.cluster.createCorrel()));
        return this;
    }

    public RexInputRef field(String fieldName) {
        return this.field(1, 0, fieldName);
    }

    public RexInputRef field(int inputCount, int inputOrdinal, String fieldName) {
        Frame frame = this.peek_(inputCount, inputOrdinal);
        List fieldNames = Pair.left(frame.fields());
        int i = fieldNames.indexOf(fieldName);
        if (i >= 0) {
            return this.field(inputCount, inputOrdinal, i);
        }
        throw new IllegalArgumentException("field [" + fieldName + "] not found; input fields are: " + fieldNames);
    }

    public RexInputRef field(int fieldOrdinal) {
        return (RexInputRef)this.field(1, 0, fieldOrdinal, false);
    }

    public RexInputRef field(int inputCount, int inputOrdinal, int fieldOrdinal) {
        return (RexInputRef)this.field(inputCount, inputOrdinal, fieldOrdinal, false);
    }

    private RexNode field(int inputCount, int inputOrdinal, int fieldOrdinal, boolean alias) {
        Frame frame = this.peek_(inputCount, inputOrdinal);
        RelNode input = frame.rel;
        RelDataType rowType = input.getRowType();
        if (fieldOrdinal < 0 || fieldOrdinal > rowType.getFieldCount()) {
            throw new IllegalArgumentException("field ordinal [" + fieldOrdinal + "] out of range; input fields are: " + rowType.getFieldNames());
        }
        RelDataTypeField field = rowType.getFieldList().get(fieldOrdinal);
        int offset = this.inputOffset(inputCount, inputOrdinal);
        RexInputRef ref = this.cluster.getRexBuilder().makeInputRef(field.getType(), offset + fieldOrdinal);
        RelDataTypeField aliasField = frame.fields().get(fieldOrdinal);
        if (!alias || field.getName().equals(aliasField.getName())) {
            return ref;
        }
        return this.alias(ref, aliasField.getName());
    }

    public RexNode field(String alias, String fieldName) {
        return this.field(1, alias, fieldName);
    }

    public RexNode field(int inputCount, String alias, String fieldName) {
        Objects.requireNonNull(alias, "alias");
        Objects.requireNonNull(fieldName, "fieldName");
        ArrayList<String> fields = new ArrayList<String>();
        for (int inputOrdinal = 0; inputOrdinal < inputCount; ++inputOrdinal) {
            Frame frame = this.peek_(inputOrdinal);
            for (Ord p : Ord.zip(frame.fields)) {
                if (((ImmutableSet)((Field)p.e).left).contains((Object)alias) && ((RelDataTypeField)((Field)p.e).right).getName().equals(fieldName)) {
                    return this.field(inputCount, inputCount - 1 - inputOrdinal, p.i);
                }
                fields.add(String.format(Locale.ROOT, "{aliases=%s,fieldName=%s}", ((Field)p.e).left, ((RelDataTypeField)((Field)p.e).right).getName()));
            }
        }
        throw new IllegalArgumentException("{alias=" + alias + ",fieldName=" + fieldName + "} field not found; fields are: " + fields);
    }

    public RexNode field(RexNode e, String name) {
        return this.getRexBuilder().makeFieldAccess(e, name, false);
    }

    public ImmutableList<RexNode> fields() {
        return this.fields(1, 0);
    }

    public ImmutableList<RexNode> fields(int inputCount, int inputOrdinal) {
        RelNode input = this.peek(inputCount, inputOrdinal);
        RelDataType rowType = input.getRowType();
        ImmutableList.Builder nodes = ImmutableList.builder();
        for (int fieldOrdinal : Util.range(rowType.getFieldCount())) {
            nodes.add((Object)this.field(inputCount, inputOrdinal, fieldOrdinal));
        }
        return nodes.build();
    }

    public ImmutableList<RexNode> fields(RelCollation collation) {
        ImmutableList.Builder nodes = ImmutableList.builder();
        for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
            RexNode node = this.field(fieldCollation.getFieldIndex());
            switch (fieldCollation.direction) {
                case DESCENDING: {
                    node = this.desc(node);
                    break;
                }
            }
            switch (fieldCollation.nullDirection) {
                case FIRST: {
                    node = this.nullsFirst(node);
                    break;
                }
                case LAST: {
                    node = this.nullsLast(node);
                    break;
                }
            }
            nodes.add((Object)node);
        }
        return nodes.build();
    }

    public ImmutableList<RexNode> fields(List<? extends Number> ordinals) {
        ImmutableList.Builder nodes = ImmutableList.builder();
        for (Number number : ordinals) {
            RexNode node = this.field(1, 0, number.intValue(), false);
            nodes.add((Object)node);
        }
        return nodes.build();
    }

    public ImmutableList<RexNode> fields(ImmutableBitSet ordinals) {
        return this.fields(ordinals.asList());
    }

    public ImmutableList<RexNode> fields(Iterable<String> fieldNames) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String fieldName : fieldNames) {
            builder.add((Object)this.field(fieldName));
        }
        return builder.build();
    }

    public ImmutableList<RexNode> fields(Mappings.TargetMapping mapping) {
        return this.fields(Mappings.asListNonNull(mapping));
    }

    public RexNode dot(RexNode node, String fieldName) {
        RexBuilder builder = this.cluster.getRexBuilder();
        return builder.makeFieldAccess(node, fieldName, true);
    }

    public RexNode dot(RexNode node, int fieldOrdinal) {
        RexBuilder builder = this.cluster.getRexBuilder();
        return builder.makeFieldAccess(node, fieldOrdinal);
    }

    public RexNode call(SqlOperator operator, RexNode ... operands) {
        return this.call(operator, (List<RexNode>)ImmutableList.copyOf((Object[])operands));
    }

    private RexCall call(SqlOperator operator, List<RexNode> operandList) {
        switch (operator.getKind()) {
            case LIKE: 
            case SIMILAR: {
                SqlLikeOperator likeOperator = (SqlLikeOperator)operator;
                if (!likeOperator.isNegated()) break;
                SqlOperator notLikeOperator = likeOperator.not();
                return (RexCall)this.not(this.call(notLikeOperator, operandList));
            }
            case BETWEEN: {
                assert (operandList.size() == 3);
                return (RexCall)this.between(operandList.get(0), operandList.get(1), operandList.get(2));
            }
        }
        RexBuilder builder = this.cluster.getRexBuilder();
        RelDataType type = builder.deriveReturnType(operator, operandList);
        return (RexCall)builder.makeCall(type, operator, operandList);
    }

    public RexNode call(SqlOperator operator, Iterable<? extends RexNode> operands) {
        return this.call(operator, (List<RexNode>)ImmutableList.copyOf(operands));
    }

    public RexNode in(RexNode arg, RexNode ... ranges) {
        return this.in(arg, (Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])ranges));
    }

    public RexNode in(RexNode arg, Iterable<? extends RexNode> ranges) {
        return this.getRexBuilder().makeIn(arg, (List<? extends RexNode>)ImmutableList.copyOf(ranges));
    }

    public RexSubQuery in(RelNode rel, Iterable<? extends RexNode> nodes) {
        return RexSubQuery.in(rel, (ImmutableList<RexNode>)ImmutableList.copyOf(nodes));
    }

    public RexNode in(RexNode arg, Function<RelBuilder, RelNode> f) {
        RelNode rel = f.apply(this);
        return RexSubQuery.in(rel, (ImmutableList<RexNode>)ImmutableList.of((Object)arg));
    }

    public RexSubQuery some(RexNode node, SqlOperator op, Function<RelBuilder, RelNode> f) {
        return this.some_(node, op.kind, f);
    }

    private RexSubQuery some_(RexNode node, SqlKind kind, Function<RelBuilder, RelNode> f) {
        RelNode rel = f.apply(this);
        SqlQuantifyOperator quantifyOperator = SqlStdOperatorTable.some(kind);
        return RexSubQuery.some(rel, (ImmutableList<RexNode>)ImmutableList.of((Object)node), quantifyOperator);
    }

    public RexNode all(RexNode node, SqlOperator op, Function<RelBuilder, RelNode> f) {
        return this.not(this.some_(node, op.kind.negateNullSafe(), f));
    }

    public RexSubQuery exists(Function<RelBuilder, RelNode> f) {
        RelNode rel = f.apply(this);
        return RexSubQuery.exists(rel);
    }

    public RexSubQuery unique(Function<RelBuilder, RelNode> f) {
        RelNode rel = f.apply(this);
        return RexSubQuery.unique(rel);
    }

    public RexSubQuery scalarQuery(Function<RelBuilder, RelNode> f) {
        return RexSubQuery.scalar(f.apply(this));
    }

    public RexSubQuery arrayQuery(Function<RelBuilder, RelNode> f) {
        return RexSubQuery.array(f.apply(this));
    }

    public RexSubQuery multisetQuery(Function<RelBuilder, RelNode> f) {
        return RexSubQuery.multiset(f.apply(this));
    }

    public RexSubQuery mapQuery(Function<RelBuilder, RelNode> f) {
        return RexSubQuery.map(f.apply(this));
    }

    public RexNode and(RexNode ... operands) {
        return this.and((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])operands));
    }

    public RexNode and(Iterable<? extends RexNode> operands) {
        return RexUtil.composeConjunction(this.getRexBuilder(), operands);
    }

    public RexNode or(RexNode ... operands) {
        return this.or((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])operands));
    }

    public RexNode or(Iterable<? extends RexNode> operands) {
        return RexUtil.composeDisjunction(this.cluster.getRexBuilder(), operands);
    }

    public RexNode not(RexNode operand) {
        return this.call((SqlOperator)SqlStdOperatorTable.NOT, operand);
    }

    public RexNode equals(RexNode operand0, RexNode operand1) {
        return this.call((SqlOperator)SqlStdOperatorTable.EQUALS, operand0, operand1);
    }

    public RexNode greaterThan(RexNode operand0, RexNode operand1) {
        return this.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, operand0, operand1);
    }

    public RexNode greaterThanOrEqual(RexNode operand0, RexNode operand1) {
        return this.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, operand0, operand1);
    }

    public RexNode lessThan(RexNode operand0, RexNode operand1) {
        return this.call((SqlOperator)SqlStdOperatorTable.LESS_THAN, operand0, operand1);
    }

    public RexNode lessThanOrEqual(RexNode operand0, RexNode operand1) {
        return this.call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, operand0, operand1);
    }

    public RexNode notEquals(RexNode operand0, RexNode operand1) {
        return this.call((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, operand0, operand1);
    }

    public RexNode isNotDistinctFrom(RexNode operand0, RexNode operand1) {
        return RelOptUtil.isDistinctFrom(this.getRexBuilder(), operand0, operand1, true);
    }

    public RexNode isDistinctFrom(RexNode operand0, RexNode operand1) {
        return RelOptUtil.isDistinctFrom(this.getRexBuilder(), operand0, operand1, false);
    }

    public RexNode between(RexNode arg, RexNode lower, RexNode upper) {
        return this.getRexBuilder().makeBetween(arg, lower, upper);
    }

    public RexNode isNull(RexNode operand) {
        return this.call((SqlOperator)SqlStdOperatorTable.IS_NULL, operand);
    }

    public RexNode isNotNull(RexNode operand) {
        return this.call((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operand);
    }

    public RexNode cast(RexNode expr, SqlTypeName typeName) {
        RelDataType type = this.cluster.getTypeFactory().createSqlType(typeName);
        return this.cluster.getRexBuilder().makeCast(type, expr);
    }

    public RexNode cast(RexNode expr, SqlTypeName typeName, int precision) {
        RelDataType type = this.cluster.getTypeFactory().createSqlType(typeName, precision);
        return this.cluster.getRexBuilder().makeCast(type, expr);
    }

    public RexNode cast(RexNode expr, SqlTypeName typeName, int precision, int scale) {
        RelDataType type = this.cluster.getTypeFactory().createSqlType(typeName, precision, scale);
        return this.cluster.getRexBuilder().makeCast(type, expr);
    }

    public RexNode alias(RexNode expr, String alias) {
        RexLiteral aliasLiteral = this.literal(alias);
        switch (expr.getKind()) {
            case AS: {
                RexCall call = (RexCall)expr;
                if (((RexNode)call.operands.get(1)).equals(aliasLiteral)) {
                    return expr;
                }
                expr = (RexNode)call.operands.get(0);
            }
        }
        return this.call((SqlOperator)SqlStdOperatorTable.AS, expr, aliasLiteral);
    }

    private RexNode aliasMaybe(RexNode node, @Nullable String name) {
        return name == null ? node : this.alias(node, name);
    }

    public RexNode desc(RexNode node) {
        return this.call((SqlOperator)SqlStdOperatorTable.DESC, node);
    }

    public RexNode nullsLast(RexNode node) {
        return this.call((SqlOperator)SqlStdOperatorTable.NULLS_LAST, node);
    }

    public RexNode nullsFirst(RexNode node) {
        return this.call((SqlOperator)SqlStdOperatorTable.NULLS_FIRST, node);
    }

    public RexWindowBound unboundedPreceding() {
        return RexWindowBounds.UNBOUNDED_PRECEDING;
    }

    public RexWindowBound preceding(RexNode bound) {
        return RexWindowBounds.preceding(bound);
    }

    public RexWindowBound currentRow() {
        return RexWindowBounds.CURRENT_ROW;
    }

    public RexWindowBound following(RexNode bound) {
        return RexWindowBounds.following(bound);
    }

    public RexWindowBound unboundedFollowing() {
        return RexWindowBounds.UNBOUNDED_FOLLOWING;
    }

    public GroupKey groupKey() {
        return this.groupKey((Iterable<? extends RexNode>)ImmutableList.of());
    }

    public GroupKey groupKey(RexNode ... nodes) {
        return this.groupKey((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    public GroupKey groupKey(Iterable<? extends RexNode> nodes) {
        return new GroupKeyImpl((ImmutableList<RexNode>)ImmutableList.copyOf(nodes), null, null);
    }

    public GroupKey groupKey(Iterable<? extends RexNode> nodes, Iterable<? extends Iterable<? extends RexNode>> nodeLists) {
        return RelBuilder.groupKey_(nodes, nodeLists);
    }

    @Deprecated
    public GroupKey groupKey(Iterable<? extends RexNode> nodes, boolean indicator, Iterable<? extends Iterable<? extends RexNode>> nodeLists) {
        Aggregate.checkIndicator(indicator);
        return RelBuilder.groupKey_(nodes, nodeLists);
    }

    private static GroupKey groupKey_(Iterable<? extends RexNode> nodes, Iterable<? extends Iterable<? extends RexNode>> nodeLists) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Iterable<? extends RexNode> iterable : nodeLists) {
            builder.add((Object)ImmutableList.copyOf(iterable));
        }
        return new GroupKeyImpl((ImmutableList<RexNode>)ImmutableList.copyOf(nodes), (ImmutableList<ImmutableList<RexNode>>)builder.build(), null);
    }

    public GroupKey groupKey(int ... fieldOrdinals) {
        return this.groupKey((Iterable<? extends RexNode>)this.fields(ImmutableIntList.of(fieldOrdinals)));
    }

    public GroupKey groupKey(String ... fieldNames) {
        return this.groupKey((Iterable<? extends RexNode>)this.fields((Iterable<String>)ImmutableList.copyOf((Object[])fieldNames)));
    }

    public GroupKey groupKey(ImmutableBitSet groupSet) {
        return this.groupKey_(groupSet, (ImmutableList<ImmutableBitSet>)ImmutableList.of((Object)groupSet));
    }

    public GroupKey groupKey(ImmutableBitSet groupSet, Iterable<? extends ImmutableBitSet> groupSets) {
        return this.groupKey_(groupSet, (ImmutableList<ImmutableBitSet>)ImmutableList.copyOf(groupSets));
    }

    @Deprecated
    public GroupKey groupKey(ImmutableBitSet groupSet, boolean indicator, @Nullable ImmutableList<ImmutableBitSet> groupSets) {
        Aggregate.checkIndicator(indicator);
        return this.groupKey_(groupSet, (ImmutableList<ImmutableBitSet>)(groupSets == null ? ImmutableList.of((Object)groupSet) : ImmutableList.copyOf(groupSets)));
    }

    private GroupKey groupKey_(ImmutableBitSet groupSet, ImmutableList<ImmutableBitSet> groupSets) {
        if (groupSet.length() > this.peek().getRowType().getFieldCount()) {
            throw new IllegalArgumentException("out of bounds: " + groupSet);
        }
        Objects.requireNonNull(groupSets, "groupSets");
        ImmutableList<RexNode> nodes = this.fields(groupSet);
        return RelBuilder.groupKey_(nodes, Util.transform(groupSets, this::fields));
    }

    @Deprecated
    public AggCall aggregateCall(SqlAggFunction aggFunction, boolean distinct, RexNode filter, @Nullable String alias, RexNode ... operands) {
        return this.aggregateCall(aggFunction, distinct, false, false, filter, null, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.of(), (ImmutableList<RexNode>)ImmutableList.copyOf((Object[])operands));
    }

    @Deprecated
    public AggCall aggregateCall(SqlAggFunction aggFunction, boolean distinct, boolean approximate, RexNode filter, @Nullable String alias, RexNode ... operands) {
        return this.aggregateCall(aggFunction, distinct, approximate, false, filter, null, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.of(), (ImmutableList<RexNode>)ImmutableList.copyOf((Object[])operands));
    }

    @Deprecated
    public AggCall aggregateCall(SqlAggFunction aggFunction, boolean distinct, RexNode filter, @Nullable String alias, Iterable<? extends RexNode> operands) {
        return this.aggregateCall(aggFunction, distinct, false, false, filter, null, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.of(), (ImmutableList<RexNode>)ImmutableList.copyOf(operands));
    }

    @Deprecated
    public AggCall aggregateCall(SqlAggFunction aggFunction, boolean distinct, boolean approximate, RexNode filter, @Nullable String alias, Iterable<? extends RexNode> operands) {
        return this.aggregateCall(aggFunction, distinct, approximate, false, filter, null, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.of(), (ImmutableList<RexNode>)ImmutableList.copyOf(operands));
    }

    public AggCall aggregateCall(SqlAggFunction aggFunction, Iterable<? extends RexNode> operands) {
        return this.aggregateCall(aggFunction, false, false, false, null, null, (ImmutableList<RexNode>)ImmutableList.of(), null, (ImmutableList<RexNode>)ImmutableList.of(), (ImmutableList<RexNode>)ImmutableList.copyOf(operands));
    }

    public AggCall aggregateCall(SqlAggFunction aggFunction, RexNode ... operands) {
        return this.aggregateCall(aggFunction, false, false, false, null, null, (ImmutableList<RexNode>)ImmutableList.of(), null, (ImmutableList<RexNode>)ImmutableList.of(), (ImmutableList<RexNode>)ImmutableList.copyOf((Object[])operands));
    }

    public AggCall aggregateCall(AggregateCall a) {
        return this.aggregateCall(a.getAggregation(), a.isDistinct(), a.isApproximate(), a.ignoreNulls(), (RexNode)(a.filterArg < 0 ? null : this.field(a.filterArg)), a.distinctKeys == null ? null : this.fields(a.distinctKeys), this.fields(a.collation), a.name, (ImmutableList<RexNode>)ImmutableList.copyOf(a.rexList), this.fields(a.getArgList()));
    }

    public AggCall aggregateCall(AggregateCall a, Mapping mapping) {
        return this.aggregateCall(a.getAggregation(), a.isDistinct(), a.isApproximate(), a.ignoreNulls(), (RexNode)(a.filterArg < 0 ? null : this.field(Mappings.apply((Mappings.TargetMapping)mapping, a.filterArg))), a.distinctKeys == null ? null : this.fields(Mappings.apply(mapping, a.distinctKeys)), this.fields(RexUtil.apply((Mappings.TargetMapping)mapping, a.collation)), a.name, (ImmutableList<RexNode>)ImmutableList.copyOf(a.rexList), this.fields(Mappings.apply2(mapping, a.getArgList())));
    }

    protected AggCall aggregateCall(SqlAggFunction aggFunction, boolean distinct, boolean approximate, boolean ignoreNulls, @Nullable RexNode filter, @Nullable ImmutableList<RexNode> distinctKeys, ImmutableList<RexNode> orderKeys, @Nullable String alias, ImmutableList<RexNode> preOperands, ImmutableList<RexNode> operands) {
        return new AggCallImpl(aggFunction, distinct, approximate, ignoreNulls, filter, alias, preOperands, operands, distinctKeys, orderKeys);
    }

    public AggCall count(RexNode ... operands) {
        return this.count(false, null, operands);
    }

    public AggCall count(Iterable<? extends RexNode> operands) {
        return this.count(false, null, operands);
    }

    public AggCall count(boolean distinct, @Nullable String alias, RexNode ... operands) {
        return this.aggregateCall(SqlStdOperatorTable.COUNT, distinct, false, false, null, null, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.of(), (ImmutableList<RexNode>)ImmutableList.copyOf((Object[])operands));
    }

    public AggCall count(boolean distinct, @Nullable String alias, Iterable<? extends RexNode> operands) {
        return this.aggregateCall(SqlStdOperatorTable.COUNT, distinct, false, false, null, null, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.of(), (ImmutableList<RexNode>)ImmutableList.copyOf(operands));
    }

    public AggCall countStar(@Nullable String alias) {
        return this.count(false, alias, new RexNode[0]);
    }

    public AggCall sum(RexNode operand) {
        return this.sum(false, null, operand);
    }

    public AggCall sum(boolean distinct, @Nullable String alias, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.SUM, distinct, false, false, null, null, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.of(), (ImmutableList<RexNode>)ImmutableList.of((Object)operand));
    }

    public AggCall avg(RexNode operand) {
        return this.avg(false, null, operand);
    }

    public AggCall avg(boolean distinct, @Nullable String alias, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.AVG, distinct, false, false, null, null, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.of(), (ImmutableList<RexNode>)ImmutableList.of((Object)operand));
    }

    public AggCall min(RexNode operand) {
        return this.min(null, operand);
    }

    public AggCall min(@Nullable String alias, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.MIN, false, false, false, null, null, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.of(), (ImmutableList<RexNode>)ImmutableList.of((Object)operand));
    }

    public AggCall max(RexNode operand) {
        return this.max(null, operand);
    }

    public AggCall max(@Nullable String alias, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.MAX, false, false, false, null, null, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.of(), (ImmutableList<RexNode>)ImmutableList.of((Object)operand));
    }

    public AggCall literalAgg(@Nullable Object value) {
        return this.aggregateCall(SqlInternalOperators.LITERAL_AGG, new RexNode[0]).preOperands(this.literal(value));
    }

    public RexNode patternField(String alpha, RelDataType type, int i) {
        return this.getRexBuilder().makePatternFieldRef(alpha, type, i);
    }

    public RexNode patternConcat(Iterable<? extends RexNode> nodes) {
        ImmutableList list = ImmutableList.copyOf(nodes);
        if (list.size() > 2) {
            return this.patternConcat(this.patternConcat(Util.skipLast(list)), (RexNode)Util.last(list));
        }
        RelDataType t = this.getTypeFactory().createSqlType(SqlTypeName.NULL);
        return this.getRexBuilder().makeCall(t, SqlStdOperatorTable.PATTERN_CONCAT, (List<RexNode>)list);
    }

    public RexNode patternConcat(RexNode ... nodes) {
        return this.patternConcat((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    public RexNode patternAlter(Iterable<? extends RexNode> nodes) {
        RelDataType t = this.getTypeFactory().createSqlType(SqlTypeName.NULL);
        return this.getRexBuilder().makeCall(t, SqlStdOperatorTable.PATTERN_ALTER, (List<RexNode>)ImmutableList.copyOf(nodes));
    }

    public RexNode patternAlter(RexNode ... nodes) {
        return this.patternAlter((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    public RexNode patternQuantify(Iterable<? extends RexNode> nodes) {
        RelDataType t = this.getTypeFactory().createSqlType(SqlTypeName.NULL);
        return this.getRexBuilder().makeCall(t, SqlStdOperatorTable.PATTERN_QUANTIFIER, (List<RexNode>)ImmutableList.copyOf(nodes));
    }

    public RexNode patternQuantify(RexNode ... nodes) {
        return this.patternQuantify((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    public RexNode patternPermute(Iterable<? extends RexNode> nodes) {
        RelDataType t = this.getTypeFactory().createSqlType(SqlTypeName.NULL);
        return this.getRexBuilder().makeCall(t, SqlStdOperatorTable.PATTERN_PERMUTE, (List<RexNode>)ImmutableList.copyOf(nodes));
    }

    public RexNode patternPermute(RexNode ... nodes) {
        return this.patternPermute((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    public RexNode patternExclude(RexNode node) {
        RelDataType t = this.getTypeFactory().createSqlType(SqlTypeName.NULL);
        return this.getRexBuilder().makeCall(t, SqlStdOperatorTable.PATTERN_EXCLUDE, (List<RexNode>)ImmutableList.of((Object)node));
    }

    public RelBuilder scan(Iterable<String> tableNames) {
        ImmutableList names = ImmutableList.copyOf(tableNames);
        Objects.requireNonNull(this.relOptSchema, "relOptSchema");
        RelOptTable relOptTable = this.relOptSchema.getTableForMember((List<String>)names);
        if (relOptTable == null) {
            throw Static.RESOURCE.tableNotFound(String.join((CharSequence)".", (Iterable<? extends CharSequence>)names)).ex();
        }
        RelNode scan = this.struct.scanFactory.createScan(ViewExpanders.toRelContext(this.viewExpander, this.cluster), relOptTable);
        this.push(scan);
        this.rename(relOptTable.getRowType().getFieldNames());
        if (!(scan instanceof TableScan)) {
            this.as((String)Util.last(ImmutableList.copyOf(tableNames)));
        }
        return this;
    }

    public RelBuilder scan(String ... tableNames) {
        return this.scan((Iterable<String>)ImmutableList.copyOf((Object[])tableNames));
    }

    public RelBuilder snapshot(RexNode period) {
        Frame frame = this.stack.pop();
        RelNode snapshot = this.struct.snapshotFactory.createSnapshot(frame.rel, period);
        this.stack.push(new Frame(snapshot, frame.fields));
        return this;
    }

    private static @Nullable Set<RelColumnMapping> getColumnMappings(SqlOperator op) {
        SqlReturnTypeInference inference = op.getReturnTypeInference();
        if (inference instanceof TableFunctionReturnTypeInference) {
            return ((TableFunctionReturnTypeInference)inference).getColumnMappings();
        }
        return null;
    }

    public RexNode cursor(int inputCount, int ordinal) {
        if (inputCount <= ordinal || ordinal < 0) {
            throw new IllegalArgumentException("bad input count or ordinal");
        }
        RelNode input = this.peek(inputCount, ordinal);
        return this.call((SqlOperator)SqlStdOperatorTable.CURSOR, this.getRexBuilder().makeInputRef(input.getRowType(), ordinal));
    }

    public RelBuilder functionScan(SqlOperator operator, int inputCount, RexNode ... operands) {
        return this.functionScan(operator, inputCount, (Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])operands));
    }

    public RelBuilder functionScan(SqlOperator operator, int inputCount, Iterable<? extends RexNode> operands) {
        if (inputCount < 0 || inputCount > this.stack.size()) {
            throw new IllegalArgumentException("bad input count");
        }
        ArrayList<RelNode> inputs = new ArrayList<RelNode>();
        for (int i = 0; i < inputCount; ++i) {
            inputs.add(0, this.build());
        }
        RexCall call = this.call(operator, (List<RexNode>)ImmutableList.copyOf(operands));
        RelNode functionScan = this.struct.tableFunctionScanFactory.createTableFunctionScan(this.cluster, inputs, call, null, RelBuilder.getColumnMappings(operator));
        this.push(functionScan);
        return this;
    }

    public RelBuilder filter(RexNode ... predicates) {
        return this.filter((Iterable<CorrelationId>)ImmutableSet.of(), (Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])predicates));
    }

    public RelBuilder filter(Iterable<? extends RexNode> predicates) {
        return this.filter((Iterable<CorrelationId>)ImmutableSet.of(), predicates);
    }

    public RelBuilder filter(Iterable<CorrelationId> variablesSet, RexNode ... predicates) {
        return this.filter(variablesSet, (Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])predicates));
    }

    public RelBuilder filter(Iterable<CorrelationId> variablesSet, Iterable<? extends RexNode> predicates) {
        RexNode conjunctionPredicates = this.config.simplify() ? this.simplifier.simplifyFilterPredicates(predicates) : RexUtil.composeConjunction(this.simplifier.rexBuilder, predicates);
        if (conjunctionPredicates == null || conjunctionPredicates.isAlwaysFalse()) {
            return this.empty();
        }
        if (conjunctionPredicates.isAlwaysTrue()) {
            return this;
        }
        Frame frame = this.stack.pop();
        RelNode filter = this.struct.filterFactory.createFilter(frame.rel, conjunctionPredicates, (Set<CorrelationId>)ImmutableSet.copyOf(variablesSet));
        this.stack.push(new Frame(filter, frame.fields));
        return this;
    }

    public RelBuilder project(RexNode ... nodes) {
        return this.project((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    public RelBuilder project(Iterable<? extends RexNode> nodes) {
        return this.project(nodes, (Iterable<? extends String>)ImmutableList.of());
    }

    public RelBuilder project(Iterable<? extends RexNode> nodes, Iterable<? extends @Nullable String> fieldNames) {
        return this.project(nodes, fieldNames, false);
    }

    public RelBuilder project(Iterable<? extends RexNode> nodes, Iterable<? extends @Nullable String> fieldNames, boolean force) {
        return this.project(nodes, fieldNames, force, (Iterable<CorrelationId>)ImmutableSet.of());
    }

    public RelBuilder project(Iterable<? extends RexNode> nodes, Iterable<? extends @Nullable String> fieldNames, boolean force, Iterable<CorrelationId> variablesSet) {
        return this.project_(nodes, fieldNames, (Iterable<RelHint>)ImmutableList.of(), force, variablesSet);
    }

    public RelBuilder projectPlus(RexNode ... nodes) {
        return this.projectPlus((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    public RelBuilder projectPlus(Iterable<? extends RexNode> nodes) {
        return this.project(Iterables.concat(this.fields(), nodes));
    }

    public RelBuilder projectExcept(RexNode ... expressions) {
        return this.projectExcept((Iterable<RexNode>)ImmutableList.copyOf((Object[])expressions));
    }

    public RelBuilder projectExcept(Iterable<RexNode> expressions) {
        ArrayList<RexNode> allExpressions = new ArrayList<RexNode>((Collection<RexNode>)this.fields());
        HashSet<RexNode> excludeExpressions = new HashSet<RexNode>();
        for (RexNode excludeExp : expressions) {
            if (!excludeExpressions.add(excludeExp)) {
                throw new IllegalArgumentException("Input list contains duplicates. Expression " + excludeExp + " exists multiple times.");
            }
            if (allExpressions.remove(excludeExp)) continue;
            throw new IllegalArgumentException("Expression " + excludeExp.toString() + " not found.");
        }
        return this.project(allExpressions);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private RelBuilder project_(Iterable<? extends RexNode> nodes, Iterable<? extends @Nullable String> fieldNames, Iterable<RelHint> hints, boolean force, Iterable<CorrelationId> variablesSet) {
        int rowCount;
        Frame frame = Objects.requireNonNull(this.peek_(), "frame stack is empty");
        RelDataType inputRowType = frame.rel.getRowType();
        ArrayList nodeList = Lists.newArrayList(nodes);
        ImmutableSet variables = ImmutableSet.copyOf(variablesSet);
        if (!force && Iterables.isEmpty(fieldNames) && RexUtil.isIdentity(nodeList, inputRowType)) {
            return this;
        }
        @Nullable ArrayList fieldNameList = Lists.newArrayList(fieldNames);
        while (fieldNameList.size() < nodeList.size()) {
            fieldNameList.add(null);
        }
        if (frame.rel instanceof Project && this.config.bloat() >= 0 && variables.isEmpty()) {
            Project project = (Project)frame.rel;
            for (int i = 0; i < fieldNameList.size(); ++i) {
                RexNode node;
                if (fieldNameList.get(i) != null || !((node = (RexNode)nodeList.get(i)) instanceof RexInputRef)) continue;
                RexInputRef ref = (RexInputRef)node;
                fieldNameList.set(i, project.getRowType().getFieldNames().get(ref.getIndex()));
            }
            List<RexNode> newNodes = RelOptUtil.pushPastProjectUnlessBloat(nodeList, project, this.config.bloat());
            if (newNodes != null) {
                Frame frame1 = this.stack.pop();
                ArrayList<Field> fields = new ArrayList<Field>();
                for (RelDataTypeField relDataTypeField : project.getInput().getRowType().getFieldList()) {
                    fields.add(new Field((ImmutableSet<String>)ImmutableSet.of(), relDataTypeField));
                }
                for (Pair pair : Pair.zip(project.getProjects(), frame1.fields)) {
                    switch (((RexNode)pair.left).getKind()) {
                        case INPUT_REF: {
                            int i = ((RexInputRef)pair.left).getIndex();
                            Field field = (Field)fields.get(i);
                            ImmutableSet aliases = (ImmutableSet)((Field)pair.right).left;
                            fields.set(i, new Field((ImmutableSet<String>)aliases, (RelDataTypeField)field.right));
                            break;
                        }
                    }
                }
                this.stack.push(new Frame(project.getInput(), ImmutableList.copyOf(fields)));
                ImmutableSet.Builder mergedHints = ImmutableSet.builder();
                mergedHints.addAll(project.getHints());
                mergedHints.addAll(hints);
                return this.project_(newNodes, fieldNameList, (Iterable<RelHint>)mergedHints.build(), force, (Iterable<CorrelationId>)ImmutableSet.copyOf(project.getVariablesSet()));
            }
        }
        if (this.config.simplify()) {
            nodeList.replaceAll(e -> this.simplifier.simplifyPreservingType((RexNode)e));
        }
        for (int i = 0; i < fieldNameList.size(); ++i) {
            if (fieldNameList.get(i) != null) continue;
            fieldNameList.set(i, this.inferAlias(nodeList, (RexNode)nodeList.get(i), i));
        }
        ImmutableList.Builder fields = ImmutableList.builder();
        AbstractSet uniqueNameList = this.getTypeFactory().getTypeSystem().isSchemaCaseSensitive() ? new HashSet() : new TreeSet(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < fieldNameList.size(); ++i) {
            Field field;
            String name2;
            RexNode node = (RexNode)nodeList.get(i);
            String string = name2 = (String)fieldNameList.get(i);
            if (name2 == null || uniqueNameList.contains(name2)) {
                int j = 0;
                if (name2 == null) {
                    j = i;
                }
                while (uniqueNameList.contains(name2 = SqlValidatorUtil.F_SUGGESTER.apply(string, j, j++))) {
                }
                fieldNameList.set(i, name2);
            }
            RelDataTypeFieldImpl fieldType = new RelDataTypeFieldImpl(name2, i, node.getType());
            switch (node.getKind()) {
                case INPUT_REF: {
                    int index = ((RexInputRef)node).getIndex();
                    field = new Field((ImmutableSet<String>)((ImmutableSet)((Field)frame.fields.get((int)index)).left), fieldType);
                    break;
                }
                default: {
                    field = new Field((ImmutableSet<String>)ImmutableSet.of(), fieldType);
                }
            }
            uniqueNameList.add(name2);
            fields.add((Object)field);
        }
        if (!force && RexUtil.isIdentity(nodeList, inputRowType)) {
            if (fieldNameList.equals(inputRowType.getFieldNames())) {
                return this;
            }
            this.stack.pop();
            this.stack.push(new Frame(frame.rel, fields.build()));
            return this;
        }
        if (this.config.simplifyValues() && nodeList.stream().allMatch(e -> e instanceof RexLiteral) && (rowCount = RelBuilder.fixedRowCount(frame)) >= 0) {
            RelNode unused = this.build();
            RelDataTypeFactory.FieldInfoBuilder typeBuilder = this.getTypeFactory().builder();
            Pair.forEach(fieldNameList, nodeList, (name, expr) -> typeBuilder.add(Objects.requireNonNull(name, "name"), expr.getType()));
            ArrayList arrayList = nodeList;
            return this.values(Collections.nCopies(rowCount, arrayList), typeBuilder.build());
        }
        RelNode project = this.struct.projectFactory.createProject(frame.rel, (List<RelHint>)ImmutableList.copyOf(hints), (List<? extends RexNode>)ImmutableList.copyOf((Collection)nodeList), fieldNameList, (Set<CorrelationId>)variables);
        this.stack.pop();
        this.stack.push(new Frame(project, fields.build()));
        return this;
    }

    private static int fixedRowCount(Frame frame) {
        Aggregate aggregate;
        if (frame.rel instanceof Values) {
            return ((Values)frame.rel).tuples.size();
        }
        if (frame.rel instanceof Aggregate && (aggregate = (Aggregate)frame.rel).getGroupSet().isEmpty() && aggregate.getGroupType() == Aggregate.Group.SIMPLE) {
            return 1;
        }
        return -1;
    }

    public RelBuilder projectNamed(Iterable<? extends RexNode> nodes, @Nullable Iterable<? extends @Nullable String> fieldNames, boolean force) {
        return this.projectNamed(nodes, fieldNames, force, (Iterable<CorrelationId>)ImmutableSet.of());
    }

    public RelBuilder projectNamed(Iterable<? extends RexNode> nodes, @Nullable Iterable<? extends @Nullable String> fieldNames, boolean force, Iterable<CorrelationId> variablesSet) {
        List nodeList;
        List list = nodeList = nodes instanceof List ? (List)nodes : ImmutableList.copyOf(nodes);
        List<@Nullable ? extends String> fieldNameList = fieldNames == null ? null : (fieldNames instanceof List ? (List<? extends String>)fieldNames : ImmutableNullableList.copyOf(fieldNames));
        RelNode input = this.peek();
        RelDataType rowType = RexUtil.createStructType(this.cluster.getTypeFactory(), nodeList, fieldNameList, SqlValidatorUtil.F_SUGGESTER);
        if (!force && RexUtil.isIdentity(nodeList, input.getRowType())) {
            Frame frame;
            if (input instanceof Project && fieldNames != null) {
                frame = this.stack.pop();
                Project childProject = (Project)frame.rel;
                Project newInput = childProject.copy(childProject.getTraitSet(), childProject.getInput(), childProject.getProjects(), rowType);
                this.stack.push(new Frame(newInput.attachHints((List<RelHint>)childProject.getHints()), frame.fields));
            }
            if (input instanceof Values && fieldNameList != null) {
                frame = this.stack.pop();
                Values values = (Values)frame.rel;
                RelDataTypeFactory.FieldInfoBuilder typeBuilder = this.getTypeFactory().builder();
                Pair.forEach(fieldNameList, rowType.getFieldList(), (name, field) -> typeBuilder.add(Objects.requireNonNull(name, "name"), field.getType()));
                RelDataType newRowType = typeBuilder.build();
                RelNode newValues = this.struct.valuesFactory.createValues(this.cluster, newRowType, (List<ImmutableList<RexLiteral>>)values.tuples);
                this.stack.push(new Frame(newValues, frame.fields));
            }
        } else {
            this.project(nodeList, rowType.getFieldNames(), force, variablesSet);
        }
        return this;
    }

    public RelBuilder uncollect(List<String> itemAliases, boolean withOrdinality) {
        Frame frame = this.stack.pop();
        this.stack.push(new Frame((RelNode)new Uncollect(this.cluster, this.cluster.traitSetOf((RelTrait)Convention.NONE), frame.rel, withOrdinality, Objects.requireNonNull(itemAliases, "itemAliases"))));
        return this;
    }

    public RelBuilder rename(List<? extends @Nullable String> fieldNames) {
        List<String> oldFieldNames = this.peek().getRowType().getFieldNames();
        Preconditions.checkArgument((fieldNames.size() <= oldFieldNames.size() ? 1 : 0) != 0, (Object)"More names than fields");
        ArrayList<String> newFieldNames = new ArrayList<String>(oldFieldNames);
        for (int i = 0; i < fieldNames.size(); ++i) {
            String s = fieldNames.get(i);
            if (s == null) continue;
            newFieldNames.set(i, s);
        }
        if (oldFieldNames.equals(newFieldNames)) {
            return this;
        }
        if (this.peek() instanceof Values) {
            Values v = (Values)this.build();
            RelDataTypeFactory.FieldInfoBuilder b = this.getTypeFactory().builder();
            for (Pair<String, RelDataTypeField> p : Pair.zip(newFieldNames, v.getRowType().getFieldList())) {
                ((RelDataTypeFactory.Builder)b).add((String)p.left, ((RelDataTypeField)p.right).getType());
            }
            return this.values((Iterable<? extends List<RexLiteral>>)v.tuples, b.build());
        }
        return this.project((Iterable<? extends RexNode>)this.fields(), (Iterable<? extends String>)newFieldNames, true);
    }

    private @Nullable String inferAlias(List<RexNode> exprList, RexNode expr, int i) {
        switch (expr.getKind()) {
            case INPUT_REF: {
                RexInputRef ref = (RexInputRef)expr;
                return ((RelDataTypeField)((Field)Objects.requireNonNull(this.stack.peek(), (String)"empty frame stack").fields.get(ref.getIndex())).getValue()).getName();
            }
            case CAST: {
                return this.inferAlias(exprList, ((RexCall)expr).getOperands().get(0), -1);
            }
            case AS: {
                RexCall call = (RexCall)expr;
                if (i >= 0) {
                    exprList.set(i, call.getOperands().get(0));
                }
                NlsString value = (NlsString)((RexLiteral)call.getOperands().get(1)).getValue();
                return ((NlsString)Nullness.castNonNull((Object)value)).getValue();
            }
        }
        return null;
    }

    public RelBuilder distinct() {
        return this.aggregate_((GroupKeyImpl)this.groupKey((Iterable<? extends RexNode>)this.fields()), (ImmutableList<AggCallPlus>)ImmutableList.of());
    }

    public RelBuilder aggregate(GroupKey groupKey, AggCall ... aggCalls) {
        return this.aggregate_((GroupKeyImpl)groupKey, (ImmutableList<AggCallPlus>)ImmutableList.copyOf((Object[])aggCalls));
    }

    public RelBuilder aggregate(GroupKey groupKey, List<AggregateCall> aggregateCalls) {
        return this.aggregate_((GroupKeyImpl)groupKey, aggregateCalls.stream().map(aggregateCall -> new AggCallImpl2((AggregateCall)aggregateCall, (ImmutableList<RexNode>)aggregateCall.getArgList().stream().map(this::field).collect(Util.toImmutableList()))).collect(Util.toImmutableList()));
    }

    public RelBuilder aggregate(GroupKey groupKey, Iterable<? extends AggCall> aggCalls) {
        return this.aggregate_((GroupKeyImpl)groupKey, (ImmutableList<AggCallPlus>)ImmutableList.copyOf(aggCalls));
    }

    private RelBuilder aggregate_(GroupKeyImpl groupKey, ImmutableList<AggCallPlus> aggCalls) {
        ImmutableList groupSets2;
        ImmutableList groupSets;
        ImmutableBitSet groupSet2;
        if (groupKey.nodes.isEmpty() && aggCalls.isEmpty() && this.config.pruneInputOfAggregate()) {
            if (this.config.preventEmptyFieldList()) {
                return this.values(new String[]{"dummy"}, true);
            }
            return this.values((Iterable<? extends List<RexLiteral>>)ImmutableList.of((Object)ImmutableList.of()), this.getTypeFactory().builder().build());
        }
        Registrar registrar = new Registrar((Iterable<RexNode>)this.fields(), this.peek().getRowType().getFieldNames());
        ImmutableBitSet groupSet = ImmutableBitSet.of(registrar.registerExpressions((Iterable<? extends RexNode>)groupKey.nodes));
        if (this.alreadyUnique((List<AggCallPlus>)aggCalls, groupKey, groupSet, registrar.extraNodes)) {
            ArrayList<RexNode> nodes = new ArrayList<RexNode>((Collection<RexNode>)this.fields(groupSet));
            aggCalls.forEach(c -> {
                AggregateCall call = c.aggregateCall();
                SqlStaticAggFunction staticFun = call.getAggregation().unwrapOrThrow(SqlStaticAggFunction.class);
                RexNode node = staticFun.constant(this.getRexBuilder(), groupSet, (ImmutableList<ImmutableBitSet>)ImmutableList.of(), call);
                nodes.add(this.aliasMaybe(Objects.requireNonNull(node, "node"), call.getName()));
            });
            return this.project(nodes);
        }
        if (groupKey.nodeLists != null) {
            int sizeBefore = registrar.extraNodes.size();
            ArrayList<ImmutableBitSet> groupSetList = new ArrayList<ImmutableBitSet>();
            for (ImmutableList nodeList : groupKey.nodeLists) {
                groupSet2 = ImmutableBitSet.of(registrar.registerExpressions((Iterable<? extends RexNode>)nodeList));
                if (!groupSet.contains(groupSet2)) {
                    throw new IllegalArgumentException("group set element " + nodeList + " must be a subset of group key");
                }
                groupSetList.add(groupSet2);
            }
            ImmutableSortedMultiset groupSetMultiset = ImmutableSortedMultiset.copyOf(ImmutableBitSet.COMPARATOR, groupSetList);
            if (aggCalls.stream().anyMatch(RelBuilder::isGroupId) || !ImmutableBitSet.ORDERING.isStrictlyOrdered((Iterable)groupSetMultiset)) {
                return this.rewriteAggregateWithDuplicateGroupSets(groupSet, (ImmutableSortedMultiset<ImmutableBitSet>)groupSetMultiset, (List<AggCallPlus>)aggCalls);
            }
            groupSets = ImmutableList.copyOf((Collection)groupSetMultiset.elementSet());
            if (registrar.extraNodes.size() > sizeBefore) {
                throw new IllegalArgumentException("group sets contained expressions not in group key: " + Util.skip(registrar.extraNodes, sizeBefore));
            }
        } else {
            groupSets = ImmutableList.of((Object)groupSet);
        }
        aggCalls.forEach(aggCall -> aggCall.register(registrar));
        this.project(registrar.extraNodes);
        this.rename(registrar.names);
        Frame frame = this.stack.pop();
        RelNode r = frame.rel;
        ArrayList<AggregateCall> aggregateCalls = new ArrayList<AggregateCall>();
        for (AggCallPlus aggCall2 : aggCalls) {
            aggregateCalls.add(aggCall2.aggregateCall(registrar, groupSet, r));
        }
        assert (ImmutableBitSet.ORDERING.isStrictlyOrdered((Iterable)groupSets)) : groupSets;
        for (ImmutableBitSet set : groupSets) {
            assert (groupSet.contains(set));
        }
        Object inFields = frame.fields;
        if (this.config.pruneInputOfAggregate() && r instanceof Project) {
            Set<Integer> fieldsUsed = RelOptUtil.getAllFields2(groupSet, aggregateCalls);
            if (fieldsUsed.isEmpty()) {
                r = ((Project)r).getInput();
                groupSet2 = groupSet;
                groupSets2 = groupSets;
            } else if (fieldsUsed.size() < r.getRowType().getFieldCount()) {
                HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
                for (int source : fieldsUsed) {
                    map.put(source, map.size());
                }
                groupSet2 = groupSet.permute(map);
                groupSets2 = ImmutableBitSet.ORDERING.immutableSortedCopy(ImmutableBitSet.permute((Iterable<ImmutableBitSet>)groupSets, map));
                Mappings.TargetMapping targetMapping = Mappings.target(map, r.getRowType().getFieldCount(), fieldsUsed.size());
                ArrayList<AggregateCall> oldAggregateCalls = new ArrayList<AggregateCall>(aggregateCalls);
                aggregateCalls.clear();
                for (AggregateCall aggregateCall : oldAggregateCalls) {
                    aggregateCalls.add(aggregateCall.transform(targetMapping));
                }
                inFields = Mappings.permute(inFields, targetMapping.inverse());
                Project project = (Project)r;
                ArrayList<RexNode> newProjects = new ArrayList<RexNode>();
                RelDataTypeFactory.FieldInfoBuilder builder = this.cluster.getTypeFactory().builder();
                for (int i2 : fieldsUsed) {
                    newProjects.add(project.getProjects().get(i2));
                    ((RelDataTypeFactory.Builder)builder).add(project.getRowType().getFieldList().get(i2));
                }
                r = project.copy(this.cluster.traitSet(), project.getInput(), newProjects, builder.build());
            } else {
                groupSet2 = groupSet;
                groupSets2 = groupSets;
            }
        } else {
            groupSet2 = groupSet;
            groupSets2 = groupSets;
        }
        if (!this.config.dedupAggregateCalls() || Util.isDistinct(aggregateCalls)) {
            return this.aggregate_(groupSet2, (ImmutableList<ImmutableBitSet>)groupSets2, r, (List<AggregateCall>)aggregateCalls, registrar.extraNodes, (List<Field>)inFields);
        }
        HashSet<AggregateCall> callSet = new HashSet<AggregateCall>();
        PairList<Integer, @Nullable String> projects = PairList.of();
        Util.range(groupSet.cardinality()).forEach(i -> projects.add((Integer)i, (String)null));
        ArrayList<AggregateCall> distinctAggregateCalls = new ArrayList<AggregateCall>();
        for (AggregateCall aggregateCall : aggregateCalls) {
            int i3;
            if (callSet.add(aggregateCall)) {
                i3 = distinctAggregateCalls.size();
                distinctAggregateCalls.add(aggregateCall);
            } else {
                i3 = distinctAggregateCalls.indexOf(aggregateCall);
                assert (i3 >= 0);
            }
            projects.add(Integer.valueOf(groupSet.cardinality() + i3), aggregateCall.name);
        }
        this.aggregate_(groupSet, (ImmutableList<ImmutableBitSet>)groupSets, r, (List<AggregateCall>)distinctAggregateCalls, registrar.extraNodes, (List<Field>)inFields);
        return this.project(projects.transform((T i, U name) -> this.aliasMaybe(this.field((int)i), (String)name)));
    }

    private boolean alreadyUnique(List<AggCallPlus> aggCallList, GroupKeyImpl groupKey, ImmutableBitSet groupSet, List<RexNode> extraNodes) {
        Boolean unique;
        Double minRowCount;
        RelMetadataQuery mq = this.peek().getCluster().getMetadataQuery();
        if (aggCallList.isEmpty() && groupSet.isEmpty() && ((minRowCount = mq.getMinRowCount(this.peek())) == null || minRowCount < 1.0)) {
            return false;
        }
        if (!aggCallList.stream().allMatch(c -> AggregateRemoveRule.canFlattenStatic(c.aggregateCall()))) {
            return false;
        }
        if (extraNodes.size() == this.fields().size() && (unique = mq.areColumnsUnique(this.peek(), groupSet)) != null && unique.booleanValue() && !this.config.aggregateUnique() && groupKey.isSimple()) {
            return true;
        }
        Double maxRowCount = mq.getMaxRowCount(this.peek());
        return maxRowCount != null && maxRowCount <= 1.0 && !this.config.aggregateUnique() && groupKey.isSimple();
    }

    private RelBuilder aggregate_(ImmutableBitSet groupSet, ImmutableList<ImmutableBitSet> groupSets, RelNode input, List<AggregateCall> aggregateCalls, List<RexNode> extraNodes, List<Field> inFields) {
        RelNode aggregate = this.struct.aggregateFactory.createAggregate(input, (List<RelHint>)ImmutableList.of(), groupSet, groupSets, aggregateCalls);
        ImmutableList.Builder fields = ImmutableList.builder();
        List<RelDataTypeField> aggregateFields = aggregate.getRowType().getFieldList();
        int i = 0;
        for (Integer groupField : groupSet.asList()) {
            RexNode node = extraNodes.get(groupField);
            SqlKind kind = node.getKind();
            switch (kind) {
                case INPUT_REF: {
                    fields.add((Object)inFields.get(((RexInputRef)node).getIndex()));
                    break;
                }
                default: {
                    String name = aggregateFields.get(i).getName();
                    RelDataTypeFieldImpl fieldType = new RelDataTypeFieldImpl(name, i, node.getType());
                    fields.add((Object)new Field((ImmutableSet<String>)ImmutableSet.of(), fieldType));
                }
            }
            ++i;
        }
        for (int j = 0; j < aggregateCalls.size(); ++j) {
            AggregateCall call = aggregateCalls.get(j);
            RelDataTypeFieldImpl fieldType = new RelDataTypeFieldImpl(aggregateFields.get(i + j).getName(), i + j, call.getType());
            fields.add((Object)new Field((ImmutableSet<String>)ImmutableSet.of(), fieldType));
        }
        this.stack.push(new Frame(aggregate, fields.build()));
        return this;
    }

    private RelBuilder rewriteAggregateWithDuplicateGroupSets(ImmutableBitSet groupSet, ImmutableSortedMultiset<ImmutableBitSet> groupSets, List<AggCallPlus> aggregateCalls) {
        int groupId;
        List<String> fieldNamesIfNoRewrite = Aggregate.deriveRowType(this.getTypeFactory(), this.peek().getRowType(), false, groupSet, (List<ImmutableBitSet>)groupSets.asList(), (List)aggregateCalls.stream().map(AggCallPlus::aggregateCall).collect(Util.toImmutableList())).getFieldNames();
        HashMap<Integer, Set> groupIdToGroupSets = new HashMap<Integer, Set>();
        int maxGroupId = 0;
        for (Multiset.Entry entry : groupSets.entrySet()) {
            groupId = entry.getCount() - 1;
            if (groupId > maxGroupId) {
                maxGroupId = groupId;
            }
            for (int i = 0; i <= groupId; ++i) {
                groupIdToGroupSets.computeIfAbsent(i, k -> Sets.newTreeSet(ImmutableBitSet.COMPARATOR)).add(entry.getElement());
            }
        }
        ArrayList<AggCallPlus> aggregateCallsWithoutGroupId = new ArrayList<AggCallPlus>(aggregateCalls);
        aggregateCallsWithoutGroupId.removeIf(RelBuilder::isGroupId);
        Frame frame = this.stack.pop();
        for (groupId = 0; groupId <= maxGroupId; ++groupId) {
            this.stack.push(frame);
            this.aggregate(this.groupKey(groupSet, (Iterable)Nullness.castNonNull(groupIdToGroupSets.get(groupId))), (Iterable<? extends AggCall>)aggregateCallsWithoutGroupId);
            ArrayList<RexNode> selectList = new ArrayList<RexNode>();
            int groupExprLength = groupSet.cardinality();
            for (int i = 0; i < groupExprLength; ++i) {
                selectList.add(this.field(i));
            }
            int groupIdCount = 0;
            for (int i = 0; i < aggregateCalls.size(); ++i) {
                if (RelBuilder.isGroupId(aggregateCalls.get(i))) {
                    selectList.add(this.getRexBuilder().makeExactLiteral(BigDecimal.valueOf(groupId), this.getTypeFactory().createSqlType(SqlTypeName.BIGINT)));
                    ++groupIdCount;
                    continue;
                }
                selectList.add(this.field(groupExprLength + i - groupIdCount));
            }
            this.project(selectList, fieldNamesIfNoRewrite);
        }
        return this.union(true, maxGroupId + 1);
    }

    private static boolean isGroupId(AggCall c) {
        return ((AggCallPlus)c).op().kind == SqlKind.GROUP_ID;
    }

    private RelBuilder setOp(boolean all, SqlKind kind, int n) {
        ArrayList<RelNode> inputs = new ArrayList<RelNode>();
        for (int i = 0; i < n; ++i) {
            inputs.add(0, this.build());
        }
        switch (kind) {
            case UNION: 
            case INTERSECT: 
            case EXCEPT: {
                if (n >= 1) break;
                throw new IllegalArgumentException("bad INTERSECT/UNION/EXCEPT input count");
            }
            default: {
                throw new AssertionError((Object)("bad setOp " + (Object)((Object)kind)));
            }
        }
        if (n == 1) {
            return this.push((RelNode)inputs.get(0));
        }
        if (this.config.simplifyValues() && kind == SqlKind.UNION && inputs.stream().allMatch(r -> r instanceof Values)) {
            List<RelDataType> inputTypes = Util.transform(inputs, RelNode::getRowType);
            RelDataType rowType = this.getTypeFactory().leastRestrictive(inputTypes);
            Objects.requireNonNull(rowType, () -> "leastRestrictive(" + inputTypes + ")");
            ArrayList<ImmutableList<RexLiteral>> tuples = new ArrayList<ImmutableList<RexLiteral>>();
            for (RelNode input : inputs) {
                tuples.addAll((Collection<ImmutableList<RexLiteral>>)((Values)input).tuples);
            }
            List<Object> tuples2 = all ? tuples : Util.distinctList(tuples);
            return this.values(tuples2, rowType);
        }
        return this.push(this.struct.setOpFactory.createSetOp(kind, inputs, all));
    }

    public RelBuilder union(boolean all) {
        return this.union(all, 2);
    }

    public RelBuilder union(boolean all, int n) {
        return this.setOp(all, SqlKind.UNION, n);
    }

    public RelBuilder intersect(boolean all) {
        return this.intersect(all, 2);
    }

    public RelBuilder intersect(boolean all, int n) {
        return this.setOp(all, SqlKind.INTERSECT, n);
    }

    public RelBuilder minus(boolean all) {
        return this.minus(all, 2);
    }

    public RelBuilder minus(boolean all, int n) {
        return this.setOp(all, SqlKind.EXCEPT, n);
    }

    public RelBuilder transientScan(String tableName) {
        return this.transientScan(tableName, this.peek().getRowType());
    }

    public RelBuilder transientScan(String tableName, RelDataType rowType) {
        ListTransientTable transientTable = new ListTransientTable(tableName, rowType);
        Objects.requireNonNull(this.relOptSchema, "relOptSchema");
        RelOptTableImpl relOptTable = RelOptTableImpl.create(this.relOptSchema, rowType, (Table)transientTable, (ImmutableList<String>)ImmutableList.of((Object)tableName));
        RelNode scan = this.struct.scanFactory.createScan(ViewExpanders.toRelContext(this.viewExpander, this.cluster), relOptTable);
        this.push(scan);
        this.rename(rowType.getFieldNames());
        return this;
    }

    private RelBuilder tableSpool(Spool.Type readType, Spool.Type writeType, RelOptTable table) {
        RelNode spool = this.struct.spoolFactory.createTableSpool(this.peek(), readType, writeType, table);
        this.replaceTop(spool);
        return this;
    }

    public RelBuilder repeatUnion(String tableName, boolean all) {
        return this.repeatUnion(tableName, all, -1);
    }

    public RelBuilder repeatUnion(String tableName, boolean all, int iterationLimit) {
        RelOptTableFinder finder = new RelOptTableFinder(tableName);
        for (int i = 0; i < this.stack.size(); ++i) {
            this.peek(i).accept(finder);
            if (finder.relOptTable != null) break;
        }
        if (finder.relOptTable == null) {
            throw Static.RESOURCE.tableNotFound(tableName).ex();
        }
        RelNode iterative = this.tableSpool(Spool.Type.LAZY, Spool.Type.LAZY, finder.relOptTable).build();
        RelNode seed = this.tableSpool(Spool.Type.LAZY, Spool.Type.LAZY, finder.relOptTable).build();
        RelNode repeatUnion = this.struct.repeatUnionFactory.createRepeatUnion(seed, iterative, all, iterationLimit, finder.relOptTable);
        return this.push(repeatUnion);
    }

    public RelBuilder join(JoinRelType joinType, RexNode condition0, RexNode ... conditions) {
        return this.join(joinType, Lists.asList((Object)condition0, (Object[])conditions));
    }

    public RelBuilder join(JoinRelType joinType, Iterable<? extends RexNode> conditions) {
        return this.join(joinType, this.and(conditions), (Set<CorrelationId>)ImmutableSet.of());
    }

    public RelBuilder join(JoinRelType joinType, RexNode condition) {
        return this.join(joinType, condition, (Set<CorrelationId>)ImmutableSet.of());
    }

    public RelBuilder join(JoinRelType joinType, RexNode condition, Set<CorrelationId> variablesSet) {
        RelNode join;
        Frame right = this.stack.pop();
        Frame left = this.stack.pop();
        boolean correlate = this.checkIfCorrelated(variablesSet, joinType, left.rel, right.rel);
        RexNode postCondition = this.literal(true);
        if (this.config.simplify()) {
            if (condition instanceof RexCall) {
                condition = RelOptUtil.collapseExpandedIsNotDistinctFromExpr((RexCall)condition, this.getRexBuilder());
            }
            condition = this.simplifier.simplifyUnknownAsFalse(condition);
        }
        if (correlate) {
            CorrelationId id = (CorrelationId)Iterables.getOnlyElement(variablesSet);
            switch (joinType) {
                case LEFT: 
                case SEMI: 
                case ANTI: {
                    this.stack.push(right);
                    this.filter(condition.accept(new Shifter(left.rel, id, right.rel)));
                    right = this.stack.pop();
                    break;
                }
                case INNER: {
                    postCondition = condition;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Correlated " + (Object)((Object)joinType) + " join is not supported");
                }
            }
            ImmutableBitSet requiredColumns = RelOptUtil.correlationColumns(id, right.rel);
            join = this.struct.correlateFactory.createCorrelate(left.rel, right.rel, (List<RelHint>)ImmutableList.of(), id, requiredColumns, joinType);
        } else {
            RelNode join0 = this.struct.joinFactory.createJoin(left.rel, right.rel, (List<RelHint>)ImmutableList.of(), condition, variablesSet, joinType, false);
            join = join0 instanceof Join && this.config.pushJoinCondition() ? RelOptUtil.pushDownJoinConditions((Join)join0, this) : join0;
        }
        ImmutableList.Builder fields = ImmutableList.builder();
        fields.addAll(left.fields);
        fields.addAll(right.fields);
        this.stack.push(new Frame(join, fields.build()));
        this.filter(postCondition);
        return this;
    }

    public RelBuilder correlate(JoinRelType joinType, CorrelationId correlationId, RexNode ... requiredFields) {
        return this.correlate(joinType, correlationId, (Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])requiredFields));
    }

    public RelBuilder correlate(JoinRelType joinType, CorrelationId correlationId, Iterable<? extends RexNode> requiredFields) {
        Frame right = this.stack.pop();
        Registrar registrar = new Registrar((Iterable<RexNode>)this.fields(), this.peek().getRowType().getFieldNames());
        List<Integer> requiredOrdinals = registrar.registerExpressions((Iterable<? extends RexNode>)ImmutableList.copyOf(requiredFields));
        this.project(registrar.extraNodes);
        this.rename(registrar.names);
        Frame left = this.stack.pop();
        RelNode correlate = this.struct.correlateFactory.createCorrelate(left.rel, right.rel, (List<RelHint>)ImmutableList.of(), correlationId, ImmutableBitSet.of(requiredOrdinals), joinType);
        ImmutableList.Builder fields = ImmutableList.builder();
        fields.addAll(left.fields);
        fields.addAll(right.fields);
        this.stack.push(new Frame(correlate, fields.build()));
        return this;
    }

    public RelBuilder join(JoinRelType joinType, String ... fieldNames) {
        ArrayList<RexNode> conditions = new ArrayList<RexNode>();
        for (String fieldName : fieldNames) {
            conditions.add(this.equals(this.field(2, 0, fieldName), this.field(2, 1, fieldName)));
        }
        return this.join(joinType, conditions);
    }

    public RelBuilder semiJoin(Iterable<? extends RexNode> conditions) {
        Frame right = this.stack.pop();
        RelNode semiJoin = this.struct.joinFactory.createJoin(this.peek(), right.rel, (List<RelHint>)ImmutableList.of(), this.and(conditions), (Set<CorrelationId>)ImmutableSet.of(), JoinRelType.SEMI, false);
        this.replaceTop(semiJoin);
        return this;
    }

    public RelBuilder semiJoin(RexNode ... conditions) {
        return this.semiJoin((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])conditions));
    }

    public RelBuilder antiJoin(Iterable<? extends RexNode> conditions) {
        Frame right = this.stack.pop();
        RelNode antiJoin = this.struct.joinFactory.createJoin(this.peek(), right.rel, (List<RelHint>)ImmutableList.of(), this.and(conditions), (Set<CorrelationId>)ImmutableSet.of(), JoinRelType.ANTI, false);
        this.replaceTop(antiJoin);
        return this;
    }

    public RelBuilder antiJoin(RexNode ... conditions) {
        return this.antiJoin((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])conditions));
    }

    public RelBuilder as(String alias) {
        Frame pair = this.stack.pop();
        List<Field> newFields = Util.transform(pair.fields, field -> field.addAlias(alias));
        this.stack.push(new Frame(pair.rel, ImmutableList.copyOf(newFields)));
        return this;
    }

    public RelBuilder values(@Nullable String[] fieldNames, Object ... values) {
        Objects.requireNonNull(fieldNames, "fieldNames");
        if (fieldNames.length == 0 || values.length % fieldNames.length != 0 || values.length < fieldNames.length) {
            throw new IllegalArgumentException("Value count must be a positive multiple of field count");
        }
        int rowCount = values.length / fieldNames.length;
        for (Ord fieldName : Ord.zip((Object[])fieldNames)) {
            if (!RelBuilder.allNull(values, fieldName.i, fieldNames.length)) continue;
            throw new IllegalArgumentException("All values of field '" + (String)fieldName.e + "' (field index " + fieldName.i + ") are null; cannot deduce type");
        }
        ImmutableList<ImmutableList<RexLiteral>> tupleList = this.tupleList(fieldNames.length, values);
        assert (tupleList.size() == rowCount);
        List<String> fieldNameList = Util.transformIndexed(Arrays.asList(fieldNames), (name, i) -> name != null ? name : SqlUtil.deriveAliasFromOrdinal(i));
        return this.values((List<? extends List<RexLiteral>>)tupleList, fieldNameList);
    }

    private RelBuilder values(final List<? extends List<RexLiteral>> tupleList, List<String> fieldNames) {
        RelDataTypeFactory typeFactory = this.cluster.getTypeFactory();
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        Ord.forEach(fieldNames, (fieldName, i) -> {
            RelDataType type = typeFactory.leastRestrictive((List<RelDataType>)new AbstractList<RelDataType>(){

                @Override
                public RelDataType get(int index) {
                    return ((RexLiteral)((List)tupleList.get(index)).get(i)).getType();
                }

                @Override
                public int size() {
                    return tupleList.size();
                }
            });
            assert (type != null) : "can't infer type for field " + i + ", " + fieldName;
            builder.add((String)fieldName, type);
        });
        RelDataType rowType = builder.build();
        return this.values(tupleList, rowType);
    }

    private ImmutableList<ImmutableList<RexLiteral>> tupleList(int columnCount, @Nullable Object[] values) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        ArrayList<RexLiteral> valueList = new ArrayList<RexLiteral>();
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            valueList.add(this.literal(value));
            if ((i + 1) % columnCount != 0) continue;
            listBuilder.add((Object)ImmutableList.copyOf(valueList));
            valueList.clear();
        }
        return listBuilder.build();
    }

    private static boolean allNull(@Nullable Object[] values, int column, int columnCount) {
        for (int i = column; i < values.length; i += columnCount) {
            if (values[i] == null) continue;
            return false;
        }
        return true;
    }

    public RelBuilder empty() {
        Frame frame = this.stack.pop();
        RelNode values = this.struct.valuesFactory.createValues(this.cluster, frame.rel.getRowType(), (List<ImmutableList<RexLiteral>>)ImmutableList.of());
        this.stack.push(new Frame(values, frame.fields));
        return this;
    }

    public RelBuilder values(RelDataType rowType, Object ... columnValues) {
        ImmutableList<ImmutableList<RexLiteral>> tupleList = this.tupleList(rowType.getFieldCount(), columnValues);
        RelNode values = this.struct.valuesFactory.createValues(this.cluster, rowType, (List<ImmutableList<RexLiteral>>)ImmutableList.copyOf(tupleList));
        this.push(values);
        return this;
    }

    public RelBuilder values(Iterable<? extends List<RexLiteral>> tupleList, RelDataType rowType) {
        RelNode values = this.struct.valuesFactory.createValues(this.cluster, rowType, (List<ImmutableList<RexLiteral>>)RelBuilder.copy(tupleList));
        this.push(values);
        return this;
    }

    public RelBuilder values(RelDataType rowType) {
        return this.values((Iterable<? extends List<RexLiteral>>)ImmutableList.of(), rowType);
    }

    private static <E> ImmutableList<ImmutableList<E>> copy(Iterable<? extends List<E>> tupleList) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int changeCount = 0;
        for (List<E> literals : tupleList) {
            ImmutableList literals2 = ImmutableList.copyOf(literals);
            builder.add((Object)literals2);
            if (literals == literals2) continue;
            ++changeCount;
        }
        if (changeCount == 0 && tupleList instanceof ImmutableList) {
            return (ImmutableList)tupleList;
        }
        return builder.build();
    }

    public RelBuilder limit(int offset, int fetch) {
        return this.sortLimit(offset, fetch, (Iterable<? extends RexNode>)ImmutableList.of());
    }

    public RelBuilder exchange(RelDistribution distribution) {
        RelNode exchange = this.struct.exchangeFactory.createExchange(this.peek(), distribution);
        this.replaceTop(exchange);
        return this;
    }

    public RelBuilder sortExchange(RelDistribution distribution, RelCollation collation) {
        RelNode exchange = this.struct.sortExchangeFactory.createSortExchange(this.peek(), distribution, collation);
        this.replaceTop(exchange);
        return this;
    }

    public RelBuilder sort(int ... fields) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int field : fields) {
            builder.add((Object)(field < 0 ? this.desc(this.field(-field - 1)) : this.field(field)));
        }
        return this.sortLimit(-1, -1, (Iterable<? extends RexNode>)builder.build());
    }

    public RelBuilder sort(RexNode ... nodes) {
        return this.sortLimit(-1, -1, (Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    public RelBuilder sort(Iterable<? extends RexNode> nodes) {
        return this.sortLimit(-1, -1, nodes);
    }

    public RelBuilder sortLimit(int offset, int fetch, RexNode ... nodes) {
        return this.sortLimit(offset, fetch, (Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    public RelBuilder sort(RelCollation collation) {
        RelNode sort = this.struct.sortFactory.createSort(this.peek(), collation, null, null);
        this.replaceTop(sort);
        return this;
    }

    public RelBuilder sortLimit(int offset, int fetch, Iterable<? extends RexNode> nodes) {
        @Nullable RexLiteral offsetNode = offset <= 0 ? null : this.literal(offset);
        @Nullable RexLiteral fetchNode = fetch < 0 ? null : this.literal(fetch);
        return this.sortLimit(offsetNode, fetchNode, nodes);
    }

    public RelBuilder sortLimit(@Nullable RexNode offsetNode, @Nullable RexNode fetchNode, Iterable<? extends RexNode> nodes) {
        int fetch;
        if (offsetNode != null && !(offsetNode instanceof RexLiteral) && !(offsetNode instanceof RexDynamicParam)) {
            throw new IllegalArgumentException("OFFSET node must be RexLiteral or RexDynamicParam");
        }
        if (fetchNode != null && !(fetchNode instanceof RexLiteral) && !(fetchNode instanceof RexDynamicParam)) {
            throw new IllegalArgumentException("FETCH node must be RexLiteral or RexDynamicParam");
        }
        Registrar registrar = new Registrar((Iterable<RexNode>)this.fields(), (List<String>)ImmutableList.of());
        List<RelFieldCollation> fieldCollations = registrar.registerFieldCollations(nodes);
        int n = fetch = fetchNode instanceof RexLiteral ? RexLiteral.intValue(fetchNode) : -1;
        if (offsetNode == null && fetch == 0 && this.config.simplifyLimit()) {
            return this.empty();
        }
        if (offsetNode == null && fetchNode == null && fieldCollations.isEmpty()) {
            return this;
        }
        if (fieldCollations.isEmpty()) {
            Project project;
            assert (registrar.addedFieldCount() == 0);
            RelNode top = this.peek();
            if (top instanceof Sort) {
                Sort sort2 = (Sort)top;
                if (sort2.offset == null && sort2.fetch == null) {
                    this.replaceTop(sort2.getInput());
                    RelNode sort = this.struct.sortFactory.createSort(this.peek(), sort2.collation, offsetNode, fetchNode);
                    this.replaceTop(sort);
                    return this;
                }
            }
            if (top instanceof Project && (project = (Project)top).getInput() instanceof Sort) {
                Sort sort2 = (Sort)project.getInput();
                if (sort2.offset == null && sort2.fetch == null) {
                    RelNode sort = this.struct.sortFactory.createSort(sort2.getInput(), sort2.collation, offsetNode, fetchNode);
                    this.replaceTop(this.struct.projectFactory.createProject(sort, (List<RelHint>)project.getHints(), (List<? extends RexNode>)project.getProjects(), (List<? extends String>)Pair.right(project.getNamedProjects()), project.getVariablesSet()));
                    return this;
                }
            }
        }
        if (registrar.addedFieldCount() > 0) {
            this.project(registrar.extraNodes);
        }
        RelNode sort = this.struct.sortFactory.createSort(this.peek(), RelCollations.of(fieldCollations), offsetNode, fetchNode);
        this.replaceTop(sort);
        if (registrar.addedFieldCount() > 0) {
            this.project(registrar.originalExtraNodes);
        }
        return this;
    }

    private static RelFieldCollation collation(RexNode node, RelFieldCollation.Direction direction, @Nullable RelFieldCollation.NullDirection nullDirection, List<RexNode> extraNodes) {
        switch (node.getKind()) {
            case INPUT_REF: {
                return new RelFieldCollation(((RexInputRef)node).getIndex(), direction, Util.first(nullDirection, direction.defaultNullDirection()));
            }
            case DESCENDING: {
                return RelBuilder.collation(((RexCall)node).getOperands().get(0), RelFieldCollation.Direction.DESCENDING, nullDirection, extraNodes);
            }
            case NULLS_FIRST: {
                return RelBuilder.collation(((RexCall)node).getOperands().get(0), direction, RelFieldCollation.NullDirection.FIRST, extraNodes);
            }
            case NULLS_LAST: {
                return RelBuilder.collation(((RexCall)node).getOperands().get(0), direction, RelFieldCollation.NullDirection.LAST, extraNodes);
            }
        }
        int fieldIndex = extraNodes.size();
        extraNodes.add(node);
        return new RelFieldCollation(fieldIndex, direction, Util.first(nullDirection, direction.defaultNullDirection()));
    }

    private static RexFieldCollation rexCollation(RexNode node, RelFieldCollation.Direction direction, @Nullable RelFieldCollation.NullDirection nullDirection) {
        switch (node.getKind()) {
            case DESCENDING: {
                return RelBuilder.rexCollation((RexNode)((RexCall)node).operands.get(0), RelFieldCollation.Direction.DESCENDING, nullDirection);
            }
            case NULLS_LAST: {
                return RelBuilder.rexCollation((RexNode)((RexCall)node).operands.get(0), direction, RelFieldCollation.NullDirection.LAST);
            }
            case NULLS_FIRST: {
                return RelBuilder.rexCollation((RexNode)((RexCall)node).operands.get(0), direction, RelFieldCollation.NullDirection.FIRST);
            }
        }
        EnumSet<SqlKind> flags = EnumSet.noneOf(SqlKind.class);
        if (direction == RelFieldCollation.Direction.DESCENDING) {
            flags.add(SqlKind.DESCENDING);
        }
        if (nullDirection == RelFieldCollation.NullDirection.FIRST) {
            flags.add(SqlKind.NULLS_FIRST);
        }
        if (nullDirection == RelFieldCollation.NullDirection.LAST) {
            flags.add(SqlKind.NULLS_LAST);
        }
        return new RexFieldCollation(node, (Set<SqlKind>)flags);
    }

    public RelBuilder convert(RelDataType castRowType, boolean rename) {
        RelNode r = this.build();
        RelNode r2 = RelOptUtil.createCastRel(r, castRowType, rename, this.struct.projectFactory);
        this.push(r2);
        return this;
    }

    public RelBuilder permute(Mapping mapping) {
        assert (mapping.getMappingType().isSingleSource());
        assert (mapping.getMappingType().isMandatorySource());
        if (mapping.isIdentity()) {
            return this;
        }
        ArrayList<RexInputRef> exprList = new ArrayList<RexInputRef>();
        for (int i = 0; i < mapping.getTargetCount(); ++i) {
            exprList.add(this.field(mapping.getSource(i)));
        }
        return this.project(exprList);
    }

    public RelBuilder match(RexNode pattern, boolean strictStart, boolean strictEnd, Map<String, RexNode> patternDefinitions, Iterable<? extends RexNode> measureList, RexNode after, Map<String, ? extends SortedSet<String>> subsets, boolean allRows, Iterable<? extends RexNode> partitionKeys, Iterable<? extends RexNode> orderKeys, RexNode interval) {
        Registrar registrar = new Registrar((Iterable<RexNode>)this.fields(), this.peek().getRowType().getFieldNames());
        List<RelFieldCollation> fieldCollations = registrar.registerFieldCollations(orderKeys);
        ImmutableBitSet partitionBitSet = ImmutableBitSet.of(registrar.registerExpressions(partitionKeys));
        RelDataTypeFactory.FieldInfoBuilder typeBuilder = this.cluster.getTypeFactory().builder();
        for (RexNode rexNode : partitionKeys) {
            ((RelDataTypeFactory.Builder)typeBuilder).add(rexNode.toString(), rexNode.getType());
        }
        if (allRows) {
            for (RexNode rexNode : orderKeys) {
                if (typeBuilder.nameExists(rexNode.toString())) continue;
                ((RelDataTypeFactory.Builder)typeBuilder).add(rexNode.toString(), rexNode.getType());
            }
            RelDataType inputRowType = this.peek().getRowType();
            for (RelDataTypeField relDataTypeField : inputRowType.getFieldList()) {
                if (typeBuilder.nameExists(relDataTypeField.getName())) continue;
                ((RelDataTypeFactory.Builder)typeBuilder).add(relDataTypeField);
            }
        }
        ImmutableMap.Builder measures = ImmutableMap.builder();
        for (RexNode rexNode : measureList) {
            List<RexNode> operands = ((RexCall)rexNode).getOperands();
            String alias = operands.get(1).toString();
            ((RelDataTypeFactory.Builder)typeBuilder).add(alias, operands.get(0).getType());
            measures.put((Object)alias, (Object)operands.get(0));
        }
        RelNode relNode = this.struct.matchFactory.createMatch(this.peek(), pattern, typeBuilder.build(), strictStart, strictEnd, patternDefinitions, (Map<String, RexNode>)measures.build(), after, subsets, allRows, partitionBitSet, RelCollations.of(fieldCollations), interval);
        this.stack.push(new Frame(relNode));
        return this;
    }

    public RelBuilder pivot(GroupKey groupKey, Iterable<? extends AggCall> aggCalls, Iterable<? extends RexNode> axes, Iterable<? extends Map.Entry<String, ? extends Iterable<? extends RexNode>>> values) {
        ImmutableList axisList = ImmutableList.copyOf(axes);
        ArrayList multipliedAggCalls = new ArrayList();
        Pair.forEach(values, (arg_0, arg_1) -> this.lambda$pivot$23((List)axisList, aggCalls, multipliedAggCalls, arg_0, arg_1));
        return this.aggregate(groupKey, multipliedAggCalls);
    }

    public RelBuilder unpivot(boolean includeNulls, Iterable<String> measureNames, Iterable<String> axisNames, Iterable<? extends Map.Entry<? extends List<? extends RexLiteral>, ? extends List<? extends RexNode>>> axisMap) {
        ImmutableList measureNameList = ImmutableList.copyOf(measureNames);
        ImmutableList axisNameList = ImmutableList.copyOf(axisNames);
        PairList<List, List> map = PairList.of();
        Pair.forEach(axisMap, (valueList, inputMeasureList) -> map.add((List)ImmutableList.copyOf((Collection)valueList), (List)ImmutableList.copyOf((Collection)inputMeasureList)));
        map.forEach((arg_0, arg_1) -> RelBuilder.lambda$unpivot$25((List)measureNameList, (List)axisNameList, arg_0, arg_1));
        RelDataType leftRowType = this.peek().getRowType();
        BitSet usedFields = new BitSet();
        map.forEach((aliases, nodes) -> nodes.forEach(node -> {
            if (node instanceof RexInputRef) {
                usedFields.set(((RexInputRef)node).getIndex());
            }
        }));
        this.values((List<? extends List<RexLiteral>>)ImmutableList.copyOf(map.leftList()), (List<String>)axisNameList);
        this.join(JoinRelType.INNER, new String[0]);
        ImmutableBitSet unusedFields = ImmutableBitSet.range(leftRowType.getFieldCount()).except(ImmutableBitSet.fromBitSet(usedFields));
        ArrayList<RexNode> projects = new ArrayList<RexNode>((Collection<RexNode>)this.fields(unusedFields));
        Ord.forEach((Iterable)axisNameList, (dimensionName, d) -> projects.add(this.alias(this.field(leftRowType.getFieldCount() + d), (String)dimensionName)));
        ArrayList conditions = new ArrayList();
        Ord.forEach((Iterable)measureNameList, (measureName, m) -> {
            ArrayList<RexNode> caseOperands = new ArrayList<RexNode>();
            map.forEach((literals, nodes) -> {
                Ord.forEach((Iterable)literals, (literal, d) -> conditions.add(this.equals(this.field(leftRowType.getFieldCount() + d), (RexNode)literal)));
                caseOperands.add(this.and(conditions));
                conditions.clear();
                caseOperands.add((RexNode)nodes.get(m));
            });
            caseOperands.add(this.literal(null));
            projects.add(this.alias(this.call((SqlOperator)SqlStdOperatorTable.CASE, (List<RexNode>)caseOperands), (String)measureName));
        });
        this.project(projects);
        if (!includeNulls) {
            BitSet notNullFields = new BitSet();
            Ord.forEach((Iterable)measureNameList, (arg_0, arg_1) -> this.lambda$unpivot$32(unusedFields, (List)axisNameList, conditions, notNullFields, arg_0, arg_1));
            this.filter(this.or(conditions));
            if (measureNameList.size() == 1) {
                RelDataTypeFactory.FieldInfoBuilder builder = this.getTypeFactory().builder();
                this.peek().getRowType().getFieldList().forEach(field -> {
                    RelDataType type = field.getType();
                    builder.add(field.getName(), notNullFields.get(field.getIndex()) ? this.getTypeFactory().createTypeWithNullability(type, false) : type);
                });
                this.convert(builder.build(), false);
            }
            conditions.clear();
        }
        return this;
    }

    public RelBuilder hints(RelHint ... hints) {
        return this.hints((Iterable<RelHint>)ImmutableList.copyOf((Object[])hints));
    }

    public RelBuilder hints(Iterable<RelHint> hints) {
        List relHintList;
        Objects.requireNonNull(hints, "hints");
        List list = relHintList = hints instanceof List ? (List)hints : Lists.newArrayList(hints);
        if (relHintList.isEmpty()) {
            return this;
        }
        Frame frame = this.peek_();
        assert (frame != null) : "There is no relational expression to attach the hints";
        assert (frame.rel instanceof Hintable) : "The top relational expression is not a Hintable";
        Hintable hintable = (Hintable)((Object)frame.rel);
        this.replaceTop(hintable.attachHints(relHintList));
        return this;
    }

    public void clear() {
        this.stack.clear();
    }

    private boolean checkIfCorrelated(Set<CorrelationId> variablesSet, JoinRelType joinType, RelNode leftNode, RelNode rightRel) {
        if (variablesSet.size() != 1) {
            return false;
        }
        if (!this.config.convertCorrelateToJoin()) {
            return true;
        }
        CorrelationId id = (CorrelationId)Iterables.getOnlyElement(variablesSet);
        if (!RelOptUtil.notContainsCorrelation(leftNode, id, Litmus.IGNORE)) {
            throw new IllegalArgumentException("variable " + id + " must not be used by left input to correlation");
        }
        switch (joinType) {
            case RIGHT: 
            case FULL: {
                throw new IllegalArgumentException("Correlated " + (Object)((Object)joinType) + " join is not supported");
            }
        }
        return !RelOptUtil.correlationColumns((CorrelationId)Iterables.getOnlyElement(variablesSet), rightRel).isEmpty();
    }

    private /* synthetic */ void lambda$unpivot$32(ImmutableBitSet unusedFields, List axisNameList, List conditions, BitSet notNullFields, String measureName, int m) {
        int f = unusedFields.cardinality() + axisNameList.size() + m;
        conditions.add(this.isNotNull(this.field(f)));
        notNullFields.set(f);
    }

    private static /* synthetic */ void lambda$unpivot$25(List measureNameList, List axisNameList, List valueList, List inputMeasureList) {
        if (inputMeasureList.size() != measureNameList.size()) {
            throw new IllegalArgumentException("Number of measures (" + inputMeasureList.size() + ") must match number of measure names (" + measureNameList.size() + ")");
        }
        if (valueList.size() != axisNameList.size()) {
            throw new IllegalArgumentException("Number of axis values (" + valueList.size() + ") match match number of axis names (" + axisNameList.size() + ")");
        }
    }

    private /* synthetic */ void lambda$pivot$23(List axisList, Iterable aggCalls, List multipliedAggCalls, String alias, Iterable expressions) {
        ImmutableList expressionList = ImmutableList.copyOf((Iterable)expressions);
        if (expressionList.size() != axisList.size()) {
            throw new IllegalArgumentException("value count must match axis count [" + expressionList + "], [" + axisList + "]");
        }
        aggCalls.forEach(arg_0 -> this.lambda$null$22(alias, axisList, (List)expressionList, multipliedAggCalls, arg_0));
    }

    private /* synthetic */ void lambda$null$22(String alias, List axisList, List expressionList, List multipliedAggCalls, AggCall aggCall) {
        String alias2 = alias + "_" + ((AggCallPlus)aggCall).alias();
        ArrayList filters = new ArrayList();
        Pair.forEach(axisList, expressionList, (axis, expression) -> filters.add(this.equals((RexNode)axis, (RexNode)expression)));
        multipliedAggCalls.add(aggCall.filter(this.and(filters)).as(alias2));
    }

    @Value.Immutable
    public static interface Config {
        public static final Config DEFAULT = ImmutableRelBuilder.Config.of();

        @Value.Default
        default public int bloat() {
            return 100;
        }

        public Config withBloat(int var1);

        @Value.Default
        default public boolean dedupAggregateCalls() {
            return true;
        }

        public Config withDedupAggregateCalls(boolean var1);

        @Value.Default
        default public boolean pruneInputOfAggregate() {
            return true;
        }

        public Config withPruneInputOfAggregate(boolean var1);

        @Value.Default
        default public boolean preventEmptyFieldList() {
            return true;
        }

        public Config withPreventEmptyFieldList(boolean var1);

        @Value.Default
        default public boolean pushJoinCondition() {
            return false;
        }

        public Config withPushJoinCondition(boolean var1);

        @Value.Default
        default public boolean simplify() {
            return true;
        }

        public Config withSimplify(boolean var1);

        @Value.Default
        default public boolean simplifyLimit() {
            return true;
        }

        public Config withSimplifyLimit(boolean var1);

        @Value.Default
        default public boolean simplifyValues() {
            return true;
        }

        public Config withSimplifyValues(boolean var1);

        @Value.Default
        default public boolean aggregateUnique() {
            return false;
        }

        public Config withAggregateUnique(boolean var1);

        @Value.Default
        default public boolean convertCorrelateToJoin() {
            return true;
        }

        public Config withConvertCorrelateToJoin(boolean var1);
    }

    private class Shifter
    extends RexShuttle {
        private final RelNode left;
        private final CorrelationId id;
        private final RelNode right;

        Shifter(RelNode left, CorrelationId id, RelNode right) {
            this.left = left;
            this.id = id;
            this.right = right;
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            RelDataType leftRowType = this.left.getRowType();
            RexBuilder rexBuilder = RelBuilder.this.getRexBuilder();
            int leftCount = leftRowType.getFieldCount();
            if (inputRef.getIndex() < leftCount) {
                RexNode v = rexBuilder.makeCorrel(leftRowType, this.id);
                return rexBuilder.makeFieldAccess(v, inputRef.getIndex());
            }
            return rexBuilder.makeInputRef(this.right, inputRef.getIndex() - leftCount);
        }
    }

    private static class Field
    extends Pair<ImmutableSet<String>, RelDataTypeField> {
        Field(ImmutableSet<String> left, RelDataTypeField right) {
            super(left, right);
        }

        Field addAlias(String alias) {
            if (((ImmutableSet)this.left).contains((Object)alias)) {
                return this;
            }
            ImmutableSet aliasList = ImmutableSet.builder().addAll((Iterable)this.left).add((Object)alias).build();
            return new Field((ImmutableSet<String>)aliasList, (RelDataTypeField)this.right);
        }
    }

    private static class Frame {
        final RelNode rel;
        final ImmutableList<Field> fields;

        private Frame(RelNode rel, ImmutableList<Field> fields) {
            this.rel = rel;
            this.fields = fields;
        }

        private Frame(RelNode rel) {
            String tableAlias = Frame.deriveAlias(rel);
            ImmutableList.Builder builder = ImmutableList.builder();
            ImmutableSet aliases = tableAlias == null ? ImmutableSet.of() : ImmutableSet.of((Object)tableAlias);
            for (RelDataTypeField field : rel.getRowType().getFieldList()) {
                builder.add((Object)new Field((ImmutableSet<String>)aliases, field));
            }
            this.rel = rel;
            this.fields = builder.build();
        }

        public String toString() {
            return this.rel + ": " + this.fields;
        }

        private static @Nullable String deriveAlias(RelNode rel) {
            TableScan scan;
            List<String> names;
            if (rel instanceof TableScan && !(names = (scan = (TableScan)rel).getTable().getQualifiedName()).isEmpty()) {
                return Util.last(names);
            }
            return null;
        }

        List<RelDataTypeField> fields() {
            return Pair.right(this.fields);
        }
    }

    private static class Registrar {
        final List<RexNode> originalExtraNodes;
        final List<RexNode> extraNodes;
        final List<@Nullable String> names;

        Registrar(Iterable<RexNode> fields, List<String> fieldNames) {
            this.originalExtraNodes = ImmutableList.copyOf(fields);
            this.extraNodes = new ArrayList<RexNode>(this.originalExtraNodes);
            this.names = new ArrayList<String>(fieldNames);
        }

        int registerExpression(RexNode node) {
            switch (node.getKind()) {
                case AS: {
                    ImmutableList<RexNode> operands = ((RexCall)node).operands;
                    int i = this.registerExpression((RexNode)operands.get(0));
                    this.names.set(i, RexLiteral.stringValue((RexNode)operands.get(1)));
                    return i;
                }
                case DESCENDING: 
                case NULLS_FIRST: 
                case NULLS_LAST: {
                    return this.registerExpression((RexNode)((RexCall)node).operands.get(0));
                }
            }
            int i2 = this.extraNodes.indexOf(node);
            if (i2 >= 0) {
                return i2;
            }
            this.extraNodes.add(node);
            this.names.add(null);
            return this.extraNodes.size() - 1;
        }

        List<Integer> registerExpressions(Iterable<? extends RexNode> nodes) {
            ArrayList<Integer> builder = new ArrayList<Integer>();
            for (RexNode rexNode : nodes) {
                builder.add(this.registerExpression(rexNode));
            }
            return builder;
        }

        List<RelFieldCollation> registerFieldCollations(Iterable<? extends RexNode> orderKeys) {
            ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
            for (RexNode rexNode : orderKeys) {
                RelFieldCollation collation = RelBuilder.collation(rexNode, RelFieldCollation.Direction.ASCENDING, null, this.extraNodes);
                if (RelCollations.ordinals(fieldCollations).contains(collation.getFieldIndex())) continue;
                fieldCollations.add(collation);
            }
            return ImmutableList.copyOf(fieldCollations);
        }

        int addedFieldCount() {
            return this.extraNodes.size() - this.originalExtraNodes.size();
        }
    }

    private class OverCallImpl
    implements OverCall {
        private final ImmutableList<RexNode> operands;
        private final boolean ignoreNulls;
        private final @Nullable String alias;
        private final boolean nullWhenCountZero;
        private final boolean allowPartial;
        private final boolean rows;
        private final RexWindowBound lowerBound;
        private final RexWindowBound upperBound;
        private final ImmutableList<RexNode> partitionKeys;
        private final ImmutableList<RexFieldCollation> sortKeys;
        private final SqlAggFunction op;
        private final boolean distinct;

        private OverCallImpl(SqlAggFunction op, boolean distinct, ImmutableList<RexNode> operands, @Nullable boolean ignoreNulls, String alias, ImmutableList<RexNode> partitionKeys, ImmutableList<RexFieldCollation> sortKeys, boolean rows, RexWindowBound lowerBound, RexWindowBound upperBound, boolean nullWhenCountZero, boolean allowPartial) {
            this.op = op;
            this.distinct = distinct;
            this.operands = operands;
            this.ignoreNulls = ignoreNulls;
            this.alias = alias;
            this.partitionKeys = partitionKeys;
            this.sortKeys = sortKeys;
            this.nullWhenCountZero = nullWhenCountZero;
            this.allowPartial = allowPartial;
            this.rows = rows;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        OverCallImpl(SqlAggFunction op, boolean distinct, ImmutableList<RexNode> operands, @Nullable boolean ignoreNulls, String alias) {
            this(op, distinct, operands, ignoreNulls, alias, (ImmutableList<RexNode>)ImmutableList.of(), (ImmutableList<RexFieldCollation>)ImmutableList.of(), true, RexWindowBounds.UNBOUNDED_PRECEDING, RexWindowBounds.UNBOUNDED_FOLLOWING, false, true);
        }

        @Override
        public OverCall partitionBy(Iterable<? extends RexNode> expressions) {
            return this.partitionBy_((ImmutableList<RexNode>)ImmutableList.copyOf(expressions));
        }

        @Override
        public OverCall partitionBy(RexNode ... expressions) {
            return this.partitionBy_((ImmutableList<RexNode>)ImmutableList.copyOf((Object[])expressions));
        }

        private OverCall partitionBy_(ImmutableList<RexNode> partitionKeys) {
            return new OverCallImpl(this.op, this.distinct, this.operands, this.ignoreNulls, this.alias, partitionKeys, this.sortKeys, this.rows, this.lowerBound, this.upperBound, this.nullWhenCountZero, this.allowPartial);
        }

        private OverCall orderBy_(ImmutableList<RexFieldCollation> sortKeys) {
            return new OverCallImpl(this.op, this.distinct, this.operands, this.ignoreNulls, this.alias, this.partitionKeys, sortKeys, this.rows, this.lowerBound, this.upperBound, this.nullWhenCountZero, this.allowPartial);
        }

        @Override
        public OverCall orderBy(Iterable<? extends RexNode> sortKeys) {
            ImmutableList.Builder fieldCollations = ImmutableList.builder();
            sortKeys.forEach(sortKey -> fieldCollations.add((Object)RelBuilder.rexCollation(sortKey, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.UNSPECIFIED)));
            return this.orderBy_((ImmutableList<RexFieldCollation>)fieldCollations.build());
        }

        @Override
        public OverCall orderBy(RexNode ... sortKeys) {
            return this.orderBy(Arrays.asList(sortKeys));
        }

        @Override
        public OverCall rowsBetween(RexWindowBound lowerBound, RexWindowBound upperBound) {
            return new OverCallImpl(this.op, this.distinct, this.operands, this.ignoreNulls, this.alias, this.partitionKeys, this.sortKeys, true, lowerBound, upperBound, this.nullWhenCountZero, this.allowPartial);
        }

        @Override
        public OverCall rangeBetween(RexWindowBound lowerBound, RexWindowBound upperBound) {
            return new OverCallImpl(this.op, this.distinct, this.operands, this.ignoreNulls, this.alias, this.partitionKeys, this.sortKeys, false, lowerBound, upperBound, this.nullWhenCountZero, this.allowPartial);
        }

        @Override
        public OverCall allowPartial(boolean allowPartial) {
            return new OverCallImpl(this.op, this.distinct, this.operands, this.ignoreNulls, this.alias, this.partitionKeys, this.sortKeys, this.rows, this.lowerBound, this.upperBound, this.nullWhenCountZero, allowPartial);
        }

        @Override
        public OverCall nullWhenCountZero(boolean nullWhenCountZero) {
            return new OverCallImpl(this.op, this.distinct, this.operands, this.ignoreNulls, this.alias, this.partitionKeys, this.sortKeys, this.rows, this.lowerBound, this.upperBound, nullWhenCountZero, this.allowPartial);
        }

        @Override
        public RexNode as(String alias) {
            return new OverCallImpl(this.op, this.distinct, this.operands, this.ignoreNulls, alias, this.partitionKeys, this.sortKeys, this.rows, this.lowerBound, this.upperBound, this.nullWhenCountZero, this.allowPartial).toRex();
        }

        @Override
        public RexNode toRex() {
            RexCallBinding bind = new RexCallBinding(RelBuilder.this.getTypeFactory(), this.op, (List)this.operands, (List)ImmutableList.of()){

                @Override
                public int getGroupCount() {
                    return SqlWindow.isAlwaysNonEmpty(OverCallImpl.this.lowerBound, OverCallImpl.this.upperBound) ? 1 : 0;
                }
            };
            RelDataType type = this.op.inferReturnType(bind);
            RexNode over = RelBuilder.this.getRexBuilder().makeOver(type, this.op, (List<RexNode>)this.operands, (List<RexNode>)this.partitionKeys, this.sortKeys, this.lowerBound, this.upperBound, this.rows, this.allowPartial, this.nullWhenCountZero, this.distinct, this.ignoreNulls);
            return RelBuilder.this.aliasMaybe(over, this.alias);
        }
    }

    public static interface OverCall {
        default public <R> R let(Function<OverCall, R> consumer) {
            return consumer.apply(this);
        }

        public OverCall partitionBy(RexNode ... var1);

        public OverCall partitionBy(Iterable<? extends RexNode> var1);

        public OverCall orderBy(RexNode ... var1);

        public OverCall orderBy(Iterable<? extends RexNode> var1);

        default public OverCall rowsUnbounded() {
            return this.rowsBetween(RexWindowBounds.UNBOUNDED_PRECEDING, RexWindowBounds.UNBOUNDED_FOLLOWING);
        }

        default public OverCall rowsFrom(RexWindowBound lower) {
            return this.rowsBetween(lower, RexWindowBounds.UNBOUNDED_FOLLOWING);
        }

        default public OverCall rowsTo(RexWindowBound upper) {
            return this.rowsBetween(RexWindowBounds.UNBOUNDED_PRECEDING, upper);
        }

        public OverCall rowsBetween(RexWindowBound var1, RexWindowBound var2);

        default public OverCall rangeUnbounded() {
            return this.rangeBetween(RexWindowBounds.UNBOUNDED_PRECEDING, RexWindowBounds.UNBOUNDED_FOLLOWING);
        }

        default public OverCall rangeFrom(RexWindowBound lower) {
            return this.rangeBetween(lower, RexWindowBounds.CURRENT_ROW);
        }

        default public OverCall rangeTo(RexWindowBound upper) {
            return this.rangeBetween(RexWindowBounds.UNBOUNDED_PRECEDING, upper);
        }

        public OverCall rangeBetween(RexWindowBound var1, RexWindowBound var2);

        public OverCall allowPartial(boolean var1);

        public OverCall nullWhenCountZero(boolean var1);

        public RexNode as(String var1);

        public RexNode toRex();
    }

    private class AggCallImpl2
    implements AggCallPlus {
        private final AggregateCall aggregateCall;
        private final ImmutableList<RexNode> operands;

        AggCallImpl2(AggregateCall aggregateCall, ImmutableList<RexNode> operands) {
            this.aggregateCall = Objects.requireNonNull(aggregateCall, "aggregateCall");
            this.operands = Objects.requireNonNull(operands, "operands");
        }

        @Override
        public OverCall over() {
            return new OverCallImpl(this.aggregateCall.getAggregation(), this.aggregateCall.isDistinct(), this.operands, this.aggregateCall.ignoreNulls(), this.aggregateCall.name);
        }

        public String toString() {
            return this.aggregateCall.toString();
        }

        @Override
        public SqlAggFunction op() {
            return this.aggregateCall.getAggregation();
        }

        @Override
        public @Nullable String alias() {
            return this.aggregateCall.name;
        }

        @Override
        public AggregateCall aggregateCall() {
            return this.aggregateCall;
        }

        @Override
        public AggregateCall aggregateCall(Registrar registrar, ImmutableBitSet groupSet, RelNode r) {
            return this.aggregateCall;
        }

        @Override
        public void register(Registrar registrar) {
        }

        @Override
        public AggCall preOperands(Iterable<? extends RexNode> preOperands) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggCall sort(Iterable<RexNode> orderKeys) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggCall sort(RexNode ... orderKeys) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggCall unique(@Nullable Iterable<RexNode> distinctKeys) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggCall approximate(boolean approximate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggCall filter(@Nullable RexNode condition) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggCall as(@Nullable String alias) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggCall distinct(boolean distinct) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggCall ignoreNulls(boolean ignoreNulls) {
            throw new UnsupportedOperationException();
        }
    }

    private class AggCallImpl
    implements AggCallPlus {
        private final SqlAggFunction aggFunction;
        private final boolean distinct;
        private final boolean approximate;
        private final boolean ignoreNulls;
        private final @Nullable RexNode filter;
        private final @Nullable String alias;
        private final ImmutableList<RexNode> preOperands;
        private final ImmutableList<RexNode> operands;
        private final @Nullable ImmutableList<RexNode> distinctKeys;
        private final ImmutableList<RexNode> orderKeys;

        AggCallImpl(SqlAggFunction aggFunction, boolean distinct, boolean approximate, @Nullable boolean ignoreNulls, @Nullable RexNode filter, String alias, ImmutableList<RexNode> preOperands, @Nullable ImmutableList<RexNode> operands, ImmutableList<RexNode> distinctKeys, ImmutableList<RexNode> orderKeys) {
            this.aggFunction = Objects.requireNonNull(aggFunction, "aggFunction");
            this.distinct = distinct && aggFunction.getDistinctOptionality() != Optionality.IGNORED;
            this.approximate = approximate;
            this.ignoreNulls = ignoreNulls;
            this.alias = alias;
            this.preOperands = Objects.requireNonNull(preOperands, "preOperands");
            this.operands = Objects.requireNonNull(operands, "operands");
            this.distinctKeys = distinctKeys;
            this.orderKeys = Objects.requireNonNull(orderKeys, "orderKeys");
            if (filter != null) {
                if (filter.getType().getSqlTypeName() != SqlTypeName.BOOLEAN) {
                    throw Static.RESOURCE.filterMustBeBoolean().ex();
                }
                if (filter.getType().isNullable()) {
                    filter = RelBuilder.this.call((SqlOperator)SqlStdOperatorTable.IS_TRUE, filter);
                }
            }
            this.filter = filter;
        }

        public String toString() {
            int i;
            StringBuilder b = new StringBuilder();
            b.append(this.aggFunction.getName()).append('(');
            if (this.distinct) {
                b.append("DISTINCT ");
            }
            if (this.preOperands.size() > 0) {
                b.append(this.preOperands.get(0));
                for (i = 1; i < this.preOperands.size(); ++i) {
                    b.append(", ");
                    b.append(this.preOperands.get(i));
                }
                b.append(this.operands.size() > 0 ? "; " : ";");
            }
            if (this.operands.size() > 0) {
                b.append(this.operands.get(0));
                for (i = 1; i < this.operands.size(); ++i) {
                    b.append(", ");
                    b.append(this.operands.get(i));
                }
            }
            b.append(')');
            if (this.filter != null) {
                b.append(" FILTER (WHERE ").append(this.filter).append(')');
            }
            if (this.distinctKeys != null) {
                b.append(" WITHIN DISTINCT (").append(this.distinctKeys).append(')');
            }
            return b.toString();
        }

        @Override
        public SqlAggFunction op() {
            return this.aggFunction;
        }

        @Override
        public @Nullable String alias() {
            return this.alias;
        }

        @Override
        public AggregateCall aggregateCall() {
            RelCollation collation = RelCollations.EMPTY;
            RelDataType type = RelBuilder.this.getTypeFactory().createSqlType(SqlTypeName.BOOLEAN);
            return AggregateCall.create(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.preOperands, (List<Integer>)ImmutableList.of(), -1, null, collation, type, this.alias);
        }

        @Override
        public AggregateCall aggregateCall(Registrar registrar, ImmutableBitSet groupSet, RelNode r) {
            int filterArg;
            List args = registrar.registerExpressions((Iterable<? extends RexNode>)this.operands);
            int n = filterArg = this.filter == null ? -1 : registrar.registerExpression(this.filter);
            if (this.distinct && !this.aggFunction.isQuantifierAllowed()) {
                throw new IllegalArgumentException("DISTINCT not allowed");
            }
            if (this.filter != null && !this.aggFunction.allowsFilter()) {
                throw new IllegalArgumentException("FILTER not allowed");
            }
            @Nullable ImmutableBitSet distinctKeys = this.distinctKeys == null ? null : ImmutableBitSet.of(registrar.registerExpressions((Iterable<? extends RexNode>)this.distinctKeys));
            RelCollation collation = RelCollations.of(this.orderKeys.stream().map(orderKey -> RelBuilder.collation(orderKey, RelFieldCollation.Direction.ASCENDING, null, Collections.emptyList())).collect(Collectors.toList()));
            if (this.aggFunction instanceof SqlCountAggFunction && !this.distinct) {
                args = (List)args.stream().filter(r::fieldIsNullable).collect(Util.toImmutableList());
            }
            return AggregateCall.create(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.preOperands, args, filterArg, distinctKeys, collation, groupSet.cardinality(), r, null, this.alias);
        }

        @Override
        public void register(Registrar registrar) {
            registrar.registerExpressions((Iterable<? extends RexNode>)this.operands);
            if (this.filter != null) {
                registrar.registerExpression(this.filter);
            }
            if (this.distinctKeys != null) {
                registrar.registerExpressions((Iterable<? extends RexNode>)this.distinctKeys);
            }
            registrar.registerExpressions((Iterable<? extends RexNode>)this.orderKeys);
        }

        @Override
        public AggCall preOperands(Iterable<? extends RexNode> preOperands) {
            ImmutableList preOperandList = ImmutableList.copyOf(preOperands);
            return preOperandList.equals(this.preOperands) ? this : new AggCallImpl(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.filter, this.alias, (ImmutableList<RexNode>)preOperandList, this.operands, this.distinctKeys, this.orderKeys);
        }

        @Override
        public OverCall over() {
            return new OverCallImpl(this.aggFunction, this.distinct, this.operands, this.ignoreNulls, this.alias);
        }

        @Override
        public AggCall sort(Iterable<RexNode> orderKeys) {
            ImmutableList orderKeyList = ImmutableList.copyOf(orderKeys);
            return orderKeyList.equals(this.orderKeys) ? this : new AggCallImpl(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.filter, this.alias, this.preOperands, this.operands, this.distinctKeys, (ImmutableList<RexNode>)orderKeyList);
        }

        @Override
        public AggCall sort(RexNode ... orderKeys) {
            return this.sort((Iterable<RexNode>)ImmutableList.copyOf((Object[])orderKeys));
        }

        @Override
        public AggCall unique(@Nullable Iterable<RexNode> distinctKeys) {
            @Nullable ImmutableList distinctKeyList = distinctKeys == null ? null : ImmutableList.copyOf(distinctKeys);
            return Objects.equals(distinctKeyList, this.distinctKeys) ? this : new AggCallImpl(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.filter, this.alias, this.preOperands, this.operands, (ImmutableList<RexNode>)distinctKeyList, this.orderKeys);
        }

        @Override
        public AggCall approximate(boolean approximate) {
            return approximate == this.approximate ? this : new AggCallImpl(this.aggFunction, this.distinct, approximate, this.ignoreNulls, this.filter, this.alias, this.preOperands, this.operands, this.distinctKeys, this.orderKeys);
        }

        @Override
        public AggCall filter(@Nullable RexNode condition) {
            return Objects.equals(condition, this.filter) ? this : new AggCallImpl(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, condition, this.alias, this.preOperands, this.operands, this.distinctKeys, this.orderKeys);
        }

        @Override
        public AggCall as(@Nullable String alias) {
            return Objects.equals(alias, this.alias) ? this : new AggCallImpl(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.filter, alias, this.preOperands, this.operands, this.distinctKeys, this.orderKeys);
        }

        @Override
        public AggCall distinct(boolean distinct) {
            return distinct == this.distinct ? this : new AggCallImpl(this.aggFunction, distinct, this.approximate, this.ignoreNulls, this.filter, this.alias, this.preOperands, this.operands, this.distinctKeys, this.orderKeys);
        }

        @Override
        public AggCall ignoreNulls(boolean ignoreNulls) {
            return ignoreNulls == this.ignoreNulls ? this : new AggCallImpl(this.aggFunction, this.distinct, this.approximate, ignoreNulls, this.filter, this.alias, this.preOperands, this.operands, this.distinctKeys, this.orderKeys);
        }
    }

    static class GroupKeyImpl
    implements GroupKey {
        final ImmutableList<RexNode> nodes;
        final @Nullable ImmutableList<ImmutableList<RexNode>> nodeLists;
        final @Nullable String alias;

        GroupKeyImpl(ImmutableList<RexNode> nodes, @Nullable ImmutableList<ImmutableList<RexNode>> nodeLists, @Nullable String alias) {
            this.nodes = Objects.requireNonNull(nodes, "nodes");
            this.nodeLists = nodeLists;
            this.alias = alias;
        }

        public String toString() {
            return this.alias == null ? this.nodes.toString() : this.nodes + " as " + this.alias;
        }

        @Override
        public int groupKeyCount() {
            return this.nodes.size();
        }

        @Override
        public GroupKey alias(@Nullable String alias) {
            return Objects.equals(this.alias, alias) ? this : new GroupKeyImpl(this.nodes, this.nodeLists, alias);
        }

        boolean isSimple() {
            return this.nodeLists == null || this.nodeLists.size() == 1;
        }
    }

    public static interface GroupKey {
        public GroupKey alias(@Nullable String var1);

        public int groupKeyCount();
    }

    private static interface AggCallPlus
    extends AggCall {
        public SqlAggFunction op();

        public @Nullable String alias();

        public AggregateCall aggregateCall();

        public AggregateCall aggregateCall(Registrar var1, ImmutableBitSet var2, RelNode var3);

        public void register(Registrar var1);
    }

    public static interface AggCall {
        public AggCall filter(@Nullable RexNode var1);

        public AggCall sort(Iterable<RexNode> var1);

        default public AggCall sort(RexNode ... orderKeys) {
            return this.sort((Iterable<RexNode>)ImmutableList.copyOf((Object[])orderKeys));
        }

        public AggCall preOperands(Iterable<? extends RexNode> var1);

        default public AggCall preOperands(RexNode ... preOperands) {
            return this.preOperands((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])preOperands));
        }

        public AggCall unique(@Nullable Iterable<RexNode> var1);

        default public AggCall unique(RexNode ... distinctKeys) {
            return this.unique((Iterable<RexNode>)ImmutableList.copyOf((Object[])distinctKeys));
        }

        public AggCall approximate(boolean var1);

        public AggCall ignoreNulls(boolean var1);

        public AggCall as(@Nullable String var1);

        public AggCall distinct(boolean var1);

        default public AggCall distinct() {
            return this.distinct(true);
        }

        public OverCall over();
    }

    private static final class RelOptTableFinder
    extends RelHomogeneousShuttle {
        private @MonotonicNonNull RelOptTable relOptTable = null;
        private final String tableName;

        private RelOptTableFinder(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public RelNode visit(TableScan scan) {
            RelOptTable scanTable = scan.getTable();
            List<String> qualifiedName = scanTable.getQualifiedName();
            if (qualifiedName.get(qualifiedName.size() - 1).equals(this.tableName)) {
                this.relOptTable = scanTable;
            }
            return super.visit(scan);
        }
    }
}

