/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.util.TestUtil;

public class AlcoholicMergePolicy
extends LogMergePolicy {
    private final Random random;
    private final Calendar calendar;

    public AlcoholicMergePolicy(TimeZone tz, Random random) {
        this.calendar = new GregorianCalendar(tz, Locale.ROOT);
        this.calendar.setTimeInMillis(TestUtil.nextLong(random, 0L, Long.MAX_VALUE));
        this.random = random;
        this.maxMergeSize = TestUtil.nextInt(random, 0x100000, Integer.MAX_VALUE);
    }

    protected long size(SegmentCommitInfo info, MergePolicy.MergeContext mergeContext) throws IOException {
        int hourOfDay = this.calendar.get(11);
        if (hourOfDay < 6 || hourOfDay > 20 || this.random.nextInt(23) == 5) {
            Drink[] values = Drink.values();
            return values[this.random.nextInt((int)values.length)].drunkFactor * info.sizeInBytes();
        }
        return info.sizeInBytes();
    }

    private static enum Drink {
        Beer(15L),
        Wine(17L),
        Champagne(21L),
        WhiteRussian(22L),
        SingleMalt(30L);

        long drunkFactor;

        private Drink(long drunkFactor) {
            this.drunkFactor = drunkFactor;
        }
    }
}

