/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.PriorityQueue;
import org.apache.solr.common.SolrException;
import org.apache.solr.handler.component.ShardDoc;

public class ShardFieldSortedHitQueue
extends PriorityQueue<ShardDoc> {
    protected Comparator<ShardDoc>[] comparators;
    protected SortField[] fields;
    protected List<String> fieldNames = new ArrayList<String>();

    public ShardFieldSortedHitQueue(SortField[] fields, int size, IndexSearcher searcher) {
        super(size);
        int n = fields.length;
        this.comparators = new Comparator[n];
        this.fields = new SortField[n];
        for (int i = 0; i < n; ++i) {
            SortField.Type type = fields[i].getType();
            if (type != SortField.Type.SCORE && type != SortField.Type.DOC) {
                this.fieldNames.add(fields[i].getField());
            }
            String fieldname = fields[i].getField();
            this.comparators[i] = this.getCachedComparator(fields[i], searcher);
            this.fields[i] = fields[i].getType() == SortField.Type.STRING ? new SortField(fieldname, SortField.Type.STRING, fields[i].getReverse()) : new SortField(fieldname, fields[i].getType(), fields[i].getReverse());
        }
    }

    protected boolean lessThan(ShardDoc docA, ShardDoc docB) {
        if (docA.shard == docB.shard) {
            return docA.orderInShard >= docB.orderInShard;
        }
        int n = this.comparators.length;
        int c = 0;
        for (int i = 0; i < n && c == 0; ++i) {
            c = this.fields[i].getReverse() ? this.comparators[i].compare(docB, docA) : this.comparators[i].compare(docA, docB);
        }
        if (c == 0) {
            c = -docA.shard.compareTo(docB.shard);
        }
        return c < 0;
    }

    Comparator<ShardDoc> getCachedComparator(SortField sortField, IndexSearcher searcher) {
        SortField.Type type = sortField.getType();
        if (type == SortField.Type.SCORE) {
            return (o1, o2) -> {
                float f1 = o1.score;
                float f2 = o2.score;
                if (f1 < f2) {
                    return -1;
                }
                if (f1 > f2) {
                    return 1;
                }
                return 0;
            };
        }
        if (type == SortField.Type.REWRITEABLE) {
            try {
                sortField = sortField.rewrite(searcher);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception rewriting sort field " + sortField, (Throwable)e);
            }
        }
        return this.comparatorFieldComparator(sortField);
    }

    Comparator<ShardDoc> comparatorFieldComparator(SortField sortField) {
        final FieldComparator fieldComparator = sortField.getComparator(0, 0);
        return new ShardComparator(sortField){

            @Override
            public int compare(ShardDoc o1, ShardDoc o2) {
                return -fieldComparator.compareValues(this.sortVal(o1), this.sortVal(o2));
            }
        };
    }

    abstract class ShardComparator
    implements Comparator<ShardDoc> {
        final SortField sortField;
        final String fieldName;
        final int fieldNum;

        public ShardComparator(SortField sortField) {
            this.sortField = sortField;
            this.fieldName = sortField.getField();
            int fieldNum = 0;
            for (int i = 0; i < ShardFieldSortedHitQueue.this.fieldNames.size(); ++i) {
                if (!ShardFieldSortedHitQueue.this.fieldNames.get(i).equals(this.fieldName)) continue;
                fieldNum = i;
                break;
            }
            this.fieldNum = fieldNum;
        }

        Object sortVal(ShardDoc shardDoc) {
            assert (shardDoc.sortFieldValues.getName(this.fieldNum).equals(this.fieldName));
            List lst = (List)shardDoc.sortFieldValues.getVal(this.fieldNum);
            return lst.get(shardDoc.orderInShard);
        }
    }
}

