/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.rule;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.request.SolrQueryRequest;

public class ImplicitSnitch
implements CoreAdminHandler.Invocable {
    static long getUsableSpaceInGB(Path path) throws IOException {
        long space = Files.getFileStore(path).getUsableSpace();
        long spaceInGB = space / 1024L / 1024L / 1024L;
        return spaceInGB;
    }

    @Override
    public Map<String, Object> invoke(SolrQueryRequest req) {
        String[] sysProps;
        HashMap<String, Object> result = new HashMap<String, Object>();
        CoreContainer cc = (CoreContainer)req.getContext().get(CoreContainer.class.getName());
        if (req.getParams().getInt("cores", -1) == 1) {
            result.put("cores", cc.getLoadedCoreNames().size());
        }
        if (req.getParams().getInt("freedisk", -1) == 1) {
            try {
                long spaceInGB = ImplicitSnitch.getUsableSpaceInGB(cc.getCoreRootDirectory());
                result.put("freedisk", spaceInGB);
            }
            catch (IOException spaceInGB) {
                // empty catch block
            }
        }
        if ((sysProps = req.getParams().getParams("sysprop.")) != null && sysProps.length > 0) {
            for (String prop : sysProps) {
                result.put("sysprop." + prop, System.getProperty(prop));
            }
        }
        return result;
    }
}

