/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hadoop;

import org.apache.solr.hadoop.SolrReducer;
import org.apache.solr.hadoop.TreeMergeMapper;
import org.apache.solr.hadoop.Utils;

public enum SolrCounters {
    DOCUMENTS_WRITTEN(SolrCounters.getClassName(SolrReducer.class) + ": Number of documents processed"),
    BATCHES_WRITTEN(SolrCounters.getClassName(SolrReducer.class) + ": Number of document batches processed"),
    BATCH_WRITE_TIME(SolrCounters.getClassName(SolrReducer.class) + ": Time spent by reducers writing batches [ms]"),
    PHYSICAL_REDUCER_MERGE_TIME(SolrCounters.getClassName(SolrReducer.class) + ": Time spent by reducers on physical merges [ms]"),
    LOGICAL_TREE_MERGE_TIME(SolrCounters.getClassName(TreeMergeMapper.class) + ": Time spent on logical tree merges [ms]"),
    PHYSICAL_TREE_MERGE_TIME(SolrCounters.getClassName(TreeMergeMapper.class) + ": Time spent on physical tree merges [ms]");

    private final String label;

    private SolrCounters(String label) {
        this.label = label;
    }

    public String toString() {
        return this.label;
    }

    private static String getClassName(Class clazz) {
        return Utils.getShortClassName(clazz);
    }
}

