/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldCacheTermsFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MultiTermQueryWrapperFilter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SolrConstantScoreQuery;
import org.apache.solr.search.SyntaxError;

public class TermsQParserPlugin
extends QParserPlugin {
    public static final String NAME = "terms";
    public static final String SEPARATOR = "separator";
    private static final String METHOD = "method";

    @Override
    public void init(NamedList args) {
    }

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new QParser(qstr, localParams, params, req){

            @Override
            public Query parse() throws SyntaxError {
                String[] splitVals;
                String fname = this.localParams.get("f");
                FieldType ft = this.req.getSchema().getFieldTypeNoEx(fname);
                String separator = this.localParams.get(TermsQParserPlugin.SEPARATOR, ",");
                String qstr = this.localParams.get("v");
                Method method = Method.valueOf(this.localParams.get(TermsQParserPlugin.METHOD, Method.termsFilter.name()));
                boolean sepIsSpace = separator.equals(" ");
                if (sepIsSpace) {
                    qstr = qstr.trim();
                }
                if (qstr.length() == 0) {
                    return new BooleanQuery();
                }
                String[] stringArray = splitVals = sepIsSpace ? qstr.split("\\s+") : qstr.split(Pattern.quote(separator), -1);
                assert (splitVals.length > 0);
                BytesRef[] bytesRefs = new BytesRef[splitVals.length];
                BytesRef term = new BytesRef();
                for (int i = 0; i < splitVals.length; ++i) {
                    String stringVal = splitVals[i];
                    if (ft != null) {
                        ft.readableToIndexed(stringVal, term);
                    } else {
                        term.copyChars((CharSequence)stringVal);
                    }
                    bytesRefs[i] = BytesRef.deepCopyOf((BytesRef)term);
                }
                return new SolrConstantScoreQuery(method.makeFilter(fname, bytesRefs));
            }
        };
    }

    private static enum Method {
        termsFilter{

            @Override
            Filter makeFilter(String fname, BytesRef[] bytesRefs) {
                return new TermsFilter(fname, bytesRefs);
            }
        }
        ,
        booleanQuery{

            @Override
            Filter makeFilter(String fname, BytesRef[] byteRefs) {
                BooleanQuery bq = new BooleanQuery(true);
                for (BytesRef byteRef : byteRefs) {
                    bq.add((Query)new TermQuery(new Term(fname, byteRef)), BooleanClause.Occur.SHOULD);
                }
                return new QueryWrapperFilter((Query)bq);
            }
        }
        ,
        automaton{

            @Override
            Filter makeFilter(String fname, BytesRef[] byteRefs) {
                Automaton union = Automata.makeStringUnion(Arrays.asList(byteRefs));
                return new MultiTermQueryWrapperFilter<AutomatonQuery>(new AutomatonQuery(new Term(fname), union)){};
            }
        }
        ,
        docValuesTermsFilter{

            @Override
            Filter makeFilter(String fname, BytesRef[] byteRefs) {
                return new FieldCacheTermsFilter(fname, byteRefs);
            }
        };


        abstract Filter makeFilter(String var1, BytesRef[] var2);
    }
}

