/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionThrottle {
    private static Logger log = LoggerFactory.getLogger(ActionThrottle.class);
    private volatile long lastActionStartedAt;
    private volatile long minMsBetweenActions;
    private final String name;

    public ActionThrottle(String name, long minMsBetweenActions) {
        this.name = name;
        this.minMsBetweenActions = minMsBetweenActions;
    }

    public void markAttemptingAction() {
        this.lastActionStartedAt = System.nanoTime();
    }

    public void minimumWaitBetweenActions() {
        if (this.lastActionStartedAt == 0L) {
            return;
        }
        long diff = System.nanoTime() - this.lastActionStartedAt;
        int diffMs = (int)TimeUnit.MILLISECONDS.convert(diff, TimeUnit.NANOSECONDS);
        long minNsBetweenActions = TimeUnit.NANOSECONDS.convert(this.minMsBetweenActions, TimeUnit.MILLISECONDS);
        log.info("The last {} attempt started {}ms ago.", (Object)this.name, (Object)diffMs);
        int sleep = 0;
        if (diffMs > 0 && diff < minNsBetweenActions) {
            sleep = (int)TimeUnit.MILLISECONDS.convert(minNsBetweenActions - diff, TimeUnit.NANOSECONDS);
        } else if (diffMs == 0) {
            sleep = (int)this.minMsBetweenActions;
        }
        if (sleep > 0) {
            log.info("Throttling {} attempts - waiting for {}ms", (Object)this.name, (Object)sleep);
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

