/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.morphlines.solr;

import com.codahale.metrics.Timer;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.morphlines.solr.DocumentLoader;
import org.apache.solr.morphlines.solr.SolrLocator;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.MorphlineRuntimeException;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.base.Configs;
import org.kitesdk.morphline.base.Notifications;

public final class LoadSolrBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("loadSolr");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new LoadSolr(this, config, parent, child, context);
    }

    private static final class LoadSolr
    extends AbstractCommand {
        private final DocumentLoader loader;
        private final Map<String, Float> boosts = new HashMap<String, Float>();
        private final Timer elapsedTime;

        public LoadSolr(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            Config solrLocatorConfig = this.getConfigs().getConfig(config, "solrLocator");
            SolrLocator locator = new SolrLocator(solrLocatorConfig, context);
            this.LOG.debug("solrLocator: {}", (Object)locator);
            this.loader = locator.getLoader();
            Config boostsConfig = this.getConfigs().getConfig(config, "boosts", ConfigFactory.empty());
            for (Map.Entry entry : new Configs().getEntrySet(boostsConfig)) {
                String fieldName = (String)entry.getKey();
                float boost = Float.parseFloat(entry.getValue().toString().trim());
                this.boosts.put(fieldName, Float.valueOf(boost));
            }
            this.validateArguments();
            this.elapsedTime = this.getTimer(new String[]{"elapsedTime"});
        }

        protected void doNotify(Record notification) {
            for (Object event : Notifications.getLifecycleEvents((Record)notification)) {
                if (event == Notifications.LifecycleEvent.BEGIN_TRANSACTION) {
                    try {
                        this.loader.beginTransaction();
                        continue;
                    }
                    catch (SolrServerException e) {
                        throw new MorphlineRuntimeException((Throwable)e);
                    }
                    catch (IOException e) {
                        throw new MorphlineRuntimeException((Throwable)e);
                    }
                }
                if (event == Notifications.LifecycleEvent.COMMIT_TRANSACTION) {
                    try {
                        this.loader.commitTransaction();
                        continue;
                    }
                    catch (SolrServerException e) {
                        throw new MorphlineRuntimeException((Throwable)e);
                    }
                    catch (IOException e) {
                        throw new MorphlineRuntimeException((Throwable)e);
                    }
                }
                if (event == Notifications.LifecycleEvent.ROLLBACK_TRANSACTION) {
                    try {
                        this.loader.rollbackTransaction();
                        continue;
                    }
                    catch (SolrServerException e) {
                        throw new MorphlineRuntimeException((Throwable)e);
                    }
                    catch (IOException e) {
                        throw new MorphlineRuntimeException((Throwable)e);
                    }
                }
                if (event != Notifications.LifecycleEvent.SHUTDOWN) continue;
                try {
                    this.loader.shutdown();
                }
                catch (SolrServerException e) {
                    throw new MorphlineRuntimeException((Throwable)e);
                }
                catch (IOException e) {
                    throw new MorphlineRuntimeException((Throwable)e);
                }
            }
            super.doNotify(notification);
        }

        protected boolean doProcess(Record record) {
            Timer.Context timerContext = this.elapsedTime.time();
            SolrInputDocument doc = this.convert(record);
            try {
                this.loader.load(doc);
            }
            catch (IOException e) {
                throw new MorphlineRuntimeException((Throwable)e);
            }
            catch (SolrServerException e) {
                throw new MorphlineRuntimeException((Throwable)e);
            }
            finally {
                timerContext.stop();
            }
            return super.doProcess(record);
        }

        private SolrInputDocument convert(Record record) {
            Map map = record.getFields().asMap();
            SolrInputDocument doc = new SolrInputDocument(new HashMap(2 * map.size()));
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                doc.setField(key, entry.getValue(), this.getBoost(key));
            }
            return doc;
        }

        private float getBoost(String key) {
            Float boost;
            if (this.boosts.size() > 0 && (boost = this.boosts.get(key)) != null) {
                return boost.floatValue();
            }
            return 1.0f;
        }
    }
}

