/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.search.AssertingWeight;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryUtils;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.TestUtil;

public class AssertingIndexSearcher
extends IndexSearcher {
    final Random random;

    public AssertingIndexSearcher(Random random, IndexReader r) {
        super(r);
        this.random = new Random(random.nextLong());
    }

    public AssertingIndexSearcher(Random random, IndexReaderContext context) {
        super(context);
        this.random = new Random(random.nextLong());
    }

    public AssertingIndexSearcher(Random random, IndexReader r, ExecutorService ex) {
        super(r, ex);
        this.random = new Random(random.nextLong());
    }

    public AssertingIndexSearcher(Random random, IndexReaderContext context, ExecutorService ex) {
        super(context, ex);
        this.random = new Random(random.nextLong());
    }

    public Weight createNormalizedWeight(Query query) throws IOException {
        Weight w = super.createNormalizedWeight(query);
        return new AssertingWeight(this.random, w){

            @Override
            public void normalize(float norm, float topLevelBoost) {
                throw new IllegalStateException("Weight already normalized.");
            }

            @Override
            public float getValueForNormalization() {
                throw new IllegalStateException("Weight already normalized.");
            }
        };
    }

    public Query rewrite(Query original) throws IOException {
        QueryUtils.check(original);
        Query rewritten = super.rewrite(original);
        QueryUtils.check(rewritten);
        return rewritten;
    }

    protected Query wrapFilter(Query query, Filter filter) {
        if (this.random.nextBoolean()) {
            return super.wrapFilter(query, filter);
        }
        return filter == null ? query : new FilteredQuery(query, filter, TestUtil.randomFilterStrategy(this.random));
    }

    protected void search(List<AtomicReaderContext> leaves, Weight weight, Collector collector) throws IOException {
        super.search(leaves, AssertingWeight.wrap(this.random, weight), collector);
    }

    public String toString() {
        return "AssertingIndexSearcher(" + super.toString() + ")";
    }
}

