/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.saxon;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

final class XMLStreamCopier {
    private final XMLStreamReader reader;
    private final XMLStreamWriter writer;

    public XMLStreamCopier(XMLStreamReader reader, XMLStreamWriter writer) {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer must not be null");
        }
        this.reader = reader;
        this.writer = writer;
    }

    public void copy(boolean isFragmentMode) throws XMLStreamException {
        int ev = isFragmentMode ? 1 : 7;
        this.reader.require(ev, null, null);
        int depth = 0;
        ev = this.reader.getEventType();
        while (true) {
            switch (ev) {
                case 1: {
                    this.writer.writeStartElement(this.nonNull(this.reader.getPrefix()), this.reader.getLocalName(), this.nonNull(this.reader.getNamespaceURI()));
                    this.copyAttributes();
                    this.copyNamespaces();
                    ++depth;
                    break;
                }
                case 2: {
                    this.writer.writeEndElement();
                    if (!isFragmentMode || --depth != 0) break;
                    this.writer.flush();
                    return;
                }
                case 10: {
                    this.copyAttribute(0);
                    break;
                }
                case 7: {
                    this.copyStartDocument();
                    break;
                }
                case 8: {
                    this.writer.writeEndDocument();
                    this.writer.flush();
                    return;
                }
                case 3: {
                    this.writer.writeProcessingInstruction(this.reader.getPITarget(), this.reader.getPIData());
                    break;
                }
                case 5: {
                    this.writer.writeComment(this.reader.getText());
                    break;
                }
                case 12: {
                    this.writer.writeCData(this.reader.getText());
                    break;
                }
                case 4: 
                case 6: {
                    this.copyText();
                    break;
                }
                case 9: {
                    this.copyText();
                    break;
                }
                case 11: {
                    this.copyDTD();
                    break;
                }
                case 15: {
                    break;
                }
                case 14: {
                    break;
                }
                case 13: {
                    this.writer.writeNamespace(this.reader.getPrefix(), this.reader.getNamespaceURI());
                    break;
                }
                default: {
                    throw new XMLStreamException("Unrecognized event type: " + this.reader.getEventType());
                }
            }
            ev = this.reader.next();
        }
    }

    private void copyAttributes() throws XMLStreamException {
        int count = this.reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            this.copyAttribute(i);
        }
    }

    private void copyAttribute(int i) throws XMLStreamException {
        this.writer.writeAttribute(this.reader.getAttributePrefix(i), this.reader.getAttributeNamespace(i), this.reader.getAttributeLocalName(i), this.reader.getAttributeValue(i));
    }

    private void copyNamespaces() throws XMLStreamException {
        int count = this.reader.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            String prefix = this.reader.getNamespacePrefix(i);
            String namespaceURI = this.nonNull(this.reader.getNamespaceURI(i));
            this.writer.writeNamespace(prefix, namespaceURI);
        }
    }

    private void copyText() throws XMLStreamException {
        this.writer.writeCharacters(this.reader.getText());
    }

    private void copyStartDocument() throws XMLStreamException {
        String encoding = this.reader.getEncoding();
        String version = this.reader.getVersion();
        if (version == null) {
            version = "1.0";
        }
        this.writer.writeStartDocument(encoding, version);
    }

    private void copyDTD() throws XMLStreamException {
        this.writer.writeDTD(this.reader.getText());
    }

    private String nonNull(String str) {
        return str == null ? "" : str;
    }
}

