/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.File;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.util.ExternalPaths;
import org.eclipse.jetty.util.security.CertificateUtils;

public class SSLTestConfig
extends SSLConfig {
    public static File TEST_KEYSTORE = ExternalPaths.EXAMPLE_HOME == null ? null : new File(ExternalPaths.EXAMPLE_HOME, "../etc/solrtest.keystore");
    private static String TEST_KEYSTORE_PATH = TEST_KEYSTORE != null && TEST_KEYSTORE.exists() ? TEST_KEYSTORE.getAbsolutePath() : null;
    private static String TEST_KEYSTORE_PASSWORD = "secret";
    private static HttpClientConfigurer DEFAULT_CONFIGURER = new HttpClientConfigurer();

    public SSLTestConfig() {
        this(false, false);
    }

    public SSLTestConfig(boolean useSSL, boolean clientAuth) {
        super(useSSL, clientAuth, TEST_KEYSTORE_PATH, TEST_KEYSTORE_PASSWORD, TEST_KEYSTORE_PATH, TEST_KEYSTORE_PASSWORD);
    }

    public SSLTestConfig(boolean useSSL, boolean clientAuth, String keyStore, String keyStorePassword, String trustStore, String trustStorePassword) {
        super(useSSL, clientAuth, keyStore, keyStorePassword, trustStore, trustStorePassword);
    }

    public HttpClientConfigurer getHttpClientConfigurer() {
        return this.isSSLMode() ? new SSLHttpClientConfigurer() : DEFAULT_CONFIGURER;
    }

    protected SSLContext buildSSLContext() throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        return SSLContexts.custom().loadKeyMaterial(SSLTestConfig.buildKeyStore(this.getKeyStore(), this.getKeyStorePassword()), this.getKeyStorePassword().toCharArray()).loadTrustMaterial(SSLTestConfig.buildKeyStore(this.getTrustStore(), this.getTrustStorePassword()), (TrustStrategy)new TrustSelfSignedStrategy()).build();
    }

    protected static KeyStore buildKeyStore(String keyStoreLocation, String password) {
        try {
            return CertificateUtils.getKeyStore(null, (String)keyStoreLocation, (String)"JKS", null, (String)password);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to build KeyStore from file: " + keyStoreLocation, ex);
        }
    }

    public static void setSSLSystemProperties() {
        System.setProperty("javax.net.ssl.keyStore", TEST_KEYSTORE_PATH);
        System.setProperty("javax.net.ssl.keyStorePassword", TEST_KEYSTORE_PASSWORD);
        System.setProperty("javax.net.ssl.trustStore", TEST_KEYSTORE_PATH);
        System.setProperty("javax.net.ssl.trustStorePassword", TEST_KEYSTORE_PASSWORD);
    }

    public static void clearSSLSystemProperties() {
        System.clearProperty("javax.net.ssl.keyStore");
        System.clearProperty("javax.net.ssl.keyStorePassword");
        System.clearProperty("javax.net.ssl.trustStore");
        System.clearProperty("javax.net.ssl.trustStorePassword");
    }

    private class SSLHttpClientConfigurer
    extends HttpClientConfigurer {
        private SSLHttpClientConfigurer() {
        }

        protected void configure(DefaultHttpClient httpClient, SolrParams config) {
            super.configure(httpClient, config);
            SchemeRegistry registry = httpClient.getConnectionManager().getSchemeRegistry();
            registry.unregister("http");
            try {
                registry.register(new Scheme("https", 443, (SchemeSocketFactory)new SSLSocketFactory(SSLTestConfig.this.buildSSLContext())));
            }
            catch (KeyManagementException ex) {
                throw new IllegalStateException("Unable to setup https scheme for HTTPClient to test SSL.", ex);
            }
            catch (UnrecoverableKeyException ex) {
                throw new IllegalStateException("Unable to setup https scheme for HTTPClient to test SSL.", ex);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IllegalStateException("Unable to setup https scheme for HTTPClient to test SSL.", ex);
            }
            catch (KeyStoreException ex) {
                throw new IllegalStateException("Unable to setup https scheme for HTTPClient to test SSL.", ex);
            }
        }
    }
}

