/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.cloud.MiniSolrCloudCluster;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.servlet.SolrDispatchFilter;

public class TrackingShardHandlerFactory
extends HttpShardHandlerFactory {
    private Queue<ShardRequestAndParams> queue;

    public synchronized void setTrackingQueue(Queue<ShardRequestAndParams> queue) {
        this.queue = queue;
    }

    public synchronized Queue<ShardRequestAndParams> getTrackingQueue() {
        return this.queue;
    }

    public synchronized boolean isTracking() {
        return this.queue != null;
    }

    public ShardHandler getShardHandler() {
        TrackingShardHandlerFactory factory = this;
        final ShardHandler wrapped = super.getShardHandler();
        return new ShardHandler((ShardHandlerFactory)factory){
            final /* synthetic */ ShardHandlerFactory val$factory;
            {
                this.val$factory = shardHandlerFactory;
            }

            public void checkDistributed(ResponseBuilder rb) {
                wrapped.checkDistributed(rb);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void submit(ShardRequest sreq, String shard, ModifiableSolrParams params) {
                TrackingShardHandlerFactory trackingShardHandlerFactory = TrackingShardHandlerFactory.this;
                synchronized (trackingShardHandlerFactory) {
                    if (TrackingShardHandlerFactory.this.isTracking()) {
                        TrackingShardHandlerFactory.this.queue.offer(new ShardRequestAndParams(sreq, shard, params));
                    }
                }
                wrapped.submit(sreq, shard, params);
            }

            public ShardResponse takeCompletedIncludingErrors() {
                return wrapped.takeCompletedIncludingErrors();
            }

            public ShardResponse takeCompletedOrError() {
                return wrapped.takeCompletedOrError();
            }

            public void cancelAll() {
                wrapped.cancelAll();
            }

            public ShardHandlerFactory getShardHandlerFactory() {
                return this.val$factory;
            }
        };
    }

    public void close() {
        super.close();
    }

    public static void setTrackingQueue(MiniSolrCloudCluster cluster, Queue<ShardRequestAndParams> queue) {
        TrackingShardHandlerFactory.setTrackingQueue(cluster.getJettySolrRunners(), queue);
    }

    public static void setTrackingQueue(List<JettySolrRunner> runners, Queue<ShardRequestAndParams> queue) {
        for (JettySolrRunner runner : runners) {
            CoreContainer container = ((SolrDispatchFilter)runner.getDispatchFilter().getFilter()).getCores();
            ShardHandlerFactory factory = container.getShardHandlerFactory();
            assert (factory instanceof TrackingShardHandlerFactory);
            TrackingShardHandlerFactory trackingShardHandlerFactory = (TrackingShardHandlerFactory)factory;
            trackingShardHandlerFactory.setTrackingQueue(queue);
        }
    }

    public static class RequestTrackingQueue
    extends LinkedList<ShardRequestAndParams> {
        private final Map<String, List<ShardRequestAndParams>> requests = new ConcurrentHashMap<String, List<ShardRequestAndParams>>();

        @Override
        public boolean offer(ShardRequestAndParams shardRequestAndParams) {
            List<ShardRequestAndParams> list = this.requests.get(shardRequestAndParams.shard);
            if (list == null) {
                list = new ArrayList<ShardRequestAndParams>();
            }
            list.add(shardRequestAndParams);
            this.requests.put(shardRequestAndParams.shard, list);
            return super.offer(shardRequestAndParams);
        }

        @Override
        public void clear() {
            this.requests.clear();
        }

        public ShardRequestAndParams getShardRequestByPurpose(ZkStateReader zkStateReader, String collectionName, String shardId, int purpose) throws RuntimeException {
            List<ShardRequestAndParams> shardRequests = this.getShardRequests(zkStateReader, collectionName, shardId);
            ArrayList<ShardRequestAndParams> result = new ArrayList<ShardRequestAndParams>(1);
            for (ShardRequestAndParams request : shardRequests) {
                if ((request.sreq.purpose & purpose) == 0) continue;
                result.add(request);
            }
            if (result.size() > 1) {
                throw new RuntimeException("Multiple requests to the same shard with the same purpose were found. Requests: " + result);
            }
            return result.isEmpty() ? null : (ShardRequestAndParams)result.get(0);
        }

        public List<ShardRequestAndParams> getShardRequests(ZkStateReader zkStateReader, String collectionName, String shardId) {
            DocCollection collection = zkStateReader.getClusterState().getCollection(collectionName);
            assert (collection != null);
            Slice slice = collection.getSlice(shardId);
            assert (slice != null);
            for (Map.Entry<String, List<ShardRequestAndParams>> entry : this.requests.entrySet()) {
                List list = StrUtils.splitSmart((String)entry.getKey(), (char)'|');
                for (Map.Entry replica : slice.getReplicasMap().entrySet()) {
                    String coreUrl = new ZkCoreNodeProps((ZkNodeProps)replica.getValue()).getCoreUrl();
                    if (!list.contains(coreUrl)) continue;
                    return new ArrayList<ShardRequestAndParams>((Collection)entry.getValue());
                }
            }
            return Collections.emptyList();
        }

        public List<ShardRequestAndParams> getCoreAdminRequests() {
            ArrayList<ShardRequestAndParams> results = new ArrayList<ShardRequestAndParams>();
            Map<String, List<ShardRequestAndParams>> map = this.getAllRequests();
            for (Map.Entry<String, List<ShardRequestAndParams>> entry : map.entrySet()) {
                for (ShardRequestAndParams shardRequestAndParams : entry.getValue()) {
                    if (shardRequestAndParams.sreq.purpose != 1) continue;
                    results.add(shardRequestAndParams);
                }
            }
            return results;
        }

        public Map<String, List<ShardRequestAndParams>> getAllRequests() {
            return this.requests;
        }
    }

    public static class ShardRequestAndParams {
        public String shard;
        public ShardRequest sreq;
        public ModifiableSolrParams params;

        public ShardRequestAndParams(ShardRequest sreq, String shard, ModifiableSolrParams params) {
            this.sreq = sreq;
            this.params = params;
            this.shard = shard;
        }

        public String toString() {
            return "ShardRequestAndParams{shard='" + this.shard + '\'' + ", sreq=" + this.sreq + ", params=" + this.params + '}';
        }
    }
}

