/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.carrot2.util.ExceptionUtils;
import org.carrot2.util.attribute.AttributeBinder;
import org.carrot2.util.attribute.AttributeBindingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeBinderInjector {
    public static void injectByType(Class<? extends Annotation> injectableMarker, Map<Class<?>, Object> values, Object ... objects) {
        try {
            AttributeBinder.IAttributeBinderAction[] actions = new AttributeBinder.IAttributeBinderAction[]{new InjectByType(values)};
            for (Object o : objects) {
                if (o == null) continue;
                AttributeBinder.bind(o, actions, (Predicate<Field>)Predicates.alwaysTrue(), injectableMarker);
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsRuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InjectByType
    implements AttributeBinder.IAttributeBinderAction {
        private final Map<Class<?>, Object> values;

        InjectByType(Map<Class<?>, Object> values) {
            this.values = values;
        }

        @Override
        public void performAction(AttributeBinder.BindingTracker bindingTracker, int level, Object object, Field field, Object value, Predicate<Field> predicate) throws InstantiationException {
            try {
                if (!Modifier.isStatic(field.getModifiers()) && this.values.containsKey(field.getType())) {
                    field.set(object, this.values.get(field.getType()));
                }
            }
            catch (Exception e) {
                throw AttributeBindingException.createWithNoKey("Could not assign field " + object.getClass().getName() + "#" + field.getName() + " with value " + value, e);
            }
        }
    }
}

