/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.clustering.synthetic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.core.attribute.CommonAttributesDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ByFieldClusteringAlgorithmDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.clustering.synthetic.ByFieldClusteringAlgorithm";
    public final String prefix = "ByAttributeClusteringAlgorithm";
    public final String title = "Clusters documents into a flat structure based on the values of some field of the documents";
    public final String label = "By Attribute Clustering";
    public final String description = "By default the <code>Document.SOURCES</code> field is used.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    @Override
    public String getPrefix() {
        return "ByAttributeClusteringAlgorithm";
    }

    @Override
    public String getTitle() {
        return "Clusters documents into a flat structure based on the values of some field of the documents";
    }

    @Override
    public String getLabel() {
        return "By Attribute Clustering";
    }

    @Override
    public String getDescription() {
        return "By default the <code>Document.SOURCES</code> field is used.";
    }

    @Override
    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    @Override
    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(ByFieldClusteringAlgorithmDescriptor.attributes.documents);
        ownAttrs.add(ByFieldClusteringAlgorithmDescriptor.attributes.clusters);
        ownAttrs.add(ByFieldClusteringAlgorithmDescriptor.attributes.fieldName);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(ByFieldClusteringAlgorithmDescriptor.attributes.documents);
        allAttrs.add(ByFieldClusteringAlgorithmDescriptor.attributes.clusters);
        allAttrs.add(ByFieldClusteringAlgorithmDescriptor.attributes.fieldName);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder documents(List<Document> value) {
            this.map.put("documents", value);
            return this;
        }

        public List<Cluster> clusters() {
            return (List)this.map.get("clusters");
        }

        public AttributeBuilder fieldName(String value) {
            this.map.put("ByAttributeClusteringAlgorithm.fieldName", value);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo documents;
        public final AttributeInfo clusters;
        public final AttributeInfo fieldName;

        private Attributes() {
            this.documents = new AttributeInfo("documents", "org.carrot2.clustering.synthetic.ByFieldClusteringAlgorithm", "documents", "Documents to cluster.", null, "Documents to cluster", null, null, null, CommonAttributesDescriptor.attributes.documents);
            this.clusters = new AttributeInfo("clusters", "org.carrot2.clustering.synthetic.ByFieldClusteringAlgorithm", "clusters", "Clusters created by the algorithm.", null, "Clusters created by the algorithm", null, null, null, CommonAttributesDescriptor.attributes.clusters);
            this.fieldName = new AttributeInfo("ByAttributeClusteringAlgorithm.fieldName", "org.carrot2.clustering.synthetic.ByFieldClusteringAlgorithm", "fieldName", "Name of the field to cluster by. Each non-null scalar field value with distinct\nhash code will give rise to a single cluster, named using the\nvalue returned by {@link org.carrot2.clustering.synthetic.ByFieldClusteringAlgorithm#buildClusterLabel(Object)}. If the field value is a collection,\nthe document will be assigned to all clusters corresponding to the values in the\ncollection. Note that arrays will not be 'unfolded' in this way.", "Field name", "Name of the field to cluster by", "Each non-null scalar field value with distinct hash code will give rise to a single cluster, named using the value returned by <code>org.carrot2.clustering.synthetic.ByFieldClusteringAlgorithm.buildClusterLabel(Object)</code>. If the field value is a collection, the document will be assigned to all clusters corresponding to the values in the collection. Note that arrays will not be 'unfolded' in this way.", "Field", AttributeLevel.BASIC, null);
        }
    }

    public static class Keys {
        public static final String DOCUMENTS = "documents";
        public static final String CLUSTERS = "clusters";
        public static final String FIELD_NAME = "ByAttributeClusteringAlgorithm.fieldName";

        protected Keys() {
        }
    }
}

