/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.stats;

public class LogLikelihood {
    private LogLikelihood() {
    }

    public static double entropy(int ... elements) {
        double sum = 0.0;
        for (int element : elements) {
            sum += (double)element;
        }
        double result = 0.0;
        for (int x : elements) {
            if (x < 0) {
                throw new IllegalArgumentException("Should not have negative count for entropy computation: (" + x + ')');
            }
            int zeroFlag = x == 0 ? 1 : 0;
            result += (double)x * Math.log((double)(x + zeroFlag) / sum);
        }
        return -result;
    }

    public static double logLikelihoodRatio(int k11, int k12, int k21, int k22) {
        double rowEntropy = LogLikelihood.entropy(k11, k12) + LogLikelihood.entropy(k21, k22);
        double columnEntropy = LogLikelihood.entropy(k11, k21) + LogLikelihood.entropy(k12, k22);
        double matrixEntropy = LogLikelihood.entropy(k11, k12, k21, k22);
        return 2.0 * (matrixEntropy - rowEntropy - columnEntropy);
    }

    public static double rootLogLikelihoodRatio(int k11, int k12, int k21, int k22) {
        double llr = LogLikelihood.logLikelihoodRatio(k11, k12, k21, k22);
        return Math.signum((double)k11 / (double)(k11 + k12) - (double)k21 / (double)(k21 + k22)) * Math.sqrt(llr);
    }
}

