/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.util.Vector;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.SolrIndexWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UpdateHandler
implements SolrInfoMBean {
    protected static final Logger log = LoggerFactory.getLogger(UpdateHandler.class);
    protected final SolrCore core;
    protected final IndexSchema schema;
    protected final SchemaField idField;
    protected final FieldType idFieldType;
    protected final Term idTerm;
    protected Vector<SolrEventListener> commitCallbacks = new Vector();
    protected Vector<SolrEventListener> optimizeCallbacks = new Vector();

    private void parseEventListeners() {
        Class<SolrEventListener> clazz = SolrEventListener.class;
        String label = "Event Listener";
        for (PluginInfo info : this.core.getSolrConfig().getPluginInfos(SolrEventListener.class.getName())) {
            SolrEventListener obj;
            String event = info.attributes.get("event");
            if ("postCommit".equals(event)) {
                obj = this.core.createInitInstance(info, clazz, "Event Listener", null);
                this.commitCallbacks.add(obj);
                log.info("added SolrEventListener for postCommit: " + obj);
                continue;
            }
            if (!"postOptimize".equals(event)) continue;
            obj = this.core.createInitInstance(info, clazz, "Event Listener", null);
            this.optimizeCallbacks.add(obj);
            log.info("added SolrEventListener for postOptimize: " + obj);
        }
    }

    protected void callPostCommitCallbacks() {
        for (SolrEventListener listener : this.commitCallbacks) {
            listener.postCommit();
        }
    }

    protected void callPostOptimizeCallbacks() {
        for (SolrEventListener listener : this.optimizeCallbacks) {
            listener.postCommit();
        }
    }

    public UpdateHandler(SolrCore core) {
        this.core = core;
        this.schema = core.getSchema();
        this.idField = this.schema.getUniqueKeyField();
        this.idFieldType = this.idField != null ? this.idField.getType() : null;
        this.idTerm = this.idField != null ? new Term(this.idField.getName(), "") : null;
        this.parseEventListeners();
    }

    protected SolrIndexWriter createMainIndexWriter(String name, boolean removeAllExisting) throws IOException {
        return new SolrIndexWriter(name, this.core.getNewIndexDir(), this.core.getDirectoryFactory(), removeAllExisting, this.schema, this.core.getSolrConfig().indexConfig, this.core.getDeletionPolicy());
    }

    protected final Term idTerm(String readableId) {
        return new Term(this.idField.getName(), this.idFieldType.toInternal(readableId));
    }

    protected final String getIndexedId(Document doc) {
        if (this.idField == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Operation requires schema to have a unique key field");
        }
        Fieldable[] id = doc.getFieldables(this.idField.getName());
        if (id == null || id.length < 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Document is missing mandatory uniqueKey field: " + this.idField.getName());
        }
        if (id.length > 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Document contains multiple values for uniqueKey field: " + this.idField.getName());
        }
        return this.idFieldType.storedToIndexed(id[0]);
    }

    protected final String getIndexedIdOptional(Document doc) {
        if (this.idField == null) {
            return null;
        }
        Fieldable f = doc.getFieldable(this.idField.getName());
        if (f == null) {
            return null;
        }
        return this.idFieldType.storedToIndexed(f);
    }

    public abstract int addDoc(AddUpdateCommand var1) throws IOException;

    public abstract void delete(DeleteUpdateCommand var1) throws IOException;

    public abstract void deleteByQuery(DeleteUpdateCommand var1) throws IOException;

    public abstract int mergeIndexes(MergeIndexesCommand var1) throws IOException;

    public abstract void commit(CommitUpdateCommand var1) throws IOException;

    public abstract void rollback(RollbackUpdateCommand var1) throws IOException;

    public abstract void close() throws IOException;

    public void registerCommitCallback(SolrEventListener listener) {
        this.commitCallbacks.add(listener);
    }

    public void registerOptimizeCallback(SolrEventListener listener) {
        this.optimizeCallbacks.add(listener);
    }

    static class DeleteHitCollector
    extends Collector {
        public int deleted = 0;
        public final SolrIndexSearcher searcher;
        private int docBase;

        public DeleteHitCollector(SolrIndexSearcher searcher) {
            this.searcher = searcher;
        }

        public void collect(int doc) {
            try {
                this.searcher.getReader().deleteDocument(doc + this.docBase);
                ++this.deleted;
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error deleting doc# " + doc, (Throwable)e, false);
            }
        }

        public boolean acceptsDocsOutOfOrder() {
            return false;
        }

        public void setNextReader(IndexReader arg0, int docBase) throws IOException {
            this.docBase = docBase;
        }

        public void setScorer(Scorer scorer) throws IOException {
        }
    }
}

