/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.CharReader;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilter;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLStripTransformer
extends Transformer {
    public static final String STRIP_HTML = "stripHTML";
    public static final String TRUE = "true";

    @Override
    public Object transformRow(Map<String, Object> row, Context context) {
        List<Map<String, String>> fields = context.getAllEntityFields();
        for (Map<String, String> field : fields) {
            Object tmpVal;
            String col = field.get("column");
            String splitHTML = context.replaceTokens(field.get(STRIP_HTML));
            if (!TRUE.equals(splitHTML) || (tmpVal = row.get(col)) == null) continue;
            if (tmpVal instanceof List) {
                List inputs = (List)tmpVal;
                ArrayList<Object> results = new ArrayList<Object>();
                for (String input : inputs) {
                    Object o;
                    if (input == null || (o = this.stripHTML(input, col)) == null) continue;
                    results.add(o);
                }
                row.put(col, results);
                continue;
            }
            String value = tmpVal.toString();
            Object o = this.stripHTML(value, col);
            if (o == null) continue;
            row.put(col, o);
        }
        return row;
    }

    private Object stripHTML(String value, String column) {
        StringBuilder out = new StringBuilder();
        StringReader strReader = new StringReader(value);
        try {
            int count;
            HTMLStripCharFilter html = new HTMLStripCharFilter(CharReader.get((Reader)(strReader.markSupported() ? strReader : new BufferedReader(strReader))));
            char[] cbuf = new char[10240];
            while ((count = html.read(cbuf)) != -1) {
                if (count <= 0) continue;
                out.append(cbuf, 0, count);
            }
            html.close();
        }
        catch (IOException e) {
            throw new DataImportHandlerException(500, "Failed stripping HTML for column: " + column, e);
        }
        return out.toString();
    }
}

