/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.IntCollection;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.predicates.IntPredicate;
import java.util.Arrays;

abstract class AbstractIntCollection
implements IntCollection {
    AbstractIntCollection() {
    }

    public int removeAll(IntLookupContainer c) {
        final IntLookupContainer c2 = c;
        return this.removeAll(new IntPredicate(){

            public boolean apply(int k) {
                return c2.contains(k);
            }
        });
    }

    public int retainAll(IntLookupContainer c) {
        final IntLookupContainer c2 = c;
        return this.removeAll(new IntPredicate(){

            public boolean apply(int k) {
                return !c2.contains(k);
            }
        });
    }

    public int retainAll(final IntPredicate predicate) {
        return this.removeAll(new IntPredicate(){

            public boolean apply(int value) {
                return !predicate.apply(value);
            }
        });
    }

    public int[] toArray() {
        int size = this.size();
        int[] array = new int[size];
        int i = 0;
        for (IntCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

