/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.cli.functions;

import java.util.HashMap;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.lucene.LuceneService;
import org.apache.geode.cache.lucene.LuceneServiceProvider;
import org.apache.geode.cache.lucene.internal.cli.LuceneIndexInfo;
import org.apache.geode.cache.lucene.internal.cli.functions.LuceneListIndexFunction;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class LuceneCreateIndexFunction
extends FunctionAdapter
implements InternalEntity {
    protected Cache getCache() {
        return CacheFactory.getAnyInstance();
    }

    public String getId() {
        return LuceneListIndexFunction.class.getName();
    }

    public void execute(FunctionContext context) {
        String memberId = null;
        try {
            LuceneIndexInfo indexInfo = (LuceneIndexInfo)context.getArguments();
            Cache cache = this.getCache();
            memberId = cache.getDistributedSystem().getDistributedMember().getId();
            LuceneService service = LuceneServiceProvider.get((GemFireCache)cache);
            String[] fields = indexInfo.getSearchableFieldNames();
            String[] analyzerName = indexInfo.getFieldAnalyzers();
            if (analyzerName == null || analyzerName.length == 0) {
                service.createIndex(indexInfo.getIndexName(), indexInfo.getRegionPath(), fields);
            } else {
                if (analyzerName.length != fields.length) {
                    throw new Exception("Mismatch in lengths of fields and analyzers");
                }
                HashMap<String, Analyzer> fieldAnalyzer = new HashMap<String, Analyzer>();
                for (int i = 0; i < fields.length; ++i) {
                    Analyzer analyzer = this.toAnalyzer(analyzerName[i]);
                    fieldAnalyzer.put(fields[i], analyzer);
                }
                service.createIndex(indexInfo.getIndexName(), indexInfo.getRegionPath(), fieldAnalyzer);
            }
            XmlEntity xmlEntity = null;
            context.getResultSender().lastResult((Object)new CliFunctionResult(memberId, xmlEntity));
        }
        catch (Exception e) {
            String exceptionMessage = CliStrings.format((String)"Exception : {0} , Message : {1}", (Object[])new Object[]{e.getClass().getName(), e.getMessage()});
            context.getResultSender().lastResult((Object)new CliFunctionResult(memberId, (Throwable)e, e.getMessage()));
        }
    }

    private Analyzer toAnalyzer(String className) {
        if (className == null) {
            className = StandardAnalyzer.class.getCanonicalName();
        } else if (StringUtils.trim((String)className).equals("") | StringUtils.trim((String)className).equals("null")) {
            className = StandardAnalyzer.class.getCanonicalName();
        }
        Class clazz = CliUtil.forName((String)className, (String)"analyzer");
        return (Analyzer)CliUtil.newInstance((Class)clazz, (String)"analyzer");
    }
}

