/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.http;

import org.apache.geode.internal.lang.StringUtils;

public final class HttpHeader
extends Enum<HttpHeader> {
    public static final /* enum */ HttpHeader ACCEPT = new HttpHeader("Accept");
    public static final /* enum */ HttpHeader ACCEPT_CHARSET = new HttpHeader("Accept-Charset");
    public static final /* enum */ HttpHeader ACCEPT_ENCODING = new HttpHeader("Accept-Encoding");
    public static final /* enum */ HttpHeader ACCEPT_LANGUAGE = new HttpHeader("Accept-Language");
    public static final /* enum */ HttpHeader ACCEPT_RANGES = new HttpHeader("Accept-Ranges");
    public static final /* enum */ HttpHeader AGE = new HttpHeader("Age");
    public static final /* enum */ HttpHeader ALLOW = new HttpHeader("Allow");
    public static final /* enum */ HttpHeader AUTHORIZATION = new HttpHeader("Authorization");
    public static final /* enum */ HttpHeader CACHE_CONTROL = new HttpHeader("Cache-Control");
    public static final /* enum */ HttpHeader CONNECTION = new HttpHeader("Connection");
    public static final /* enum */ HttpHeader CONTENT_ENCODING = new HttpHeader("Content-Encoding");
    public static final /* enum */ HttpHeader CONTENT_LANGUAGE = new HttpHeader("Content-Language");
    public static final /* enum */ HttpHeader CONTENT_LENGTH = new HttpHeader("Content-Length");
    public static final /* enum */ HttpHeader CONTENT_LOCATION = new HttpHeader("Content-Location");
    public static final /* enum */ HttpHeader CONTENT_MD5 = new HttpHeader("Content-MD5");
    public static final /* enum */ HttpHeader CONTENT_RANGE = new HttpHeader("Content-Range");
    public static final /* enum */ HttpHeader CONTENT_TYPE = new HttpHeader("Content-Type");
    public static final /* enum */ HttpHeader DATE = new HttpHeader("Date");
    public static final /* enum */ HttpHeader ETAG = new HttpHeader("ETag");
    public static final /* enum */ HttpHeader EXPECT = new HttpHeader("Expect");
    public static final /* enum */ HttpHeader EXPIRES = new HttpHeader("Expires");
    public static final /* enum */ HttpHeader FROM = new HttpHeader("From");
    public static final /* enum */ HttpHeader HOST = new HttpHeader("Host");
    public static final /* enum */ HttpHeader IF_MATCH = new HttpHeader("If-Match");
    public static final /* enum */ HttpHeader IF_MODIFIED_SINCE = new HttpHeader("If-Modified-Since");
    public static final /* enum */ HttpHeader IF_NONE_MATCH = new HttpHeader("If-None-Match");
    public static final /* enum */ HttpHeader IF_RANGE = new HttpHeader("If-Range");
    public static final /* enum */ HttpHeader IF_UNMODIFIED_SINCE = new HttpHeader("If-Unmodified-Since");
    public static final /* enum */ HttpHeader LAST_MODIFIED = new HttpHeader("Last-Modified");
    public static final /* enum */ HttpHeader LOCATION = new HttpHeader("Location");
    public static final /* enum */ HttpHeader MAX_FORWARDS = new HttpHeader("Max-Forwards");
    public static final /* enum */ HttpHeader PRAGMA = new HttpHeader("Pragma");
    public static final /* enum */ HttpHeader PROXY_AUTHENTICATE = new HttpHeader("Proxy-Authenticate");
    public static final /* enum */ HttpHeader PROXY_AUTHORIZATION = new HttpHeader("Proxy-Authorization");
    public static final /* enum */ HttpHeader RANGE = new HttpHeader("Range");
    public static final /* enum */ HttpHeader REFERER = new HttpHeader("Referer");
    public static final /* enum */ HttpHeader RETRY_AFTER = new HttpHeader("Retry-After");
    public static final /* enum */ HttpHeader SERVER = new HttpHeader("Server");
    public static final /* enum */ HttpHeader TE = new HttpHeader("TE");
    public static final /* enum */ HttpHeader TRAILER = new HttpHeader("Trailer");
    public static final /* enum */ HttpHeader TRANSFER_ENCODING = new HttpHeader("Transfer-Encoding");
    public static final /* enum */ HttpHeader UPGRADE = new HttpHeader("Upgrade");
    public static final /* enum */ HttpHeader USER_AGENT = new HttpHeader("User-Agent");
    public static final /* enum */ HttpHeader VARY = new HttpHeader("Vary");
    public static final /* enum */ HttpHeader VIA = new HttpHeader("Via");
    public static final /* enum */ HttpHeader WARNING = new HttpHeader("Warning");
    public static final /* enum */ HttpHeader WWW_AUTHENTICATE = new HttpHeader("WWW-Authenticate");
    private final String name;
    private static final /* synthetic */ HttpHeader[] $VALUES;

    public static HttpHeader[] values() {
        return (HttpHeader[])$VALUES.clone();
    }

    public static HttpHeader valueOf(String name) {
        return Enum.valueOf(HttpHeader.class, name);
    }

    private HttpHeader(String name) {
        assert (!StringUtils.isBlank((String)name)) : "The name of the HTTP request header must be specified!";
        this.name = name;
    }

    public static HttpHeader valueOfName(String name) {
        for (HttpHeader header : HttpHeader.values()) {
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return header;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    static {
        $VALUES = new HttpHeader[]{ACCEPT, ACCEPT_CHARSET, ACCEPT_ENCODING, ACCEPT_LANGUAGE, ACCEPT_RANGES, AGE, ALLOW, AUTHORIZATION, CACHE_CONTROL, CONNECTION, CONTENT_ENCODING, CONTENT_LANGUAGE, CONTENT_LENGTH, CONTENT_LOCATION, CONTENT_MD5, CONTENT_RANGE, CONTENT_TYPE, DATE, ETAG, EXPECT, EXPIRES, FROM, HOST, IF_MATCH, IF_MODIFIED_SINCE, IF_NONE_MATCH, IF_RANGE, IF_UNMODIFIED_SINCE, LAST_MODIFIED, LOCATION, MAX_FORWARDS, PRAGMA, PROXY_AUTHENTICATE, PROXY_AUTHORIZATION, RANGE, REFERER, RETRY_AFTER, SERVER, TE, TRAILER, TRANSFER_ENCODING, UPGRADE, USER_AGENT, VARY, VIA, WARNING, WWW_AUTHENTICATE};
    }
}

