/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.controllers;

import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.internal.cli.util.CommandStringBuilder;
import org.apache.geode.management.internal.web.controllers.AbstractCommandsController;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="pdxController")
@RequestMapping(value={"/v1"})
public class PdxCommandsController
extends AbstractCommandsController {
    @RequestMapping(method={RequestMethod.POST}, value={"/pdx"})
    @ResponseBody
    public String configurePdx(@RequestParam(value="read-serialized", required=false) Boolean readSerialized, @RequestParam(value="ignore-unread-fields", required=false) Boolean ignoreUnreadFields, @RequestParam(value="disk-store", required=false) String diskStore, @RequestParam(value="auto-serializable-classes", required=false) String[] autoSerializerClasses, @RequestParam(value="portable-auto-serializable-classes", required=false) String[] portableAutoSerializerClasses) {
        CommandStringBuilder command = new CommandStringBuilder("configure pdx");
        if (Boolean.TRUE.equals(readSerialized)) {
            command.addOption("read-serialized", String.valueOf(readSerialized));
        }
        if (Boolean.TRUE.equals(ignoreUnreadFields)) {
            command.addOption("ignore-unread-fields", String.valueOf(ignoreUnreadFields));
        }
        if (PdxCommandsController.hasValue(diskStore)) {
            command.addOption("disk-store", diskStore);
        }
        if (PdxCommandsController.hasValue(autoSerializerClasses)) {
            command.addOption("auto-serializable-classes", StringUtils.concat((Object[])autoSerializerClasses, (String)","));
        }
        if (PdxCommandsController.hasValue(portableAutoSerializerClasses)) {
            command.addOption("portable-auto-serializable-classes", StringUtils.concat((Object[])portableAutoSerializerClasses, (String)","));
        }
        return this.processCommand(command.toString());
    }

    public String pdxDeleteField(@RequestParam(value="class") String className, @RequestParam(value="field") String fieldName, @RequestParam(value="disk-store") String diskStore, @RequestParam(value="disk-dirs", required=false) String[] diskDirs) {
        CommandStringBuilder command = new CommandStringBuilder("pdx delete-field");
        command.addOption("class", className);
        command.addOption("field", fieldName);
        command.addOption("disk-store", diskStore);
        if (PdxCommandsController.hasValue(diskDirs)) {
            command.addOption("disk-dirs", StringUtils.concat((Object[])diskDirs, (String)","));
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/pdx/type"})
    @ResponseBody
    public String pdxRename(@RequestParam(value="old") String oldClassName, @RequestParam(value="new") String newClassName, @RequestParam(value="disk-store") String diskStore, @RequestParam(value="disk-dirs", required=false) String[] diskDirs) {
        CommandStringBuilder command = new CommandStringBuilder("pdx rename");
        command.addOption("old", oldClassName);
        command.addOption("new", newClassName);
        command.addOption("disk-store", diskStore);
        if (PdxCommandsController.hasValue(diskDirs)) {
            command.addOption("disk-dirs", StringUtils.concat((Object[])diskDirs, (String)","));
        }
        return this.processCommand(command.toString());
    }
}

