/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.controllers;

import org.apache.geode.management.internal.cli.util.CommandStringBuilder;
import org.apache.geode.management.internal.web.controllers.AbstractCommandsController;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="memberController")
@RequestMapping(value={"/v1"})
public class MemberCommandsController
extends AbstractCommandsController {
    @RequestMapping(method={RequestMethod.GET}, value={"/members"})
    @ResponseBody
    public String listMembers(@RequestParam(value="group", required=false) String groupName) {
        CommandStringBuilder command = new CommandStringBuilder("list members");
        if (MemberCommandsController.hasValue(groupName)) {
            command.addOption("group", groupName);
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/members/{name}"})
    @ResponseBody
    public String describeMember(@PathVariable(value="name") String memberNameId) {
        CommandStringBuilder command = new CommandStringBuilder("describe member");
        command.addOption("name", MemberCommandsController.decode(memberNameId));
        return this.processCommand(command.toString());
    }
}

