/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.controllers;

import java.util.concurrent.Callable;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.internal.cli.util.CommandStringBuilder;
import org.apache.geode.management.internal.web.controllers.AbstractCommandsController;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="functionController")
@RequestMapping(value={"/v1"})
public class FunctionCommandsController
extends AbstractCommandsController {
    @RequestMapping(method={RequestMethod.GET}, value={"/functions"})
    @ResponseBody
    public String listFunctions(@RequestParam(value="group", required=false) String[] groups, @RequestParam(value="member", required=false) String[] members, @RequestParam(value="matches", required=false) String matches) {
        CommandStringBuilder command = new CommandStringBuilder("list functions");
        if (FunctionCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.concat((Object[])groups, (String)","));
        }
        if (FunctionCommandsController.hasValue(members)) {
            command.addOption("member", StringUtils.concat((Object[])members, (String)","));
        }
        if (FunctionCommandsController.hasValue(matches)) {
            command.addOption("matches", matches);
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/functions/{id}"})
    public Callable<ResponseEntity<String>> executeFunction(@PathVariable(value="id") String functionId, @RequestParam(value="groups", required=false) String groupName, @RequestParam(value="member", required=false) String memberNameId, @RequestParam(value="region", required=false) String regionNamePath, @RequestParam(value="arguments", required=false) String[] arguments, @RequestParam(value="filter", required=false) String filter, @RequestParam(value="result-collector", required=false) String resultCollector) {
        CommandStringBuilder command = new CommandStringBuilder("execute function");
        command.addOption("id", FunctionCommandsController.decode(functionId));
        if (FunctionCommandsController.hasValue(groupName)) {
            command.addOption("groups", groupName);
        }
        if (FunctionCommandsController.hasValue(memberNameId)) {
            command.addOption("member", memberNameId);
        }
        if (FunctionCommandsController.hasValue(regionNamePath)) {
            command.addOption("region", regionNamePath);
        }
        if (FunctionCommandsController.hasValue(arguments)) {
            command.addOption("arguments", StringUtils.concat((Object[])arguments, (String)","));
        }
        if (FunctionCommandsController.hasValue(filter)) {
            command.addOption("filter", filter);
        }
        if (FunctionCommandsController.hasValue(resultCollector)) {
            command.addOption("result-collector", resultCollector);
        }
        return this.getProcessCommandCallable(command.toString());
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/functions/{id}"})
    @ResponseBody
    public String destroyFunction(@PathVariable(value="id") String functionId, @RequestParam(value="groups", required=false) String groupName, @RequestParam(value="member", required=false) String memberNameId) {
        CommandStringBuilder command = new CommandStringBuilder("destroy function");
        command.addOption("id", FunctionCommandsController.decode(functionId));
        if (FunctionCommandsController.hasValue(groupName)) {
            command.addOption("groups", groupName);
        }
        if (FunctionCommandsController.hasValue(memberNameId)) {
            command.addOption("member", memberNameId);
        }
        return this.processCommand(command.toString());
    }
}

