/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.controllers;

import java.util.concurrent.Callable;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.internal.cli.util.CommandStringBuilder;
import org.apache.geode.management.internal.web.controllers.AbstractCommandsController;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;

@Controller(value="dataController")
@RequestMapping(value={"/v1"})
public class DataCommandsController
extends AbstractCommandsController {
    @RequestMapping(method={RequestMethod.GET}, value={"/regions/{region}/data"})
    @ResponseBody
    public String get(@PathVariable(value="region") String regionNamePath, @RequestParam(value="key") String key, @RequestParam(value="key-class", required=false) String keyClassName, @RequestParam(value="value-class", required=false) String valueClassName, @RequestParam(value="load-on-cache-miss", defaultValue="true") Boolean loadOnCacheMiss) {
        CommandStringBuilder command = new CommandStringBuilder("get");
        command.addOption("region", DataCommandsController.decode(regionNamePath));
        command.addOption("key", key);
        command.addOption("load-on-cache-miss", String.valueOf(Boolean.TRUE.equals(loadOnCacheMiss)));
        if (DataCommandsController.hasValue(keyClassName)) {
            command.addOption("key-class", keyClassName);
        }
        if (DataCommandsController.hasValue(valueClassName)) {
            command.addOption("value-class", valueClassName);
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/regions/{region}/data"})
    @ResponseBody
    public String put(@PathVariable(value="region") String regionNamePath, @RequestParam(value="key") String key, @RequestParam(value="key-class", required=false) String keyClassName, @RequestParam(value="value") String value, @RequestParam(value="value-class", required=false) String valueClassName, @RequestParam(value="skip-if-exists", defaultValue="false") Boolean putIfAbsent) {
        CommandStringBuilder command = new CommandStringBuilder("put");
        command.addOption("region", DataCommandsController.decode(regionNamePath));
        command.addOption("key", key);
        command.addOption("value", DataCommandsController.decode(value));
        if (DataCommandsController.hasValue(keyClassName)) {
            command.addOption("key-class", keyClassName);
        }
        if (DataCommandsController.hasValue(valueClassName)) {
            command.addOption("value-class", valueClassName);
        }
        command.addOption("skip-if-exists", String.valueOf(putIfAbsent));
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/regions/{region}/data"})
    @ResponseBody
    public String remove(@PathVariable(value="region") String regionNamePath, @RequestParam(value="all", defaultValue="false") Boolean allKeys, @RequestParam(value="key", required=false) String key, @RequestParam(value="key-class", required=false) String keyClassName) {
        CommandStringBuilder command = new CommandStringBuilder("remove");
        command.addOption("region", DataCommandsController.decode(regionNamePath));
        command.addOption("all", String.valueOf(allKeys));
        if (DataCommandsController.hasValue(key)) {
            command.addOption("key", key);
        }
        if (DataCommandsController.hasValue(keyClassName)) {
            command.addOption("key-class", keyClassName);
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/members/{member}/regions/{region}/data"})
    public Callable<ResponseEntity<String>> exportData(@PathVariable(value="member") String memberNameId, @PathVariable(value="region") String regionNamePath, @RequestParam(value="file") String file) {
        CommandStringBuilder command = new CommandStringBuilder("export data");
        command.addOption("member", DataCommandsController.decode(memberNameId));
        command.addOption("region", DataCommandsController.decode(regionNamePath));
        command.addOption("file", DataCommandsController.decode(file));
        return this.getProcessCommandCallable(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/members/{member}/regions/{region}/data"})
    public Callable<ResponseEntity<String>> importData(@PathVariable(value="member") String memberNameId, @PathVariable(value="region") String regionNamePath, @RequestParam(value="file") String file) {
        CommandStringBuilder command = new CommandStringBuilder("import data");
        command.addOption("member", DataCommandsController.decode(memberNameId));
        command.addOption("region", DataCommandsController.decode(regionNamePath));
        command.addOption("file", DataCommandsController.decode(file));
        return this.getProcessCommandCallable(command.toString());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/regions/{region}/data/location"})
    @ResponseBody
    public String locateEntry(@PathVariable(value="region") String regionNamePath, @RequestParam(value="key") String key, @RequestParam(value="key-class", required=false) String keyClassName, @RequestParam(value="value-class", required=false) String valueClassName, @RequestParam(value="recursive", defaultValue="false") Boolean recursive) {
        CommandStringBuilder command = new CommandStringBuilder("locate entry");
        command.addOption("region", DataCommandsController.decode(regionNamePath));
        command.addOption("key", key);
        if (DataCommandsController.hasValue(keyClassName)) {
            command.addOption("key-class", keyClassName);
        }
        if (DataCommandsController.hasValue(valueClassName)) {
            command.addOption("value-class", valueClassName);
        }
        command.addOption("recursive", String.valueOf(recursive));
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/regions/data/query"})
    public Callable<ResponseEntity<String>> query(WebRequest request, @RequestParam(value="query") String oql, @RequestParam(value="step-name", defaultValue="ALL") String stepName, @RequestParam(value="interactive", defaultValue="true") Boolean interactive) {
        CommandStringBuilder command = new CommandStringBuilder("query");
        command.addOption("query", DataCommandsController.decode(oql));
        command.addOption("step-name", stepName);
        command.addOption("interactive", String.valueOf(Boolean.TRUE.equals(interactive)));
        return this.getProcessCommandCallable(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/regions/data"}, params={"op=rebalance"})
    public Callable<ResponseEntity<String>> rebalance(@RequestParam(value="include-region", required=false) String[] includedRegions, @RequestParam(value="exclude-region", required=false) String[] excludedRegions, @RequestParam(value="simulate", defaultValue="false") Boolean simulate, @RequestParam(value="time-out", defaultValue="-1") Long timeout) {
        CommandStringBuilder command = new CommandStringBuilder("rebalance");
        if (DataCommandsController.hasValue(includedRegions)) {
            command.addOption("include-region", StringUtils.concat((Object[])includedRegions, (String)","));
        }
        if (DataCommandsController.hasValue(excludedRegions)) {
            command.addOption("exclude-region", StringUtils.concat((Object[])excludedRegions, (String)","));
        }
        command.addOption("simulate", String.valueOf(simulate));
        command.addOption("time-out", String.valueOf(timeout));
        return this.getProcessCommandCallable(command.toString());
    }
}

