/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.bkd;

import java.util.List;
import org.apache.lucene.util.bkd.PointReader;

final class HeapPointReader
implements PointReader {
    private int curRead;
    final List<byte[]> blocks;
    final int valuesPerBlock;
    final int packedBytesLength;
    final long[] ords;
    final int[] docIDs;
    final int end;
    final byte[] scratch;

    HeapPointReader(List<byte[]> blocks, int valuesPerBlock, int packedBytesLength, long[] ords, int[] docIDs, int start, int end) {
        this.blocks = blocks;
        this.valuesPerBlock = valuesPerBlock;
        this.ords = ords;
        this.docIDs = docIDs;
        this.curRead = start - 1;
        this.end = end;
        this.packedBytesLength = packedBytesLength;
        this.scratch = new byte[packedBytesLength];
    }

    void writePackedValue(int index, byte[] bytes) {
        int block = index / this.valuesPerBlock;
        int blockIndex = index % this.valuesPerBlock;
        while (this.blocks.size() <= block) {
            this.blocks.add(new byte[this.valuesPerBlock * this.packedBytesLength]);
        }
        System.arraycopy(bytes, 0, this.blocks.get(blockIndex), blockIndex * this.packedBytesLength, this.packedBytesLength);
    }

    void readPackedValue(int index, byte[] bytes) {
        int block = index / this.valuesPerBlock;
        int blockIndex = index % this.valuesPerBlock;
        System.arraycopy(this.blocks.get(block), blockIndex * this.packedBytesLength, bytes, 0, this.packedBytesLength);
    }

    @Override
    public boolean next() {
        ++this.curRead;
        return this.curRead < this.end;
    }

    @Override
    public byte[] packedValue() {
        this.readPackedValue(this.curRead, this.scratch);
        return this.scratch;
    }

    @Override
    public int docID() {
        return this.docIDs[this.curRead];
    }

    @Override
    public long ord() {
        return this.ords[this.curRead];
    }

    @Override
    public void close() {
    }
}

