/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;

public final class LSBRadixSorter {
    private static final int INSERTION_SORT_THRESHOLD = 30;
    private static final int HISTOGRAM_SIZE = 256;
    private final int[] histogram = new int[256];
    private int[] buffer = new int[0];

    private static void buildHistogram(int[] array, int off, int len, int[] histogram, int shift) {
        for (int i = 0; i < len; ++i) {
            int b;
            int n = b = array[off + i] >>> shift & 0xFF;
            histogram[n] = histogram[n] + 1;
        }
    }

    private static void sumHistogram(int[] histogram) {
        int accum = 0;
        for (int i = 0; i < 256; ++i) {
            int count = histogram[i];
            histogram[i] = accum;
            accum += count;
        }
    }

    private static void reorder(int[] array, int off, int len, int[] histogram, int shift, int[] dest, int destOff) {
        for (int i = 0; i < len; ++i) {
            int b;
            int v = array[off + i];
            int n = b = v >>> shift & 0xFF;
            int n2 = histogram[n];
            histogram[n] = n2 + 1;
            dest[destOff + n2] = v;
        }
    }

    private static boolean sort(int[] array, int off, int len, int[] histogram, int shift, int[] dest, int destOff) {
        Arrays.fill(histogram, 0);
        LSBRadixSorter.buildHistogram(array, off, len, histogram, shift);
        if (histogram[0] == len) {
            return false;
        }
        LSBRadixSorter.sumHistogram(histogram);
        LSBRadixSorter.reorder(array, off, len, histogram, shift, dest, destOff);
        return true;
    }

    private static void insertionSort(int[] array, int off, int len) {
        int end = off + len;
        for (int i = off + 1; i < end; ++i) {
            for (int j = i; j > off && array[j - 1] > array[j]; --j) {
                int tmp = array[j - 1];
                array[j - 1] = array[j];
                array[j] = tmp;
            }
        }
    }

    public void sort(int[] array, int off, int len) {
        if (len < 30) {
            LSBRadixSorter.insertionSort(array, off, len);
            return;
        }
        this.buffer = ArrayUtil.grow(this.buffer, len);
        int[] arr = array;
        int arrOff = off;
        int[] buf = this.buffer;
        int bufOff = 0;
        for (int shift = 0; shift <= 24; shift += 8) {
            if (!LSBRadixSorter.sort(arr, arrOff, len, this.histogram, shift, buf, bufOff)) continue;
            int[] tmp = arr;
            int tmpOff = arrOff;
            arr = buf;
            arrOff = bufOff;
            buf = tmp;
            bufOff = tmpOff;
        }
        if (array == buf) {
            System.arraycopy(arr, arrOff, array, off, len);
        }
    }
}

