/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security;

import org.apache.shiro.authz.permission.WildcardPermission;

public class ResourcePermission
extends WildcardPermission {
    public static String ALL_REGIONS = "*";
    public static String ALL_KEYS = "*";
    private Resource resource = Resource.NULL;
    private Operation operation = Operation.NULL;
    private String regionName = ALL_REGIONS;
    private String key = ALL_KEYS;

    public ResourcePermission() {
        this(Resource.NULL, Operation.NULL);
    }

    public ResourcePermission(String resource, String operation) {
        this(resource, operation, ALL_REGIONS);
    }

    public ResourcePermission(String resource, String operation, String regionName) {
        this(resource, operation, regionName, ALL_KEYS);
    }

    public ResourcePermission(String resource, String operation, String regionName, String key) {
        this(resource == null ? Resource.NULL : Resource.valueOf(resource), operation == null ? Operation.NULL : Operation.valueOf(operation), regionName, key);
    }

    public ResourcePermission(Resource resource, Operation operation) {
        this(resource, operation, ALL_REGIONS);
    }

    public ResourcePermission(Resource resource, Operation operation, String regionName) {
        this(resource, operation, regionName, ALL_KEYS);
    }

    public ResourcePermission(Resource resource, Operation operation, String regionName, String key) {
        if (resource != null) {
            this.resource = resource;
        }
        if (operation != null) {
            this.operation = operation;
        }
        if (regionName != null) {
            this.regionName = regionName;
        }
        if (key != null) {
            this.key = key;
        }
        this.setParts((Object)((Object)this.resource) + ":" + (Object)((Object)this.operation) + ":" + this.regionName + ":" + this.key, true);
    }

    public Resource getResource() {
        return this.resource;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        if (ALL_REGIONS.equals(this.regionName)) {
            return (Object)((Object)this.getResource()) + ":" + (Object)((Object)this.getOperation());
        }
        if (ALL_KEYS.equals(this.key)) {
            return (Object)((Object)this.resource) + ":" + (Object)((Object)this.operation) + ":" + this.regionName;
        }
        return (Object)((Object)this.resource) + ":" + (Object)((Object)this.operation) + ":" + this.regionName + ":" + this.key;
    }

    public static enum Operation {
        NULL,
        MANAGE,
        WRITE,
        READ;

    }

    public static enum Resource {
        NULL,
        CLUSTER,
        DATA;

    }
}

