/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.internal.PdxInstanceFactoryImpl;
import org.apache.geode.pdx.internal.json.PdxListHelper;
import org.apache.logging.log4j.Logger;

public class PdxInstanceHelper {
    private static final Logger logger = LogService.getLogger();
    PdxInstanceHelper m_parent;
    PdxInstanceFactoryImpl m_pdxInstanceFactory;
    PdxInstance m_pdxInstance;
    String m_PdxName;

    public PdxInstanceHelper(String className, PdxInstanceHelper parent) {
        GemFireCacheImpl gci = (GemFireCacheImpl)CacheFactory.getAnyInstance();
        if (logger.isTraceEnabled()) {
            logger.trace("ClassName {}", (Object)className);
        }
        this.m_PdxName = className;
        this.m_parent = parent;
        this.m_pdxInstanceFactory = (PdxInstanceFactoryImpl)gci.createPdxInstanceFactory("__GEMFIRE_JSON", false);
    }

    public PdxInstanceHelper getParent() {
        return this.m_parent;
    }

    public void setPdxFieldName(String name) {
        if (logger.isTraceEnabled()) {
            logger.trace("setPdxClassName : {}", (Object)name);
        }
        this.m_PdxName = name;
    }

    public void addStringField(String fieldName, String value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addStringField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeString(fieldName, value);
    }

    public void addByteField(String fieldName, byte value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addByteField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeByte(fieldName, value);
    }

    public void addShortField(String fieldName, short value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addShortField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeShort(fieldName, value);
    }

    public void addIntField(String fieldName, int value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addIntField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeInt(fieldName, value);
    }

    public void addLongField(String fieldName, long value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addLongField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeLong(fieldName, value);
    }

    public void addBigDecimalField(String fieldName, BigDecimal value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addBigDecimalField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeObject(fieldName, value);
    }

    public void addBigIntegerField(String fieldName, BigInteger value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addBigIntegerField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeObject(fieldName, value);
    }

    public void addBooleanField(String fieldName, boolean value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addBooleanField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeBoolean(fieldName, value);
    }

    public void addFloatField(String fieldName, float value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addFloatField fieldName: {}; value: {}", (Object)fieldName, (Object)Float.valueOf(value));
        }
        this.m_pdxInstanceFactory.writeFloat(fieldName, value);
    }

    public void addDoubleField(String fieldName, double value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addDoubleField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeDouble(fieldName, value);
    }

    public void addNullField(String fieldName) {
        if (logger.isTraceEnabled()) {
            logger.trace("addNullField fieldName: {}; value: NULL", (Object)fieldName);
        }
        this.m_pdxInstanceFactory.writeObject(fieldName, null);
    }

    public void addListField(String fieldName, PdxListHelper list) {
        if (logger.isTraceEnabled()) {
            logger.trace("addListField fieldName: {}", (Object)fieldName);
        }
        this.m_pdxInstanceFactory.writeObject(fieldName, list.getList());
    }

    public void endListField(String fieldName) {
        if (logger.isTraceEnabled()) {
            logger.trace("endListField fieldName: {}", (Object)fieldName);
        }
    }

    public void addObjectField(String fieldName, PdxInstance member) {
        if (logger.isTraceEnabled()) {
            logger.trace("addObjectField fieldName: {}", (Object)fieldName);
        }
        if (fieldName == null) {
            throw new IllegalStateException("addObjectField:PdxInstance should have fieldname");
        }
        this.m_pdxInstanceFactory.writeObject(fieldName, member);
    }

    public void endObjectField(String fieldName) {
        if (logger.isTraceEnabled()) {
            logger.trace("endObjectField fieldName: {}", (Object)fieldName);
        }
        this.m_pdxInstance = this.m_pdxInstanceFactory.create();
    }

    public PdxInstance getPdxInstance() {
        return this.m_pdxInstance;
    }

    public String getPdxFieldName() {
        return this.m_PdxName;
    }
}

