/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.functions;

import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.SharedConfiguration;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.configuration.domain.ConfigurationChangeResult;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;

public class AddXmlEntityFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(FunctionContext context) {
        InternalLocator locator = InternalLocator.getLocator();
        ConfigurationChangeResult configChangeResult = new ConfigurationChangeResult();
        try {
            if (locator.isSharedConfigurationRunning()) {
                Object[] args = (Object[])context.getArguments();
                XmlEntity xmlEntity = (XmlEntity)args[0];
                String[] groups = (String[])args[1];
                SharedConfiguration sharedConfig = locator.getSharedConfiguration();
                sharedConfig.addXmlEntity(xmlEntity, groups);
            } else {
                configChangeResult.setErrorMessage("Shared Configuration has not been started in locator : " + locator);
            }
        }
        catch (Exception e) {
            configChangeResult.setException(e);
            configChangeResult.setErrorMessage(CliUtil.stackTraceAsString(e));
        }
        finally {
            context.getResultSender().lastResult(configChangeResult);
        }
    }

    @Override
    public String getId() {
        return AddXmlEntityFunction.class.getName();
    }
}

