/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.callbacks;

import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.geode.distributed.internal.SharedConfiguration;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.configuration.domain.Configuration;
import org.apache.logging.log4j.Logger;

public class ConfigurationChangeListener
extends CacheListenerAdapter<String, Configuration> {
    private static final Logger logger = LogService.getLogger();
    private final SharedConfiguration sharedConfig;

    public ConfigurationChangeListener(SharedConfiguration sharedConfig) {
        this.sharedConfig = sharedConfig;
    }

    @Override
    public void afterUpdate(EntryEvent<String, Configuration> event) {
        super.afterUpdate(event);
        this.writeToFileSystem(event);
    }

    @Override
    public void afterCreate(EntryEvent<String, Configuration> event) {
        super.afterCreate(event);
        this.writeToFileSystem(event);
    }

    private void writeToFileSystem(EntryEvent<String, Configuration> event) {
        Configuration newConfig = event.getNewValue();
        try {
            this.sharedConfig.writeConfig(newConfig);
        }
        catch (Exception e) {
            logger.info("Exception occurred while writing the configuration changes to the filesystem: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

