/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.management.internal.cli.json.GfJsonArray;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.management.internal.cli.result.CliJsonSerializable;
import org.apache.geode.management.internal.cli.result.CliJsonSerializableFactory;
import org.apache.geode.management.internal.cli.result.ResultDataException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtil {
    public static Map<String, String> jsonToMap(String jsonString) {
        TreeMap<String, String> jsonMap = new TreeMap<String, String>();
        try {
            GfJsonObject jsonObject = new GfJsonObject(jsonString);
            Iterator<String> keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = keys.next();
                jsonMap.put(key, jsonObject.getString(key));
            }
        }
        catch (GfJsonException e) {
            throw new IllegalArgumentException("Could not convert jsonString : '" + jsonString + "' to map.");
        }
        return jsonMap;
    }

    public static String mapToJson(Map<String, String> properties) {
        return new GfJsonObject(properties).toString();
    }

    public static String objectToJson(Object object) {
        return new GfJsonObject(object).toString();
    }

    public static String objectToJsonNested(Object object, int length) {
        return JsonUtil.objectToJsonNestedChkCDep(object, length, false);
    }

    public static String objectToJsonNestedChkCDep(Object object, int length) {
        return JsonUtil.objectToJsonNestedChkCDep(object, length, true);
    }

    private static String objectToJsonNestedChkCDep(Object object, int length, boolean checkCyclicDep) {
        GfJsonObject jsonObject = new GfJsonObject(object, checkCyclicDep);
        Iterator<String> iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = iterator.next();
            Object value = jsonObject.get(key);
            if (value == null || JsonUtil.isPrimitiveOrWrapper(value.getClass())) continue;
            GfJsonObject jsonified = new GfJsonObject(value);
            String stringified = jsonified.toString();
            try {
                if (stringified.length() > length) {
                    jsonObject.put(key, jsonified.getType());
                    continue;
                }
                jsonObject.put(key, stringified);
            }
            catch (GfJsonException e) {
                e.printStackTrace();
            }
        }
        return jsonObject.toString();
    }

    public static <T> T jsonToObject(String jsonString, Class<T> klass) {
        T objectFromJson = null;
        try {
            GfJsonObject jsonObject = new GfJsonObject(jsonString);
            objectFromJson = klass.newInstance();
            Method[] declaredMethods = klass.getDeclaredMethods();
            HashMap<String, Method> methodsMap = new HashMap<String, Method>();
            for (Method method : declaredMethods) {
                methodsMap.put(method.getName(), method);
            }
            int noOfFields = jsonObject.size();
            Iterator<String> keys = jsonObject.keys();
            while (keys.hasNext()) {
                Class<?>[] parameterTypes;
                Method method;
                String key = keys.next();
                method = (Method)methodsMap.get("set" + JsonUtil.capitalize(key));
                if (method == null || (parameterTypes = method.getParameterTypes()).length != 1) continue;
                Class<?> parameterType = parameterTypes[0];
                Object value = jsonObject.get(key);
                value = JsonUtil.isPrimitiveOrWrapper(parameterType) ? JsonUtil.getPrimitiveOrWrapperValue(parameterType, value) : (JsonUtil.isArray(parameterType) ? JsonUtil.toArray(value, parameterType) : (JsonUtil.isList(parameterType) ? JsonUtil.toList(value, parameterType) : (JsonUtil.isMap(parameterType) ? JsonUtil.toMap(value, parameterType) : (JsonUtil.isSet(parameterType) ? JsonUtil.toSet(value, parameterType) : JsonUtil.jsonToObject(value.toString(), parameterType)))));
                method.invoke(objectFromJson, value);
                --noOfFields;
            }
            if (noOfFields != 0) {
                throw new IllegalArgumentException("Not enough setter methods for fields in given JSON String : " + jsonString + " in class : " + klass);
            }
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Couldn't convert JSON to Object of type " + klass, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Couldn't convert JSON to Object of type " + klass, e);
        }
        catch (GfJsonException e) {
            throw new IllegalArgumentException("Couldn't convert JSON to Object of type " + klass, e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Couldn't convert JSON to Object of type " + klass, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Couldn't convert JSON to Object of type " + klass, e);
        }
        return objectFromJson;
    }

    private static Object toArray(Object value, Class<?> parameterType) throws GfJsonException {
        Class<?> arrayComponentType = parameterType.getComponentType();
        if (JsonUtil.isPrimitiveOrWrapper(arrayComponentType)) {
            if (value instanceof JSONArray) {
                try {
                    JSONArray jsonArray = (JSONArray)value;
                    Object jArray = Array.newInstance(arrayComponentType, jsonArray.length());
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        Array.set(jArray, i, jsonArray.get(i));
                    }
                    return jArray;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new GfJsonException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new GfJsonException(e);
                }
                catch (JSONException e) {
                    throw new GfJsonException((Exception)((Object)e));
                }
            }
            throw new GfJsonException("Expected JSONArray for array type");
        }
        throw new GfJsonException("Array contains non-primitive element. Non-primitive elements are not supported in json array");
    }

    private static Object toSet(Object value, Class<?> parameterType) throws GfJsonException {
        try {
            JSONArray array = (JSONArray)value;
            HashSet<Object> set = new HashSet<Object>();
            for (int i = 0; i < array.length(); ++i) {
                Object element = array.get(i);
                if (!JsonUtil.isPrimitiveOrWrapper(element.getClass())) {
                    throw new GfJsonException("Only primitive types are supported in set type for input commands");
                }
                set.add(element);
            }
            return set;
        }
        catch (JSONException e) {
            throw new GfJsonException((Exception)((Object)e));
        }
    }

    private static Object toMap(Object value, Class<?> parameterType) throws GfJsonException {
        try {
            if (value instanceof JSONObject) {
                JSONObject obj = (JSONObject)value;
                Iterator iterator = obj.keys();
                HashMap<String, Object> map = new HashMap<String, Object>();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    Object elem = obj.get(key);
                    if (JsonUtil.isPrimitiveOrWrapper(elem.getClass())) {
                        map.put(key, elem);
                        continue;
                    }
                    throw new GfJsonException("Only primitive types are supported in map type for input commands");
                }
                return map;
            }
            throw new GfJsonException("Expected JSONObject for Map. Retrieved type is " + value.getClass());
        }
        catch (JSONException e) {
            throw new GfJsonException((Exception)((Object)e));
        }
    }

    private static Object toList(Object value, Class<?> parameterType) throws GfJsonException {
        try {
            JSONArray array = (JSONArray)value;
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < array.length(); ++i) {
                Object element = array.get(i);
                if (!JsonUtil.isPrimitiveOrWrapper(element.getClass())) {
                    throw new GfJsonException("Only primitive types are supported in set type for input commands");
                }
                list.add(element);
            }
            return list;
        }
        catch (JSONException e) {
            throw new GfJsonException((Exception)((Object)e));
        }
    }

    public static Object jsonToObject(String jsonString) {
        Object objectFromJson = null;
        try {
            GfJsonObject jsonObject = new GfJsonObject(jsonString);
            Iterator<String> keys = jsonObject.keys();
            Object[] arr = new Object[jsonObject.size()];
            int i = 0;
            while (keys.hasNext()) {
                String key = keys.next();
                Class<?> klass = ClassPathLoader.getLatest().forName(key);
                arr[i++] = JsonUtil.jsonToObject(jsonObject.get(key).toString(), klass);
            }
            objectFromJson = arr.length == 1 ? arr[0] : arr;
        }
        catch (GfJsonException e) {
            throw new IllegalArgumentException("Couldn't convert JSON to Object.", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Couldn't convert JSON to Object.", e);
        }
        return objectFromJson;
    }

    public static String capitalize(String str) {
        String capitalized = str;
        if (str == null || str.isEmpty()) {
            return capitalized;
        }
        capitalized = String.valueOf(str.charAt(0)).toUpperCase() + str.substring(1);
        return capitalized;
    }

    private static boolean isArray(Class<?> parameterType) {
        return parameterType.isArray();
    }

    public static boolean isList(Class<?> klass) {
        return klass.isAssignableFrom(List.class);
    }

    public static boolean isSet(Class<?> klass) {
        return klass.isAssignableFrom(Set.class);
    }

    public static boolean isMap(Class<?> klass) {
        return klass.isAssignableFrom(Map.class);
    }

    public static boolean isPrimitiveOrWrapper(Class<?> klass) {
        return klass.isAssignableFrom(Byte.class) || klass.isAssignableFrom(Byte.TYPE) || klass.isAssignableFrom(Short.class) || klass.isAssignableFrom(Short.TYPE) || klass.isAssignableFrom(Integer.class) || klass.isAssignableFrom(Integer.TYPE) || klass.isAssignableFrom(Long.class) || klass.isAssignableFrom(Long.TYPE) || klass.isAssignableFrom(Float.class) || klass.isAssignableFrom(Float.TYPE) || klass.isAssignableFrom(Double.class) || klass.isAssignableFrom(Double.TYPE) || klass.isAssignableFrom(Boolean.class) || klass.isAssignableFrom(Boolean.TYPE) || klass.isAssignableFrom(String.class) || klass.isAssignableFrom(Character.class) || klass.isAssignableFrom(Character.TYPE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getPrimitiveOrWrapperValue(Class<?> klass, Object value) throws IllegalArgumentException {
        if (klass.isAssignableFrom(Byte.class) || klass.isAssignableFrom(Byte.TYPE)) {
            return value;
        }
        if (klass.isAssignableFrom(Short.class) || klass.isAssignableFrom(Short.TYPE)) {
            return value;
        }
        if (klass.isAssignableFrom(Integer.class) || klass.isAssignableFrom(Integer.TYPE)) {
            return value;
        }
        if (klass.isAssignableFrom(Long.class) || klass.isAssignableFrom(Long.TYPE)) {
            return value;
        }
        if (klass.isAssignableFrom(Float.class) || klass.isAssignableFrom(Float.class)) {
            return value;
        }
        if (klass.isAssignableFrom(Double.class) || klass.isAssignableFrom(Double.TYPE)) {
            return value;
        }
        if (klass.isAssignableFrom(Boolean.class) || klass.isAssignableFrom(Boolean.TYPE)) {
            return value;
        }
        if (klass.isAssignableFrom(String.class)) {
            return String.valueOf(value);
        }
        if (klass.isAssignableFrom(Character.class)) {
            if (value instanceof String) {
                String str = (String)value;
                if (str.length() == 1) {
                    return new Character(str.charAt(0));
                }
                if (str.length() <= 1 && str.length() != 0) return value;
                throw new IllegalArgumentException("Expected Character value but found String with length " + str.length());
            }
            if (!(value instanceof Character)) throw new IllegalArgumentException("Expected Character value but found " + value.getClass());
            return value;
        }
        if (!klass.isAssignableFrom(Character.TYPE)) return null;
        if (value instanceof String) {
            String str = (String)value;
            if (str.length() == 1) {
                return Character.valueOf(str.charAt(0));
            }
            if (str.length() <= 1 && str.length() != 0) return value;
            throw new IllegalArgumentException("Expected Character value but found String with length " + str.length());
        }
        if (!(value instanceof Character)) throw new IllegalArgumentException("Expected Character value but found " + value.getClass());
        return Character.valueOf(((Character)value).charValue());
    }

    public static int getInt(GfJsonObject jsonObject, String byName) {
        return jsonObject.getInt(byName);
    }

    public static long getLong(GfJsonObject jsonObject, String byName) {
        return jsonObject.getLong(byName);
    }

    public static double getDouble(GfJsonObject jsonObject, String byName) {
        return jsonObject.getDouble(byName);
    }

    public static boolean getBoolean(GfJsonObject jsonObject, String byName) {
        return jsonObject.getBoolean(byName);
    }

    public static String getString(GfJsonObject jsonObject, String byName) {
        return jsonObject.getString(byName);
    }

    public static GfJsonObject getJSONObject(GfJsonObject jsonObject, String byName) {
        return jsonObject.getJSONObject(byName);
    }

    public static String[] getStringArray(GfJsonObject jsonObject, String byName) {
        String[] stringArray = null;
        try {
            GfJsonArray jsonArray = jsonObject.getJSONArray(byName);
            stringArray = GfJsonArray.toStringArray(jsonArray);
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        return stringArray;
    }

    public static byte[] getByteArray(GfJsonObject jsonObject, String byName) {
        byte[] byteArray = null;
        try {
            GfJsonArray jsonArray = jsonObject.getJSONArray(byName);
            byteArray = GfJsonArray.toByteArray(jsonArray);
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        return byteArray;
    }

    public static List<CliJsonSerializable> getList(GfJsonObject jsonObject, String byName) {
        List<CliJsonSerializable> cliJsonSerializables = Collections.emptyList();
        try {
            GfJsonArray cliJsonSerializableArray = jsonObject.getJSONArray(byName);
            int size = cliJsonSerializableArray.size();
            if (size > 0) {
                cliJsonSerializables = new ArrayList();
            }
            for (int i = 0; i < size; ++i) {
                GfJsonObject cliJsonSerializableState = cliJsonSerializableArray.getJSONObject(i);
                int jsId = cliJsonSerializableState.getInt("JSId");
                CliJsonSerializable cliJsonSerializable = CliJsonSerializableFactory.getCliJsonSerializable(jsId);
                cliJsonSerializable.fromJson(cliJsonSerializableState);
                cliJsonSerializables.add(cliJsonSerializable);
            }
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        return cliJsonSerializables;
    }

    public static Set<CliJsonSerializable> getSet(GfJsonObject jsonObject, String byName) {
        Set<CliJsonSerializable> cliJsonSerializables = Collections.emptySet();
        try {
            GfJsonArray cliJsonSerializableArray = jsonObject.getJSONArray(byName);
            int size = cliJsonSerializableArray.size();
            if (size > 0) {
                cliJsonSerializables = new HashSet();
            }
            for (int i = 0; i < size; ++i) {
                GfJsonObject cliJsonSerializableState = cliJsonSerializableArray.getJSONObject(i);
                int jsId = cliJsonSerializableState.getInt("JSId");
                CliJsonSerializable cliJsonSerializable = CliJsonSerializableFactory.getCliJsonSerializable(jsId);
                cliJsonSerializable.fromJson(cliJsonSerializableState);
                cliJsonSerializables.add(cliJsonSerializable);
            }
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        return cliJsonSerializables;
    }

    public static void main(String[] args) {
        System.out.println(JsonUtil.capitalize("key"));
        System.out.println(JsonUtil.capitalize("Key"));
        String str = "{\"org.apache.geode.management.internal.cli.JsonUtil$Employee\":{\"id\":1234,\"name\":\"Foo BAR\",\"department\":{\"id\":456,\"name\":\"support\"}}}";
        Object jsonToObject = JsonUtil.jsonToObject(str);
        System.out.println(jsonToObject);
        str = "{\"id\":1234,\"name\":\"Foo BAR\",\"department\":{\"id\":456,\"name\":\"support\"}}";
        Employee jsonToObject2 = JsonUtil.jsonToObject(str, Employee.class);
        System.out.println(jsonToObject2);
    }

    public static class Department {
        private int id;
        private String name;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return "Department [id=" + this.id + ", name=" + this.name + "]";
        }
    }

    public static class Employee {
        private int id;
        private String name;
        private Department department;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Department getDepartment() {
            return this.department;
        }

        public void setDepartment(Department department) {
            this.department = department;
        }

        public String toString() {
            return "Employee [id=" + this.id + ", name=" + this.name + ", department=" + this.department + "]";
        }
    }
}

