/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.management.internal.cli.CliUtil;

public class ClasspathScanLoadHelper {
    private static final String CLASSFILE_EXTENSION = ".class";

    public static Set<Class<?>> loadAndGet(String commandPackageName, Class<?> requiredInterfaceToLoad, boolean onlyInstantiable) throws ClassNotFoundException, IOException {
        HashSet classSet = new HashSet();
        Class<?>[] classes = ClasspathScanLoadHelper.getClasses(commandPackageName);
        for (int i = 0; i < classes.length; ++i) {
            if (!ClasspathScanLoadHelper.implementsType(classes[i], requiredInterfaceToLoad)) continue;
            if (onlyInstantiable) {
                if (!ClasspathScanLoadHelper.isInstantiable(classes[i])) continue;
                classSet.add(classes[i]);
                continue;
            }
            classSet.add(classes[i]);
        }
        return classSet;
    }

    public static boolean isInstantiable(Class<?> klass) {
        int modifiers = klass.getModifiers();
        boolean isInstantiable = !Modifier.isAbstract(modifiers) && !Modifier.isInterface(modifiers) && Modifier.isPublic(modifiers);
        return isInstantiable;
    }

    private static boolean implementsType(Class<?> typeToCheck, Class<?> requiredInterface) {
        return requiredInterface.isAssignableFrom(typeToCheck);
    }

    public static Class<?>[] getClasses(String packageName) throws ClassNotFoundException, IOException {
        String packagePath = packageName.replace('.', '/');
        ArrayList<File> dirs = new ArrayList<File>();
        Enumeration<URL> resources = ClassPathLoader.getLatest().getResources(packagePath);
        ArrayList classesList = new ArrayList();
        while (resources.hasMoreElements()) {
            URL packageUrl = resources.nextElement();
            String actualPackagePath = packageUrl.getPath();
            int jarIndex = actualPackagePath.indexOf(".jar!");
            if (jarIndex != -1) {
                String jarPath = actualPackagePath.substring(0, jarIndex + ".jar".length());
                if (jarPath.startsWith("file:")) {
                    if (File.separatorChar == '/') {
                        jarPath = jarPath.substring("file:".length());
                    } else if ((jarPath = jarPath.substring("file:/".length())).startsWith("/") && !jarPath.startsWith("//")) {
                        jarPath = "/" + jarPath;
                    }
                }
                Class<?>[] classes = ClasspathScanLoadHelper.getClasses(CliUtil.decodeWithDefaultCharSet(jarPath), packageName);
                classesList.addAll(Arrays.asList(classes));
                continue;
            }
            dirs.add(new File(packageUrl.getFile()));
        }
        for (File directory : dirs) {
            classesList.addAll(ClasspathScanLoadHelper.findClasses(directory, packageName));
        }
        return classesList.toArray(new Class[classesList.size()]);
    }

    public static List<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        ClassPathLoader cpLoader = ClassPathLoader.getLatest();
        TestClassFilter tcf = new TestClassFilter();
        File[] files = directory.listFiles(tcf);
        File file = null;
        for (int i = 0; i < files.length; ++i) {
            file = files[i];
            if (file.isDirectory()) {
                classes.addAll(ClasspathScanLoadHelper.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            String classSimpleName = file.getName().substring(0, file.getName().length() - CLASSFILE_EXTENSION.length());
            classes.add(cpLoader.forName(packageName + '.' + classSimpleName));
        }
        return classes;
    }

    public static Class<?>[] getClasses(String jarPath, String packageName) throws ClassNotFoundException, IOException {
        ClassPathLoader cpLoader = ClassPathLoader.getLatest();
        String[] classNames = ClasspathScanLoadHelper.getClassNames(jarPath, packageName);
        Class[] classes = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            String className = classNames[i];
            classes[i] = cpLoader.forName(className);
        }
        return classes;
    }

    public static String[] getClassNames(String jarPath, String packageName) throws IOException {
        JarEntry jarEntry;
        File file;
        if (jarPath == null) {
            return new String[0];
        }
        if (jarPath.startsWith("/") || jarPath.indexOf(58) >= 0 && File.separatorChar == '\\') {
            file = new File(jarPath);
        } else {
            String workingDir = System.getProperty("user.dir");
            file = new File(workingDir + File.separator + jarPath);
        }
        ArrayList<String> classNames = new ArrayList<String>();
        String packagePath = packageName.replaceAll("\\.", "/");
        JarInputStream jarFile = new JarInputStream(new FileInputStream(file));
        while ((jarEntry = jarFile.getNextJarEntry()) != null) {
            String name = jarEntry.getName();
            if (!name.startsWith(packagePath) || !name.endsWith(CLASSFILE_EXTENSION)) continue;
            int endIndex = name.length() - 6;
            name = name.replaceAll("/", "\\.");
            name = name.substring(0, endIndex);
            classNames.add(name);
        }
        jarFile.close();
        return classNames.toArray(new String[0]);
    }

    static class TestClassFilter
    implements FileFilter {
        private static final String TESTS_CODE_INDICATOR = "Test";

        TestClassFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            String pathToCheck = pathname.getName();
            return !pathToCheck.contains(TESTS_CODE_INDICATOR) && pathToCheck.endsWith(ClasspathScanLoadHelper.CLASSFILE_EXTENSION);
        }
    }
}

