/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.parser.jopt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSpecBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.management.internal.cli.MultipleValueConverter;
import org.apache.geode.management.internal.cli.exceptions.CliCommandOptionException;
import org.apache.geode.management.internal.cli.exceptions.ExceptionGenerator;
import org.apache.geode.management.internal.cli.parser.Argument;
import org.apache.geode.management.internal.cli.parser.GfshOptionParser;
import org.apache.geode.management.internal.cli.parser.Option;
import org.apache.geode.management.internal.cli.parser.OptionSet;
import org.apache.geode.management.internal.cli.parser.preprocessor.Preprocessor;
import org.apache.geode.management.internal.cli.parser.preprocessor.PreprocessorUtils;
import org.apache.geode.management.internal.cli.parser.preprocessor.TrimmedInput;
import org.apache.geode.management.internal.cli.util.HyphenFormatter;

public class JoptOptionParser
implements GfshOptionParser {
    private OptionParser parser;
    private LinkedList<Argument> arguments = new LinkedList();
    private LinkedList<Option> options;

    public JoptOptionParser() {
        this.parser = new OptionParser(true);
        this.parser.allowsUnrecognizedOptions();
    }

    @Override
    public void setArguments(LinkedList<Argument> arguments) {
        LinkedList<Argument> optional = new LinkedList<Argument>();
        for (Argument argument : arguments) {
            if (argument.isRequired()) {
                this.arguments.add(argument);
                continue;
            }
            optional.add(argument);
        }
        for (Argument argument : optional) {
            this.arguments.add(argument);
        }
    }

    @Override
    public void setOptions(LinkedList<Option> options) {
        this.options = options;
        for (Option option : options) {
            this.addJoptOptionObject(option);
        }
    }

    private void addJoptOptionObject(Option option) {
        OptionSpecBuilder optionBuilder = null;
        optionBuilder = this.parser.acceptsAll(option.getAggregate(), option.getHelp());
        ArgumentAcceptingOptionSpec argumentSpecs = null;
        argumentSpecs = option.isWithRequiredArgs() ? optionBuilder.withRequiredArg() : optionBuilder.withOptionalArg();
        if (option.getValueSeparator() != null) {
            argumentSpecs.withValuesSeparatedBy(option.getValueSeparator());
        }
    }

    @Override
    public OptionSet parse(String userInput) throws CliCommandOptionException {
        OptionSet optionSet = new OptionSet();
        optionSet.setUserInput(userInput != null ? userInput.trim() : "");
        if (userInput != null) {
            TrimmedInput input = PreprocessorUtils.trim(userInput);
            String[] preProcessedInput = this.preProcess(new HyphenFormatter().formatCommand(input.getString()));
            joptsimple.OptionSet joptOptionSet = null;
            CliCommandOptionException ce = null;
            try {
                joptOptionSet = this.parser.parse(preProcessedInput);
            }
            catch (OptionException e) {
                ce = this.processException(e);
            }
            if (joptOptionSet != null) {
                String unknownString;
                if (joptOptionSet.nonOptionArguments().size() > this.arguments.size() && (unknownString = (String)joptOptionSet.nonOptionArguments().get(this.arguments.size())).matches("^-*\\w+=.*$")) {
                    unknownString = unknownString.substring(0, unknownString.indexOf(61));
                }
                StringBuffer argument = new StringBuffer();
                int j = 0;
                for (int i = 0; i < joptOptionSet.nonOptionArguments().size() && j < this.arguments.size(); ++i) {
                    if (!PreprocessorUtils.isSyntaxValid((argument = argument.append(joptOptionSet.nonOptionArguments().get(i))).toString()).booleanValue()) continue;
                    optionSet.put(this.arguments.get(j), argument.toString());
                    ++j;
                    argument.delete(0, argument.length());
                }
                if (argument.length() > 0) {
                    optionSet.put(this.arguments.get(j), argument.toString());
                }
                block3: for (Option option : this.options) {
                    List<String> synonyms = option.getAggregate();
                    for (String string : synonyms) {
                        if (!joptOptionSet.has(string)) continue;
                        boolean present = false;
                        block5: for (String inputSplit : preProcessedInput) {
                            if (!inputSplit.startsWith("--")) continue;
                            inputSplit = StringUtils.removeStart((String)inputSplit, (String)"--");
                            if ((inputSplit = StringUtils.removeEnd((String)inputSplit, (String)"=")).equals("")) continue;
                            if (option.getLongOption().equals(inputSplit)) {
                                present = true;
                                break;
                            }
                            for (String optionSynonym : option.getSynonyms()) {
                                if (!optionSynonym.equals(inputSplit)) continue;
                                present = true;
                                break block5;
                            }
                        }
                        if (!present) continue;
                        if (joptOptionSet.hasArgument(string)) {
                            List arguments = joptOptionSet.valuesOf(string);
                            if (arguments.size() > 1 && !(option.getConverter() instanceof MultipleValueConverter) && option.getValueSeparator() == null) {
                                ArrayList<String> optionList = new ArrayList<String>(1);
                                optionList.add(string);
                                continue block3;
                            }
                            if (arguments.size() == 1 && !(option.getConverter() instanceof MultipleValueConverter) || option.getValueSeparator() == null) {
                                optionSet.put(option, arguments.get(0).toString().trim());
                                continue block3;
                            }
                            StringBuffer value = new StringBuffer();
                            String valueSeparator = option.getValueSeparator();
                            for (Object object : joptOptionSet.valuesOf(string)) {
                                if (value.length() == 0) {
                                    value.append((String)object);
                                    continue;
                                }
                                if (valueSeparator != null) {
                                    value.append(valueSeparator + ((String)object).trim());
                                    continue;
                                }
                                value.append(((String)object).trim());
                            }
                            optionSet.put(option, value.toString());
                            continue block3;
                        }
                        optionSet.put(option, option.getSpecifiedDefaultValue());
                        continue block3;
                    }
                }
            }
            ArrayList<String> split = new ArrayList<String>();
            for (int i = 0; i < preProcessedInput.length; ++i) {
                split.add(preProcessedInput[i]);
            }
            optionSet.setNoOfSpacesRemoved(input.getNoOfSpacesRemoved());
            optionSet.setSplit(split);
            if (ce != null) {
                ce.setOptionSet(optionSet);
                throw ce;
            }
        }
        return optionSet;
    }

    private CliCommandOptionException processException(OptionException exception) {
        return ExceptionGenerator.generate(this.getOption(exception), exception);
    }

    private Option getOption(OptionException oe) {
        Option exceptionOption = null;
        Iterator iterator = oe.options().iterator();
        block0: for (Option option : this.options) {
            for (String string : option.getAggregate()) {
                while (iterator.hasNext()) {
                    String joptOption = (String)iterator.next();
                    if (!string.equals(joptOption)) continue;
                    exceptionOption = option;
                    break block0;
                }
            }
        }
        if (exceptionOption == null && oe.options() != null && oe.options().size() > 0) {
            exceptionOption = new Option((String)oe.options().iterator().next());
        }
        return exceptionOption;
    }

    private String[] preProcess(String userInput) {
        return Preprocessor.split(userInput);
    }

    @Override
    public LinkedList<Argument> getArguments() {
        return this.arguments;
    }

    @Override
    public LinkedList<Option> getOptions() {
        return this.options;
    }
}

